/**************************************************************************
# Copyright (C) 1994 Kubota Graphics Corp.
# 
# Permission to use, copy, modify, and distribute this material for
# any purpose and without fee is hereby granted, provided that the
# above copyright notice and this permission notice appear in all
# copies, and that the name of Kubota Graphics not be used in
# advertising or publicity pertaining to this material.  Kubota
# Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
# OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
# "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
# EXPRESS OR IMPLIED.
**************************************************************************/

/*  This file contains all the macro definitions for the run-time 
    error messages used by Dore.  The actual file used at run time
    is $(DORE_LOC)/dore/src/data/errmsg/errmsgfile.  It is 
    generated by $(DORE_LOC)/dore/src/data/errmsg/makefile, using 
    this file (error.h) and the awk script 
    $(DORE_LOC)/dore/src/data/errmsg/error_filter.


    When you need to add a new error message, add it to the end of 
    this list with the message in comments - all on the same line.  
    The first word in the comments is the severity value for that 
    error where 0 = warning, 1 = severe, and 2 = fatal.

    Then, type "make" in {DORE_LOC}/dore/src/data/errmsg to create
    the file errmsgfile
*/

#define ERR_BAD_ERROR_NUMBER     1   /* 0 Unknown error number */
#define ERR_BAD_ERROR_MSG_FILE   2   /* 0 Can't find error message file: */
#define ERR_GROUP_NOT_OPEN       3   /* 0 A group is not currently open */
#define ERR_GROUP_OPEN           4   /* 0 A group is currently open */
#define ERR_CANT_FIND_FST_LAB    5   /* 0 Unable to find first label */
#define ERR_CANT_FIND_SND_LAB    6   /* 0 Unable to find second label */
#define ERR_BAD_OBJECT           7   /* 0 Invalid or deleted object */
#define ERR_BAD_FLAG_VALUE       9   /* 0 Bad flag value */
#define ERR_BAD_POS_TYPE_VALUE  10   /* 0 Bad position type value */
#define ERR_NEGITIVE_LIST_SIZE  11   /* 0 Negative list size */
#define ERR_BAD_MODE_VALUE      12   /* 0 Bad mode value */
#define ERR_BAD_START_OR_COUNT  13   /* 0 Bad start and/or count values */
#define ERR_BAD_INDEX_OR_LIST   14   /* 0 Non-positive index or list size */
#define ERR_INVALID_DEVICE      15   /* 0 Invalid device handle */
#define ERR_INVALID_FRAME       16   /* 0 Invalid frame handle */
#define ERR_INVALID_VIEW        17   /* 0 Invalid view handle */
#define ERR_INVALID_GROUP       18   /* 0 Invalid group handle */
#define ERR_INVALID_SLOT        19   /* 0 Invalid slot handle */
#define ERR_INVALID_CALLBACK    20   /* 0 Invalid callback object */
#define ERR_INVALID_PATH_ORDER  21   /* 0 Invalid pick path order */
#define ERR_INVALID_COLORTYPE   22   /* 0 Invalid color type */
#define ERR_CANT_ALLOC_DEVICE   23   /* 1 Unable to allocate device */
#define ERR_CANT_ALLOC_MEM      24   /* 1 Unable to allocate memory */
#define ERR_CANT_ALLOC_MEM_SIZE 24   /* 1 Unable to allocate memory of size */
#define ERR_VALUE_OUT_OF_RANGE  25   /* 0 Value out of range */
#define ERR_INVALID_CAMERA      26   /* 0 Invalid camera handle */
#define ERR_NO_TRAVERSAL        27   /* 0 No traversal in progress */
#define ERR_OBJ_NAME_IN_USE     28   /* 0 Object name already in use */
#define ERR_INVALID_DATAOBJECT	29   /* 0 Invalid dataobject handle */
#define ERR_RECURSIVE_EXECUTION 30   /* 0 Unable to recursively execute */
#define ERR_MULTIPLE_TRAVERSAL  31   /* 0 Traversal already in progress */
#define ERR_BAD_CURVE_INTERVAL  32   /* 1 Bad curve interval */
#define ERR_BAD_CURVE_ORDER     33   /* 1 Bad curve order */
#define ERR_BAD_DEVICE_OPT	34   /* 1 Bad option specified to device */
#define ERR_BAD_DEVICE_OPT_VAL	35   /* 1 Bad option value specified to device*/
#define ERR_BAD_VERTEX_TYPE	36   /* 0 Bad vertex type */
#define ERR_BOX_NOT_EMPTY	37   /* 1 Ray intersect box not empty */
#define ERR_CANT_DECR_OBJ_TYPES	38   /* 1 Cannot reduce number of object types */
#define ERR_CANT_INIT_REMOTE	39   /* 0 Cannot initialize remote server */
#define ERR_CANT_INVERT_MATRIX	40   /* 1 Singular matrix - cannot invert */
#define ERR_CANT_LOAD_DEF_FONT	41   /* 2 Cannot load default font */
#define ERR_CANT_POP_MATRIX	42   /* 0 Cannot pop matrix */
#define ERR_CANT_POP_STACK	43   /* 0 Cannot pop stack */
#define ERR_DEGEN_LOKATFRM	44   /* 0 Degenerate lookatfrom specification */
#define ERR_DEVICE_SYSTEM_ACCESS 45  /* 0 Device system access error */
#define ERR_FATAL_INTERNAL_ERROR 46  /* 2 Internal error */
#define ERR_FATAL_IO_ERROR	47   /* 2 I/O error */
#define ERR_FUNCTION_DISABLED	48   /* 0 Function disabled due to compile options. */
#define ERR_INVALID_CLASS	49   /* 0 Invalid class handle */
#define ERR_INVALID_MATRIX_OBJECT 50 /* 0 Invalid matrix object handle */
#define ERR_INVALID_METHOD	51   /* 2 Invalid method */
#define ERR_INVALID_OBJ_TYPE	52   /* 2 Invalid object type */
#define ERR_INVALID_OPERATION	53   /* 1 Invalid operation */
#define ERR_INVALID_PCK_CB_RTN_STATUS 54 /* 0 Invalid return status from pick callback */
#define ERR_INVALID_SET_OP	55   /* 2 Invalid set operation */
#define ERR_INVALID_VISUAL_TYPE	56   /* 1 Invalid visual type */
#define ERR_IO_ERROR		57   /* 0 I/O error */
#define ERR_NEG_LIGHT_INT	58   /* 0 Negative light intensity */
#define ERR_NON_NULL_LCSTOWCS	59   /* 1 Non-NULL lcstowcsmat */
#define ERR_NON_SQUARE_MATRIX	60   /* 0 Non-square matrix */
#define ERR_NO_CURRENT_VALUE	61   /* 0 No current value of attribute */
#define ERR_NO_OUTPUT_MODULE	62   /* 0 Device does not support output module for */
#define ERR_NULL_LCSTOWCS	63   /* 1 NULL local-to-world transformation matrix */
#define ERR_SEVERE_INTERNAL_ERROR 64 /* 1 Internal error */
#define ERR_SLOT_QUEUE_OVERFLOW	65   /* 0 Slot queue overflow; event lost */
#define ERR_SOCKET_FAILURE	66   /* 0 Socket failure */
#define ERR_UNDEF_METHOD	67   /* 0 Undefined method */
#define ERR_UNIMPLEMENTED_SEVERE 68  /* 1 Unimplemented function */
#define ERR_UNIMPLEMENTED_WARNING 69 /* 0 Unimplemented function */
#define ERR_UNKNOWN_HOST	70   /* 0 Unknown host */
#define ERR_UNKNOWN_SERVICE	71   /* 0 Unknown service */
#define ERR_WARN_ALLOC_FAILED	72   /* 0 Unable to allocate memory of size */
#define ERR_ZERO_LEN_VEC	73   /* 0 Zero length normal vector */
#define ERR_ZERO_SUBDIVSPEC	74   /* 0 Subdivision spec equals zero */
#define ERR_ZERO_TRI_NRM_SUM	75   /* 0 Triangle normals sum to 0 at vertex; check for back to back triangles */
#define ERR_OBSOLETE_FUNCTION	76   /* 0 Old function; replaced by */
#define ERR_CANT_CREATE_ALTOBJ	77   /* 0 Cannot create alternate object */
#define ERR_INVALID_RASTER	78   /* 0 Invalid raster handle */
#define ERR_FUNCTION_CHANGED    79   /* 1 Function not supported anymore; instead use */
#define ERR_ZERO_QUAD_NRM_SUM	80   /* 0 Quad normals sum to 0 at vertex, check for back to back quads */
#define ERR_RAD_NOT_INSTALLED   81   /* 1 Radiosity not initialized */
#define ERR_RAD_BAD_FF_CMPTYP   82   /* 0 Bad DvInqFormFactorCompType value */
#define ERR_RAD_CANT_GET_PIX    83   /* 1 DdInqPixelData can't return pixel data*/
#define ERR_RAD_NO_DATA_INDEX   84   /* 1 Can't return additional data index */
#define ERR_RAD_CANT_INSTALL    85   /* 1 Can't initialize radiosity renderer */
#define ERR_RAD_CAP_EXCEEDED    86   /* 1 Too many patches */
#define ERR_RAD_BAD_ADD_DATASET 87   /* 0 Bad additional-data set */
#define ERR_RAD_BAD_PIXELVALUE  88   /* 1 Bad pixel value */
#define ERR_RAD_ZERO_AREA       89   /* 1 Area of patch is zero */
#define ERR_RAD_TOO_FEW_VERT    90   /* 1 Too few vertices */
#define ERR_EXEC_NULL_OBJ       91   /* 0 Attempt to execute null object */
#define ERR_DORE_ALREADY_INIT   92   /* 0 Can't initialize Dore' more than once */
#define ERR_DTREAL_CONFLICT     93   /* 2 Dore' library & application disagree on DtReal precision */

/* ====================================================================== */

void  DDerror         (DtInt number, char* funcname, char* string);
char* DDerror_GetLine (void);
