/******
  
  muscles.c:	sets up the muscles data structures
  
  
  
  *******/

#include <forms.h>
#include <stdio.h>
#include <math.h>
#include "muscles.h"
#include "standard.h"
#include "proto.h"

/*** setup_muscles() ***/
void setup_muscles(char *file,struct muscle *mscle,float *face)
{
    
    FILE 	*in_fp;
    int		num_musc;
    int		x,y,z;
    int		i;
    
    
    if (file == NULL) {
	for (i=0;i<NUM_MUSCLES;i++) {
	    mscle[i].start_vrtx = -666;
	    mscle[i].end_vrtx = -666;
	}
	return;
    }
    
    printf("Opening %s for Muscle Input \n",file);
    in_fp = fopen(file,"r");
    if (in_fp==NULL) {
	printf("Error Opening Muscle file <%s> \n",file);
	exit(-1);
    }
    
    fscanf(in_fp,"%d",&num_musc);
    if (num_musc!=NUM_MUSCLES) {
	printf("I am hardwired for stupidity..I must have 14 \n");
	exit(-1);
    }
    
    for (i=0; i<num_musc; i++)  {
	fscanf(in_fp,"%d%d",&mscle[i].start_vrtx, &mscle[i].end_vrtx );
    }
    fclose(in_fp);
    
    
    sprintf(mscle[0].title," Left Zygomatic major ");
    sprintf(mscle[1].title," Right Zygomatic major ");
    sprintf(mscle[2].title," Left Anguli Depressor ");
    sprintf(mscle[3].title," Right Agnuli Depressor ");
    sprintf(mscle[4].title," Inner-Left Frontalis ");
    sprintf(mscle[5].title," Inner-Right Frontalis ");
    sprintf(mscle[6].title," Outer-Left Frontalis ");
    sprintf(mscle[7].title," Outer-Right Frontalis ");
    sprintf(mscle[8].title," Left Labii ");
    sprintf(mscle[9].title," Right Labii ");
    sprintf(mscle[10].title," Left Corrugator ");
    sprintf(mscle[11].title," Right Corrugator ");
    sprintf(mscle[12].title," Nasi ");
    sprintf(mscle[13].title," Lateral Corrugator ");
    sprintf(mscle[14].title," Left Frontalis Major ");
    sprintf(mscle[15].title," Right Frontalis Major ");
    
    
    
    /* Make better colours */
    
    mscle[0].color = CON_RGB(0,255,255); 
    mscle[1].color = CON_RGB(0,255,255); 
    mscle[2].color = CON_RGB(0,0,255);
    mscle[3].color = CON_RGB(0,0,255); 
    mscle[4].color = CON_RGB(0,255,0); 
    mscle[5].color = CON_RGB(0,255,0); 
    mscle[6].color = CON_RGB(255,255,0); 
    mscle[7].color = CON_RGB(255,255,0); 
    mscle[8].color = CON_RGB(255,0,255); 
    mscle[9].color = CON_RGB(255,0,255); 
    mscle[10].color = CON_RGB(123,0,168); 
    mscle[11].color = CON_RGB(123,0,168); 
    mscle[12].color = CON_RGB(255,130,0); 
    mscle[13].color = CON_RGB(67,25,184); 
    mscle[14].color = CON_RGB(0,209,150); 
    mscle[15].color = CON_RGB(0,209,150); 
    
    
}


/*** init_sphinctor ***/
void	init_sphinctor(struct sphinctor *mouth)
{
    printf("init_sphinctor() \n");
    mouth->cx = 0.0;
    mouth->cy = -2.0;
    
    mouth->range = 1.0;		/* 0..2 */
    mouth->pout  = 2.5;		/* 0..5 */
    mouth->val  = 0.0;
    sprintf(mouth->title," Mouth Sphinctor");
    mouth ->color = CON_RGB(255,0,0);
    
}	




/*** init_muscles()	***/
void	init_muscles(float *face,struct muscle *mscle) {
    
    
    int	face_indx,i;	
    float	ftemp;
    
    if (DEBUGGING)
      printf("init_muscles() \n");
    
    /* These distances are all relative to the Waters face coords */
    /* Define Range of Effect of the Muscles */
    
    mscle[L_ZYGO].fall_strt = 	0.2;	/* zero */
    mscle[L_ZYGO].fall_end  =	5.5;
    mscle[L_ZYGO].theta	= 	30.0;
    
    
    mscle[R_ZYGO].fall_strt = 	0.2;	/* zero */
    mscle[R_ZYGO].fall_end  = 	5.5;
    mscle[R_ZYGO].theta	= 	30.0;
    
    
    mscle[L_ANGULI].fall_strt =  0.2;  /* one */
    mscle[L_ANGULI].fall_end  =	4.5;
    mscle[L_ANGULI].theta= 	55.0;
    
    
    mscle[R_ANGULI].fall_strt = 	0.2;  /* one */
    mscle[R_ANGULI].fall_end  = 	4.5;
    mscle[R_ANGULI].theta= 	55.0;
    
    
    mscle[IL_FRONT].fall_strt = 	0.2; /* two */
    mscle[IL_FRONT].fall_end  = 	4.0;
    mscle[IL_FRONT].theta= 	34.0;
    
    
    mscle[IR_FRONT].fall_strt = 	0.2; /* two ok */
    mscle[IR_FRONT].fall_end  = 	4.0;
    mscle[IR_FRONT].theta= 	34.0;
    
    
    mscle[OL_FRONT].fall_strt = 	0.2;  /* four ok*/
    mscle[OL_FRONT].fall_end  = 	3.75;
    mscle[OL_FRONT].theta= 	36.0;
    
    
    mscle[OR_FRONT].fall_strt = 	0.2;	/* four */
    mscle[OR_FRONT].fall_end  = 	3.75;
    mscle[OR_FRONT].theta= 	36.0;
    
    
    mscle[L_LABI].fall_strt = 	0.2;	/* five */
    mscle[L_LABI].fall_end  = 	4.5;	/* ????????? not in origianl ig.c */
    mscle[L_LABI].theta	= 	31.0;
    
    
    mscle[R_LABI].fall_strt =	0.2;	/* five */
    mscle[R_LABI].fall_end  = 	5.5;	/* not in original ig.c !!!!!! */
    mscle[R_LABI].theta	= 	31.0;
    
    
    mscle[NASI].fall_strt = 	0.2;	/* six ok */
    mscle[NASI].fall_end  = 	5.5;
    mscle[NASI].theta	= 	40.0;
    
    
    mscle[LAT_CORR].fall_strt = 	0.2;	/* seven ok */
    mscle[LAT_CORR].fall_end  = 	5.5;
    mscle[LAT_CORR].theta= 	40.0;
    
    
    mscle[L_CORR].fall_strt = 	0.2;	/* eight &ok*/
    mscle[L_CORR].fall_end  = 	4.6;
    mscle[L_CORR].theta	= 	54.0;
    
    
    mscle[R_CORR].fall_strt = 	0.2;	/* eight ok*/
    mscle[R_CORR].fall_end  = 	4.6;
    mscle[R_CORR].theta	= 	54.0;
    
    mscle[ML_FRONT].fall_strt = 	0.2;	/* eight ok*/
    mscle[ML_FRONT].fall_end  = 	2.0;
    mscle[ML_FRONT].theta= 	90; 
    
    mscle[MR_FRONT].fall_strt = 	0.2;	/* eight ok*/
    mscle[MR_FRONT].fall_end  = 	2.0;
    mscle[MR_FRONT].theta= 	90;
    
    
    /* Compute some handy info */
    /* Note: These muscles are attached to the face at rest and the
       deformations are applied to the location the muscle is at when the face
       is at rest. */
    
    
    
    
    for (i=0; i<= NUM_MUSCLES; i++) {
	face_indx = mscle[i].start_vrtx*3-2;
	bcopy(&face[face_indx],mscle[i].start,sizeof(float)*3);
	
	face_indx = mscle[i].end_vrtx*3-2;
	bcopy(&face[face_indx],mscle[i].end,sizeof(float)*3);
	
    }
    
    /* Do a patch to Frontalis muscle to make it look better ?*/
    mscle[MR_FRONT].start[0] += 0.01;
    mscle[MR_FRONT].start[1] += 0.10;
    mscle[MR_FRONT].start[2] += 0.01;
    
    mscle[MR_FRONT].end[0] += 0.01;
    mscle[MR_FRONT].end[1] += 0.01;
    mscle[MR_FRONT].end[2] += 0.01;
    
    mscle[ML_FRONT].start[0] += 0.01;
    mscle[ML_FRONT].start[1] += 0.10;
    mscle[ML_FRONT].start[2] += 0.01;
    
    mscle[ML_FRONT].end[0] += 0.01;
    mscle[ML_FRONT].end[1] += 0.01;
    mscle[ML_FRONT].end[2] += 0.01;
    
    
    for (i=0; i<= NUM_MUSCLES; i++) {
	/*maybe these need opposite sign ?? */
	mscle[i].lenx = mscle[i].start[0] - mscle[i].end[0];
	mscle[i].leny = mscle[i].start[1] - mscle[i].end[1];
	mscle[i].lenz = mscle[i].start[2] - mscle[i].end[2];
	
	
	mscle[i].legth=SQR(mscle[i].lenx)+SQR(mscle[i].leny)+SQR(mscle[i].lenz);
	mscle[i].legth= fsqrt(mscle[i].legth);
	
	
    }
    
}    


/*** void init_params(param_vals *) ***/
void init_params(param_vals *param)
{
    
    /* This adds a scaling factor for each muscle/jaw/eye.. parameter
       that is inputed via FORMS widgets...this allows all parameters
       to be expressed by the user in 0...1 space */
    
    printf("Initializing Parameter Scaling Factors \n");
    
    param[ L_ZYGO].scale = .650;
    param[ R_ZYGO].scale = .650;
    
    param[ L_ANGULI].scale = 1.0;
    param[ R_ANGULI].scale = 1.0;
    
    param[ IL_FRONT].scale = .80;
    param[ IR_FRONT].scale = .80;
    
    param[ OL_FRONT].scale = 1.2;
    param[ OR_FRONT].scale = 1.2;
    
    param[ L_LABI].scale = 0.80;
    param[ R_LABI].scale = 0.80;
    
    param[ L_CORR].scale = 0.8;
    param[ R_CORR].scale = 0.8;
    
    param[ NASI].scale = 0.600;
    param[ LAT_CORR].scale = 0.60;
    
    param[ ML_FRONT].scale = 0.30; 
    param[ MR_FRONT].scale = 0.30; 
    
    param[ LIP_Z].scale = 2.0;
    param[ LIP_Y].scale = 1.5;
    param[ JAW].scale = 1.5;
}


/*** print_muscle - given a pointer to muscle structure print info ***/
void	print_muscle(struct muscle *msc)
{
    
    printf("Muscle Name \t : %s \n",msc->title);
    printf("Start Coord\t (%5.3f , %5.3f, %5.3f )\n",
	   msc->start[0], msc->start[1], msc->start[2]);
    
    printf("End Coord\t (%5.3f , %5.3f, %5.3f )\n",
	   msc->end[0], msc->end[1], msc->end[2]);
    
    
    printf("Start Vertex = %d    End Vertex = %d\n",
	   msc->start_vrtx,msc->end_vrtx);
    printf("Length = <%5.3f %5.3f %5.3f> %5.3f \n",
	   msc->lenx,msc->leny,msc->lenz,msc->legth);
    
    printf("Fall Start = % 5.3f \t Fall End = %5.3f\n",msc->fall_strt,
	   msc->fall_end);
    
    printf("Theta = %5.3f \n",msc->theta);
}
