/** This contains all the IPC routines for use by both the client
  and server 
  IPC2.c is an InterNet version

  Steve Franks		Sony Computer Science Lab
  March 92
**/


/*#define STANDALONE /**/
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <fcntl.h>

#define SERVER_PORT	(IPPORT_USERRESERVED + 124)

#include "IPC.h"
#include <errno.h>

/*** setup_server_IPC -- setup the interprocess communication stuff ***/
int setup_server_IPC()
{
    
    int		sock,msgsock;
    struct sockaddr_un server;
    char 	buf[1024];
    char	com[50];
    
   
    int length;
    struct sockaddr_in sin;
    
    /* create a socket */
    sock = socket (AF_INET,SOCK_STREAM,0);
    if (sock < 0) {
	perror("Error opening socket");
	exit(1);
    }
    
    
    /* initialize socket address structure */
    
    bzero((char *) &sin, sizeof(sin));
    sin.sin_family = AF_INET;
    sin.sin_port = htons(SERVER_PORT);
    sin.sin_addr.s_addr = INADDR_ANY;
    
    /* bind socket data structure to this socket */
    
    if (bind (sock,&sin,sizeof(sin))) {
	perror("Error binding socket");
	close(sock);
	exit(1);
    }
    
    /* prepare socket queue for connection requests and accept
       connections */
    
    listen(sock,5);
    
    length = sizeof(sin);
    msgsock = accept(sock, &sin, &length);
    if (msgsock < 0) {
	perror("accept");
	close(sock);
	exit(1);
    }
    
    printf("Connection from host %s, port %u\n",
	   inet_ntoa(sin.sin_addr), ntohs(sin.sin_port));
    fflush(stdout);
    
    close(sock);
    
    
    printf("Returning Socket #%d \n",msgsock);
    return(msgsock);
    
}	




/*** setup_client_IPC -- client IPC initialization ***/
int setup_client_IPC()
{
    
    
    int i;
    int sock;
    struct sockaddr_un server;
    char *hostname;
    struct hostent *hp;
    struct sockaddr_in sin;
    int msgsock;
    int length;
    
    
    hostname = "asura";
    
    /* create a socket */
    sock = socket (AF_INET,SOCK_STREAM,0);
    if (sock < 0) {
	perror("Error opening socket");
	exit(1);
    }
    
    
    /* initialize socket address structure */
    bzero((char *) &sin, sizeof(sin));
    sin.sin_family = AF_INET;
    sin.sin_port = htons(SERVER_PORT);
    
    hp = gethostbyname(hostname);
    if (hp == NULL) {
	herror(hostname);
	exit(1);
    }
    bcopy (hp->h_addr, &(sin.sin_addr.s_addr), hp->h_length);
    
    /* connect to remote host */
    
    if (connect(sock,&sin,sizeof(sin)) < 0) {
	close(sock);
	perror("Can't connect to server");
	exit(1);
    }
    printf("Connection established\n");
    fflush(stdout);
    return(sock);
}	



/*** close_server_IPC() - server closes and cleans up the socket ***/
void close_server_IPC()
{


}



/*** send_data_packet -- put data over a Unix domain socket ***/
void send_data_packet(int skt,packet_format *buff, int buff_siz)
{
    
    if (write(skt,buff,buff_siz) < 0) {
	perror("Client: Write on INET Socket");
    }


}



/*** receive_data_packet - receive data on a Unix socket ***/
int receive_data_packet(int skt,packet_format *buff, int buff_siz)
{

    int		cc,flags;

    bzero(buff,buff_siz);
    cc= read(skt,buff,buff_siz);
    if (cc==-1) {
	perror("Reading From  Port");
    }
    return(cc);

}



/*** print_data_packet - debugging routine to peek a at packets ***/
void print_data_packet(packet_format *d)
{
    int		i;

    printf("\n");
    
    for (i=0;i<3; i++) {
	printf("%5.4f\t",d->param[i]);
    }
    printf("\n");
}
