#include <Foundation/NSAutoreleasePool.h>
#include <GToolKit/GToolKit.h>

static GTKText *text;

@interface Foo : NSObject
{
    GTKFileSelection *filesel;
}
- (void) openFile:sender;
- (void) help:sender;
- (void) ok:sender;
- (void) cancel:sender;
- (gint) close:sender;
- (BOOL) applicationShouldTerminate:(GTKApplication *) sender;
@end

@implementation Foo

- (void) openFile:sender
{
    if (filesel) return;

    filesel = [GTKFileSelection fileSelectionWithTitle:@"Choose a File..."];

    [[filesel okButton] connectSignal:@"clicked" withTarget:self
	sel:@selector(ok:)];
    [[filesel cancelButton] connectSignal:@"clicked" withTarget:self
	sel:@selector(cancel:)];
    [filesel show];
}

- (void) help:sender
{
    GTKRunMessageBox(@"Oops", @"No help available!", @"Cry", @"Ignore",
		     @"Panic");
}

- (void) ok:sender
{
    NSString *file = [[[NSString alloc] initWithContentsOfFile:
			[filesel getFilename]] autorelease];

    [filesel destroy];
    filesel = nil;

    if (file)
    {
	[text deleteText:0 endPos:-1];
	[text insert:NULL fore:NULL back:NULL chars:file length:-1];
    }
}

- (void) cancel:sender
{
    [filesel destroy];
    filesel = nil;
}

- (gint) close:sender
{
    [GTKApp terminate:self];
    return YES;			// return YES => cancel window close
}

- (BOOL) applicationShouldTerminate:(GTKApplication *) sender
{
    static int bar;

    if (bar++) return YES;

    GTKRunMessageBox(nil, @"--==>> Try again <<==--", @"Continue", nil, nil);
    return NO;
}
@end

int main (int argc, char *argv[])
{
    NSAutoreleasePool *pool = [NSAutoreleasePool new];
    Foo *foo = [[Foo new] autorelease];
    GTKWindow *window;
    GTKVBox * box;
    GTKMenuBar *menubar;
    GTKMenuItem *item;
    GTKMenu *menu;
#ifdef LIB_FOUNDATION_LIBRARY
    extern char **environ;
    [NSProcessInfo initializeWithArguments:argv count:argc environment:environ];
#endif

    [[GTKApplication alloc] initWithArgc:&argc argv:&argv];
    [GTKApp setDelegate:foo];

    window = [GTKWindow windowWithType:GTK_WINDOW_TOPLEVEL];
    box = [GTKVBox vBoxWithHomogeneous:NO spacing:0];
    menubar = [GTKMenuBar menuBar];
    text = [GTKText textWithHadj:nil vadj:nil];
    menu = [GTKMenu menu];

    item = [GTKMenuItem menuItemWithLabel:@"File"];
    [item setSubmenu:menu];
    [menubar append:item];
    item = [GTKMenuItem menuItemWithLabel:@"Help"];
    [item connectSignal:@"activate" withTarget:foo sel:@selector(help:)];
    [item rightJustify];
    [menubar append:item];

    item = [GTKMenuItem menuItemWithLabel:@"Open..."];
    [item connectSignal:@"activate" withTarget:foo sel:@selector(openFile:)];
    [menu append:item];
    [menu append:[GTKMenuItem menuItem]];
    item = [GTKMenuItem menuItemWithLabel:@"Close"];
    [item connectSignal:@"activate" withTarget:window
	  sel:@selector(emit:signal:) data:@"delete_event"];
    [menu append:item];

    [box packStart:menubar expand:NO fill:YES padding:0];
    [box packStartDefaults:text];
    [text setEditable:YES];

    [window connectSignal:@"delete_event" withTarget:foo sel:@selector(close:)];
    [window setUsize:400 height:240];
    [window add:box];
    [window show];

    [GTKApp run];
    [pool release];
    return 0;
}
