#include <ctype.h>
#include <stdio.h>

#include <GToolKit/GToolKit.h>
#include "Calc.h"

@interface Calc (Private)
- (id) cpu;			// wenn mglich: value[0] op= value[1]
@end

@implementation Calc (Private)

- (id) cpu
{
    if (state)
	switch (op)
	{
	    case '+':   value[0] += value[1];
			break;
	    case '-':   value[0] -= value[1];
			break;
	    case '*':   value[0] *= value[1];
			break;
	    case '/':   if (value[1])
			    value[0] /= value[1];
			else
			    value[0] |= ~0U >> 1;
	}
    return self;
}
@end

@implementation Calc

- (void) setTarget:(id) _target
{
    target = _target;
}

- (void) gate:(id) sender
{
    char key;

    if (! [sender isKindOfClass: [GTKButton class]]) return;
    key = [sender tag];

    switch (key)
    {
	case 'Q':
	case '\0':  exit(0);			// Schlu
	default:    if (isdigit(key))		// Ziffern sammeln
		    {
			value[state] *= 10;
			value[state] += key - '0';
			[target setIntValue:value[state]];
		    }
		    break;			// Rest ignorieren
	case '+':				// addieren
	case '-':				// subtrahieren
	case '*':				// multiplizieren
	case '/':   [self cpu];			// dividieren
						// letzten Operator verwenden
		    if (state)			// ...und Wert ausgeben
			[target setIntValue:value[0]];
		    else
			state = 1;		// so oder so, im Zustand 1...
		    value[1] = 0;		// neuen Wert berechnen...
		    op = key;			// und Operator notieren
		    break;
	case 'C':   value[state] = 0;		// lschen
		    [target setIntValue:value[state]];
		    break;
	case '=':   [self cpu];			// Summe
						// letzten Operator verwenden
		    [target setIntValue:value[0]];
		    state = 0;
		    value[0] = 0;		// neu anfangen
    }
}
@end
