%module _gdkimlib

%{
#include <gtk/gtk.h>
#include <gdk_imlib.h>
%}

%include gdkimlibmain.i
%include gdkimlibtypemap.i

int gdk_imlib_get_render_type();
void gdk_imlib_set_render_type(int rend_type);
int gdk_imlib_load_colors(char *file);
GdkImlibImage *gdk_imlib_load_image(char *file);
int gdk_imlib_render(GdkImlibImage *image, int width, int height);
void gdk_imlib_free_colors();
void gdk_imlib_get_image_border(GdkImlibImage *image, GdkImlibBorder *oborder);
void gdk_imlib_set_image_border(GdkImlibImage *image, GdkImlibBorder *border);
void gdk_imlib_get_image_shape(GdkImlibImage *image, GdkImlibColor *ocolor);
void gdk_imlib_set_image_shape(GdkImlibImage *image, GdkImlibColor *color);
int gdk_imlib_save_image_to_eim(GdkImlibImage *image, char *file);
int gdk_imlib_add_image_to_eim(GdkImlibImage *image, char *file);
int gdk_imlib_save_image_to_ppm(GdkImlibImage *image, char *file);
void gdk_imlib_set_image_modifier(GdkImlibImage *im,
				  GdkImlibColorModifier *mod);
void gdk_imlib_set_image_red_modifier(GdkImlibImage *im,
				      GdkImlibColorModifier *mod);
void gdk_imlib_set_image_green_modifier(GdkImlibImage *im,
					GdkImlibColorModifier *mod);
void gdk_imlib_set_image_blue_modifier(GdkImlibImage *im,
				       GdkImlibColorModifier *mod);
void gdk_imlib_get_image_modifier(GdkImlibImage *im,
				  GdkImlibColorModifier *omod);
void gdk_imlib_get_image_red_modifier(GdkImlibImage *im,
				      GdkImlibColorModifier *omod);
void gdk_imlib_get_image_green_modifier(GdkImlibImage *im,
					GdkImlibColorModifier *omod);
void gdk_imlib_get_image_blue_modifier(GdkImlibImage *im,
				       GdkImlibColorModifier *omod);

void gdk_imlib_set_image_red_curve(GdkImlibImage *im, char *mod);
void gdk_imlib_set_image_green_curve(GdkImlibImage *im, char *mod);
void gdk_imlib_set_image_blue_curve(GdkImlibImage *im, char *mod);
void gdk_imlib_get_image_red_curve(GdkImlibImage *im, char *omod);
void gdk_imlib_get_image_green_curve(GdkImlibImage *im, char *omod);
void gdk_imlib_get_image_blue_curve(GdkImlibImage *im, char *omod);

void gdk_imlib_apply_modifiers_to_rgb(GdkImlibImage *im);
void gdk_imlib_changed_image(GdkImlibImage *im);
void gdk_imlib_flip_image_horizontal(GdkImlibImage *im);
void gdk_imlib_flip_image_vertical(GdkImlibImage *im);
void gdk_imlib_rotate_image(GdkImlibImage *im, int d);
GdkImlibImage *gdk_imlib_clone_image(GdkImlibImage *im);
GdkImlibImage *gdk_imlib_clone_scaled_image(GdkImlibImage *im, int w, int h);
int gdk_imlib_get_fallback();
void gdk_imlib_set_fallback(int fallback);
char *gdk_imlib_get_sysconfig();

%{
static PyObject *gdk__imlib_best_color_match(PyObject *self, PyObject *args) {
  int r, g, b;
  if (!PyArg_ParseTuple(args, "iii:gdk_imlib_best_color_match", &r, &g, &b))
    return NULL;
  gdk_imlib_best_color_match(&r, &g, &b);
  return Py_BuildValue("(iii)", r, g, b);
}

static PyObject *gdk__imlib_make_pixmap(PyObject *self, PyObject *args) {
  GtkWidget *w;
  GdkPixmap *p;
  GdkBitmap *b;
  PyGdkImlibImage_Object *o;
  PyObject *ret;
  if (!PyArg_ParseTuple(args, "O!:gdk_imlib_make_pixmap",
			&PyGdkImlibImage_Type, &o))
    return NULL;
  p = gdk_imlib_move_image(PyGdkImlibImage_Get(o));
  b = gdk_imlib_move_mask(PyGdkImlibImage_Get(o));

  /* make the pixmap widget use imlib's visual and colormap */
  gtk_widget_push_visual(gdk_imlib_get_visual());
  gtk_widget_push_colormap(gdk_imlib_get_colormap());

  w = gtk_pixmap_new(p, b);

  /* pop imlib's visual and colormap */
  gtk_widget_pop_visual();
  gtk_widget_pop_colormap();

  gdk_imlib_free_pixmap(p);
  ret = PyGtk_New(GTK_OBJECT(w));
  if (ret == NULL)
    gtk_widget_unref(w);
  return ret;
}

#define gdk_imlib_get_rgb_width(im)  ((im)->rgb_width)
#define gdk_imlib_get_rgb_height(im) ((im)->rgb_height)
#define gdk_imlib_get_filename(im)   ((im)->filename)

%}
%native(gdk_imlib_best_color_match) PyObject *gdk__imlib_best_color_match(
					  PyObject *self, PyObject *args);
%native(gdk_imlib_make_pixmap) PyObject *gdk__imlib_make_pixmap(
					  PyObject *self, PyObject *args);
int gdk_imlib_get_rgb_width(GdkImlibImage *im);
int gdk_imlib_get_rgb_height(GdkImlibImage *im);
char *gdk_imlib_get_filename(GdkImlibImage *im);
