#ifndef STR
#define STR(x) # x
#endif
/* you must define some macros before including this file */

typedef struct {
	PyObject_HEAD
	OBJ_TYPE *obj;
} PYOBJ;

staticforward PyTypeObject PYOBJ_TYPE;

static PyObject *
PYOBJ_NEW(OBJ_TYPE *obj) {
  PYOBJ *self;

  self = (PYOBJ *)PyObject_NEW(PYOBJ, &PYOBJ_TYPE);
  if (self == NULL)
    return NULL;
  self->obj = obj;
  return (PyObject *)self;
}

static void
PYOBJ_DEL(PYOBJ *self) {
  OBJ_DEL(self->obj)
  PyMem_DEL(self);
}

static int
PYOBJ_CMP(PYOBJ *self, PYOBJ *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyTypeObject PYOBJ_TYPE = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,                              /*ob_size*/
  STR(OBJ_TYPE),                  /*tp_name*/
  sizeof(PYOBJ),                  /*tp_basicsize*/
  0,                              /*tp_itemsize*/
  (destructor)PYOBJ_DEL,          /*tp_dealloc*/
  (printfunc)0,                   /*tp_print*/
  (getattrfunc)0,                 /*tp_getattr*/
  (setattrfunc)0,                 /*tp_setattr*/
  (cmpfunc)PYOBJ_CMP,             /*tp_compare*/
  (reprfunc)0,                    /*tp_repr*/
  0,                              /*tp_as_number*/
  0,                              /*tp_as_sequence*/
  0,                              /*tp_as_mapping*/
  (hashfunc)0,                    /*tp_hash*/
  (ternaryfunc)0,                 /*tp_call*/
  (reprfunc)0,                    /*tp_str*/
  0L,0L,0L,0L,
  NULL
};

