#!/usr/bin/env python

# translation of "Hello World III" from GTK manual, using gtk_object_new
# with gtkmodule.  Also implements a tooltip for the button.

from gtk import *
from GTK import *

def hello(*args):
	print "Hello World"
	gtk_widget_destroy(window)

def destroy(*args):
	gtk_widget_hide(window)
	gtk_main_quit()

gtk_init()

tt = gtk_tooltips_new()
gtk_tooltips_set_delay(tt, 500)

window = gtk_object_new("GtkWindow", {
	'GtkWindow::type':            WINDOW_TOPLEVEL,
	'GtkWindow::title':           'Hello World',
	'GtkWindow::allow_grow':      0,
	'GtkWindow::allow_shrink':    0,
	'GtkObject::signal::destroy': destroy,
	'GtkContainer::border_width': 10
})

button = gtk_object_new("GtkButton", {
	'GtkButton::label': 'Hello World',
	'GtkObject::signal::clicked': hello,
	'GtkWidget::parent': window,
	'GtkWidget::visible': 1
})

gtk_tooltips_set_tip(tt, button, 'Prints "Hello World"', '')
gtk_tooltips_enable(tt)

gtk_widget_show(window)
gtk_main()

