%{
#include "sysmodule.h"

/* simple callback handler -- this one actually looks at the return type */
/* used for timeout and idle functions */
static void PyGtk_HandlerMarshal(gpointer a, PyObject *func, int nargs,
                                                          GtkArg *args) {
  PyObject *ret;

  ret = PyObject_CallObject(func, NULL);
  if (ret == NULL) {
    PyErr_Print();
    PyErr_Clear();
    *GTK_RETLOC_BOOL(args[0]) = FALSE;
    return;
  }
  if (ret == Py_None || (PyInt_Check(ret) && PyInt_AsLong(ret) == 0))
    *GTK_RETLOC_BOOL(args[0]) = FALSE;
  else
    *GTK_RETLOC_BOOL(args[0]) = TRUE;
  Py_DECREF(ret);
}

/* callback for input handlers */
static void PyGtk_InputMarshal(gpointer a, PyObject *func, int nargs,
			                                GtkArg *args) {
  PyObject *tuple, *ret;

  tuple = Py_BuildValue("(ii)", GTK_VALUE_INT(args[0]),
			GTK_VALUE_FLAGS(args[1]));
  ret = PyObject_CallObject(func, tuple);
  Py_DECREF(tuple);
  if (ret == NULL) {
    PyErr_Print();
    PyErr_Clear();
  } else
    Py_DECREF(ret);
}

static PyObject * gtk__init(PyObject *self, PyObject *args) {
    PyObject *av;
    int argc, i;
    char **argv;

    /* ensure that this procedure only gets run once */
    static int run_already = 0;
    if (run_already) {
        Py_INCREF(Py_None);
        return Py_None;
    }
    run_already = 1;

    if (!PyArg_ParseTuple(args, ":gtk_init"))
        return NULL;

    av = PySys_GetObject("argv");
    argc = PyList_Size(av);
    argv = malloc(argc * sizeof(char *));
    for (i = 0; i < argc; i++)
        argv[i] = strdup(PyString_AsString(PyList_GetItem(av, i)));

    gtk_init(&argc, &argv);
    PySys_SetArgv(argc, argv);

    if (argv != NULL) {
        for (i = 0; i < argc; i++)
            if (argv[i] != NULL)
                free(argv[i]);
        free(argv);
    }
    gtk_signal_set_funcs((GtkSignalMarshal)PyGtk_SignalMarshal,
                         (GtkSignalDestroy)PyGtk_SignalDestroy);
    Py_INCREF(Py_None);
    return Py_None;
}

static void PyGtk_init_types() {
    static int run_already = 0;
    if (run_already)
	return;
    run_already = 1;
    /* call gtk_*_get_type for each widget, so gtk_type_from_name works */
    gtk_adjustment_get_type();
    gtk_alignment_get_type();
    gtk_arrow_get_type();
    gtk_aspect_frame_get_type();
    gtk_bin_get_type();
    gtk_box_get_type();
    gtk_button_get_type();
    gtk_button_box_get_type();
    gtk_check_button_get_type();
    gtk_check_menu_item_get_type();
    gtk_clist_get_type();
    gtk_color_selection_get_type();
    gtk_color_selection_dialog_get_type();
    gtk_combo_get_type();
    gtk_container_get_type();
    gtk_curve_get_type();
    gtk_data_get_type();
    gtk_dialog_get_type();
    gtk_drawing_area_get_type();
    gtk_editable_get_type();
    gtk_entry_get_type();
    gtk_event_box_get_type();
    gtk_file_selection_get_type();
    gtk_fixed_get_type();
    gtk_frame_get_type();
    gtk_gamma_curve_get_type();
    gtk_handle_box_get_type();
    gtk_hbox_get_type();
    gtk_hbutton_box_get_type();
    gtk_hpaned_get_type();
    gtk_hruler_get_type();
    gtk_hscale_get_type();
    gtk_hscrollbar_get_type();
    gtk_hseparator_get_type();
    gtk_image_get_type();
    gtk_input_dialog_get_type();
    gtk_item_get_type();
    gtk_label_get_type();
    gtk_list_get_type();
    gtk_list_item_get_type();
    gtk_menu_get_type();
    gtk_menu_bar_get_type();
    gtk_menu_item_get_type();
    gtk_menu_shell_get_type();
    gtk_misc_get_type();
    gtk_notebook_get_type();
    gtk_object_get_type();
    gtk_option_menu_get_type();
    gtk_paned_get_type();
    gtk_pixmap_get_type();
    gtk_preview_get_type();
    gtk_progress_bar_get_type();
    gtk_radio_button_get_type();
    gtk_radio_menu_item_get_type();
    gtk_range_get_type();
    gtk_ruler_get_type();
    gtk_scale_get_type();
    gtk_scrollbar_get_type();
    gtk_scrolled_window_get_type();
    gtk_separator_get_type();
    gtk_spin_button_get_type();
    gtk_statusbar_get_type();
    gtk_table_get_type();
    gtk_text_get_type();
    gtk_toggle_button_get_type();
    gtk_toolbar_get_type();
    gtk_tooltips_get_type();
    gtk_tree_get_type();
    gtk_tree_item_get_type();
    gtk_vbox_get_type();
    gtk_vbutton_box_get_type();
    gtk_vpaned_get_type();
    gtk_vruler_get_type();
    gtk_vscale_get_type();
    gtk_vscrollbar_get_type();
    gtk_vseparator_get_type();
    gtk_viewport_get_type();
    gtk_widget_get_type();
    gtk_window_get_type();
}

%}

%native(gtk_init) PyObject * gtk__init(PyObject *self, PyObject *args);
void gtk_exit(int err);
void gtk_main();
void gtk_main_quit();
%name(gtk_main_iteration) int gtk_main_iteration_do(int block=1);
void gtk_grab_add(GtkWidget *w);
void gtk_grab_remove(GtkWidget *w);

%{
static PyObject *
gtk__timeout_add(PyObject *self, PyObject *args) {
    guint32 interval;
    PyObject *callback;
    if (!PyArg_ParseTuple(args, "iO:gtk_timeout_add", &interval, &callback))
        return NULL;
    if (!PyCallable_Check(callback)) {
        PyErr_SetString(PyExc_TypeError, "second arg not callable");
        return NULL;
    }
    Py_INCREF(callback);
    return PyInt_FromLong(gtk_timeout_add_interp(interval,
        (GtkCallbackMarshal)PyGtk_HandlerMarshal, callback,
        (GtkDestroyNotify)PyGtk_DestroyNotify));
}
static PyObject *
gtk__idle_add(PyObject *self, PyObject *args) {
    PyObject *callback;
    if (!PyArg_ParseTuple(args, "O:gtk_idle_add", &callback))
        return NULL;
    if (!PyCallable_Check(callback)) {
        PyErr_SetString(PyExc_TypeError, "arg not callable");
        return NULL;
    }
    Py_INCREF(callback);
    return PyInt_FromLong(gtk_idle_add_interp(
        (GtkCallbackMarshal)PyGtk_HandlerMarshal, callback, 
        (GtkDestroyNotify)PyGtk_DestroyNotify));
}
static PyObject *
gtk__idle_add_priority(PyObject *self, PyObject *args) {
    int p;
    PyObject *callback;
    if (!PyArg_ParseTuple(args, "iO:gtk_idle_add_priority", &p, &callback))
        return NULL;
    if (!PyCallable_Check(callback)) {
        PyErr_SetString(PyExc_TypeError, "2nd arg not callable");
        return NULL;
    }
    Py_INCREF(callback);
    return PyInt_FromLong(gtk_idle_add_full(p, NULL,
        (GtkCallbackMarshal)PyGtk_HandlerMarshal, callback, 
        (GtkDestroyNotify)PyGtk_DestroyNotify));
}
static PyObject *
gtk__quit_add(PyObject *self, PyObject *args) {
    int main_level;
    PyObject *callback;
    if (!PyArg_ParseTuple(args, "iO:gtk_quit_add", &main_level, &callback))
        return NULL;
    if (!PyCallable_Check(callback)) {
        PyErr_SetString(PyExc_TypeError, "2nd arg not callable");
        return NULL;
    }
    Py_INCREF(callback);
    return PyInt_FromLong(gtk_quit_add_full(main_level, NULL,
        (GtkCallbackMarshal)PyGtk_HandlerMarshal, callback, 
        (GtkDestroyNotify)PyGtk_DestroyNotify));
}
%}
%native(gtk_timeout_add) PyObject *gtk__timeout_add(PyObject *s, PyObject *a);
void gtk_timeout_remove(int tag);
%native(gtk_idle_add) PyObject *gtk__idle_add(PyObject *s, PyObject *a);
%native(gtk_idle_add_priority) PyObject *gtk__idle_add_priority(PyObject *s,
								PyObject *a);
void gtk_idle_remove(int tag);
%name(gtk_idle_remove_function) void gtk_idle_remove_by_data(PyObject *func);
%native(gtk_quit_add) PyObject *gtk__quit_add(PyObject *s, PyObject *a);
void gtk_quit_remove(int tag);
%name(gtk_quit_remove_function) void gtk_quit_remove_by_data(PyObject *func);
void gtk_quit_add_destroy(int mainlevel, GtkObject *object);

%{
static PyObject *
gtk__input_add(PyObject *self, PyObject *args) {
    int source;
    GdkInputCondition condition;
    PyObject *callback;
    if (!PyArg_ParseTuple(args, "iiO:gtk_input_add", &source, &condition,
			  &callback))
        return NULL;
    if (!PyCallable_Check(callback)) {
        PyErr_SetString(PyExc_TypeError, "3rd arg not callable.");
	return NULL;
    }
    Py_INCREF(callback);
    return PyInt_FromLong(gtk_input_add_full(source, condition, NULL,
			(GtkCallbackMarshal)PyGtk_InputMarshal, callback,
			(GtkDestroyNotify)PyGtk_DestroyNotify));
}
%}
%native(gtk_input_add) PyObject *gtk__input_add(PyObject *s, PyObject *a);
void gtk_input_remove(int tag);

/* rc parsing functions */
void gtk_rc_init();
void gtk_rc_parse(char *fname);
void gtk_rc_parse_string(char *rc_string);
GtkStyle *gtk_rc_get_style(GtkWidget *);
void gtk_rc_add_widget_name_style(GtkStyle *s, char *pattern);
void gtk_rc_add_widget_class_style(GtkStyle *s, char *pattern);

/* this function makes accessing the types easier, since SWIG makes it
   hard to do plain old constants */
%{
static PyObject *PyGtk_get_types(PyObject *self, PyObject *args) {
  PyObject *d;

  d = PyDict_New();
  PyDict_SetItemString(d, "GtkObject", (PyObject *)&PyGtk_Type);
  PyDict_SetItemString(d, "GtkAcceleratorTable",
		       (PyObject *)&PyGtkAccelerator_Type);
  PyDict_SetItemString(d, "GtkStyle", (PyObject *)&PyGtkStyle_Type);
  PyDict_SetItemString(d, "GdkFont", (PyObject *)&PyGdkFont_Type);
  PyDict_SetItemString(d, "GdkColor", (PyObject *)&PyGdkColor_Type);
  PyDict_SetItemString(d, "GdkEvent", (PyObject *)&PyGdkEvent_Type);
  PyDict_SetItemString(d, "GdkWindow", (PyObject *)&PyGdkWindow_Type);
  PyDict_SetItemString(d, "GdkGC", (PyObject *)&PyGdkGC_Type);
  PyDict_SetItemString(d, "GdkColormap", (PyObject *)&PyGdkColormap_Type);

  return d;
}
%}
%native(_get_types) PyObject *PyGtk_get_types(PyObject *s, PyObject *a);
