%module _gtkbase

%{
#include <gtk/gtk.h>
%}

%include gtkobject.i
%include gtkenums.i
%include obj_tmpl.i
%include gdk_typemap.i
%include gtk_typemap.i
%include gtkarg.i
%include gtksignal.i
%include gtkmain.i
%include gtknewset.i

char *gtk_type_name(int tp);
int gtk_type_from_name(char *name);

int GTK_IS_OBJECT(GtkObject *o);
int GTK_OBJECT_FLAGS(GtkObject *o);
int GTK_OBJECT_TYPE(GtkObject *o);
void GTK_OBJECT_SET_FLAGS(GtkObject *o, int flags);
void GTK_OBJECT_UNSET_FLAGS(GtkObject *o, int flags);
%{
static PyObject *gtk__object_set_data(PyObject *self, PyObject *args) {
	PyGtk_Object *obj;
	char *key;
	PyObject *data;
	if (!PyArg_ParseTuple(args, "O!sO:gtk_object_set_data", &PyGtk_Type,
			&obj, &key, &data))
		return NULL;
	Py_INCREF(data);
	gtk_object_set_data_full(PyGtk_Get(obj), key, data,
		(GtkDestroyNotify)PyGtk_DestroyNotify);
	Py_INCREF(Py_None);
	return Py_None;
}
static PyObject *gtk__object_get_data(PyObject *self, PyObject *args) {
	PyGtk_Object *obj;
	char *key;
	PyObject *data;
	if (!PyArg_ParseTuple(args, "O!s:gtk_object_get_data", &PyGtk_Type,
			&obj, &key))
		return NULL;
	data = gtk_object_get_data(PyGtk_Get(obj), key);
	if (data != NULL) {
		Py_INCREF(data);
		return data;
	} else {
		Py_INCREF(Py_None);
		return Py_None;
	}
}
%}
%native(gtk_object_set_data) PyObject *gtk__object_set_data(PyObject *self,
	PyObject *args);
%native(gtk_object_get_data) PyObject *gtk__object_get_data(PyObject *self,
	PyObject *args);
void gtk_object_remove_data(GtkObject *o, char *key);

%{
#define gtk_widget_get_window(o) ((o)->window)
%}
int GTK_IS_WIDGET(GtkObject *o);
GdkWindow *gtk_widget_get_window(GtkWidget *w);
void gtk_widget_destroy(GtkWidget *w);
void gtk_widget_unparent(GtkWidget *w);
void gtk_widget_show(GtkWidget *w);
void gtk_widget_hide(GtkWidget *w);
void gtk_widget_show_all(GtkWidget *w);
void gtk_widget_show_now(GtkWidget *w);
void gtk_widget_hide_all(GtkWidget *w);
void gtk_widget_map(GtkWidget *w);
void gtk_widget_unmap(GtkWidget *w);
void gtk_widget_realize(GtkWidget *w);
void gtk_widget_unrealize(GtkWidget *w);
void gtk_widget_queue_draw(GtkWidget *w);
void gtk_widget_queue_resize(GtkWidget *w);
void gtk_widget_draw(GtkWidget *w, GdkRectangle *a);
void gtk_widget_draw_focus(GtkWidget *w);
void gtk_widget_draw_default(GtkWidget *w);
void gtk_widget_draw_children(GtkWidget *w);
void gtk_widget_size_request(GtkWidget *w, GtkRequisition *r);
void gtk_widget_size_allocate(GtkWidget *w, GtkAllocation *a);
void gtk_widget_add_accelerator(GtkWidget *w, char *signal, GtkAccelGroup *g,
	int key, GdkModifierType modifiers, GtkAccelFlags flags);
void gtk_widget_remove_accelerator(GtkWidget *w, GtkAccelGroup *g,
	int accel_key, GdkModifierType accel_mods);
void gtk_widget_remove_accelerators(GtkWidget *w, char *signal, int visible);
void gtk_widget_freeze_accelerators(GtkWidget *w);
void gtk_widget_thaw_accelerators(GtkWidget *w);
int gtk_widget_event(GtkWidget *w, GdkEvent *event);
void gtk_widget_activate(GtkWidget *w);
void gtk_widget_reparent(GtkWidget *w, GtkWidget *p);
void gtk_widget_popup(GtkWidget *w, int x, int y);
void gtk_widget_intersect(GtkWidget *w, GdkRectangle *a, GdkRectangle *out);
void gtk_widget_basic(GtkWidget *w);
void gtk_widget_grab_focus(GtkWidget *w);
void gtk_widget_grab_default(GtkWidget *w);
void gtk_widget_set_name(GtkWidget *w, char *name);
char *gtk_widget_get_name(GtkWidget *w);
void gtk_widget_set_state(GtkWidget *w, GtkStateType state);
void gtk_widget_set_sensitive(GtkWidget *w, int s);
void gtk_widget_set_parent(GtkWidget *w, GtkWidget *p);
void gtk_widget_set_parent_window(GtkWidget *widget, GdkWindow *parent);
GdkWindow *gtk_widget_get_parent_window(GtkWidget *w);
void gtk_widget_set_style(GtkWidget *w, GtkStyle *s);
void gtk_widget_set_rc_style(GtkWidget *w);
void gtk_widget_ensure_style(GtkWidget *w);
void gtk_widget_restore_default_style(GtkWidget *w);
void gtk_widget_reset_rc_styles(GtkWidget *w);
void gtk_widget_set_uposition(GtkWidget *w, int x, int y);
void gtk_widget_set_usize(GtkWidget *w, int w, int h);
void gtk_widget_set_events(GtkWidget *w, int e);
void gtk_widget_set_extension_events(GtkWidget *w, GdkExtensionMode mode);
GtkWidget *gtk_widget_get_toplevel(GtkWidget *w);
GtkWidget *gtk_widget_get_ancestor(GtkWidget *w, int t);
// gtk_widget_get_colormap
// gtk_widget_get_visual
GtkStyle *gtk_widget_get_style(GtkWidget *w);
int gtk_widget_get_events(GtkWidget *w);
GdkExtensionMode gtk_widget_get_extension_events(GtkWidget *w);
%{
static PyObject *gtk_widget__get_pointer(PyObject *self, PyObject *args) {
  int x, y;
  PyGtk_Object *w;
  if (!PyArg_ParseTuple(args, "O!:gtk_widget_get_pointer", &PyGtk_Type, &w))
    return NULL;
  gtk_widget_get_pointer(GTK_WIDGET(w->go), &x, &y);
  return Py_BuildValue("(ii)", x, y);
}
%}
%native(gtk_widget_get_pointer) PyObject *gtk_widget__get_pointer(PyObject
                                                    *self, PyObject *args);
int gtk_widget_is_ancestor(GtkWidget *w, GtkWidget *a);
int gtk_widget_is_child(GtkWidget *w, GtkWidget *c);
int gtk_widget_hide_on_delete(GtkWidget *w);

// gtk_widget_push_colormap
// gtk_widget_push_visual
void gtk_widget_push_style(GtkStyle *style);
// gtk_widget_pop_colormap
// gtk_widget_pop_visual
void gtk_widget_pop_style();
// gtk_widget_set_default_colormap
// gtk_widget_set_default_visual
void gtk_widget_set_default_style(GtkStyle *style);
// gtk_widget_get_default_colormap
// gtk_widget_get_default_visual
// gtk_widget_get_default_style
%{
static PyObject *
gtk__widget_dnd_drag_set(PyObject *self, PyObject *args) {
    PyGtk_Object *obj;
    PyObject *pylist, *item;
    char **list;
    int enable, numtypes, i;
    if (!PyArg_ParseTuple(args, "O!iO:gtk_widget_dnd_drag_set", &PyGtk_Type,
			  &obj, &enable, &pylist))
        return NULL;
    if (!PySequence_Check(pylist)) {
        PyErr_SetString(PyExc_TypeError, "3rd argument not a sequence");
	return NULL;
    }
    numtypes = PySequence_Length(pylist);
    list = malloc(numtypes * sizeof(char *));
    for (i = 0; i < numtypes; i++) {
        item = PySequence_GetItem(pylist, i);
        if (!PyString_Check(item)) {
	    PyErr_SetString(PyExc_TypeError, "sequence item not a string");
	    free(list);
	    return NULL;
	}
	list[i] = PyString_AsString(item);
    }
    gtk_widget_dnd_drag_set(GTK_WIDGET(PyGtk_Get(obj)), enable, list,numtypes);
    free(list);
    Py_INCREF(Py_None);
    return Py_None;
}
static PyObject *
gtk__widget_dnd_drop_set(PyObject *self, PyObject *args) {
    PyGtk_Object *obj;
    PyObject *pylist, *item;
    char **list;
    int enable, is_destructive, numtypes, i;
    if (!PyArg_ParseTuple(args, "O!iOi:gtk_widget_dnd_drop_set", &PyGtk_Type,
			  &obj, &enable, &pylist, &is_destructive))
        return NULL;
    if (!PySequence_Check(pylist)) {
        PyErr_SetString(PyExc_TypeError, "3rd argument not a sequence");
	return NULL;
    }
    numtypes = PySequence_Length(pylist);
    list = malloc(numtypes * sizeof(char *));
    for (i = 0; i < numtypes; i++) {
        item = PySequence_GetItem(pylist, i);
        if (!PyString_Check(item)) {
	    PyErr_SetString(PyExc_TypeError, "sequence item not a string");
	    free(list);
	    return NULL;
	}
	list[i] = PyString_AsString(item);
    }
    gtk_widget_dnd_drop_set(GTK_WIDGET(PyGtk_Get(obj)), enable, list,
			    numtypes, is_destructive);
    free(list);
    Py_INCREF(Py_None);
    return Py_None;
}
static PyObject *
gtk__widget_dnd_data_set(PyObject *self, PyObject *args) {
    PyGtk_Object *wid;
    PyGdkEvent_Object *event;
    char *string;
    int len;
    if (!PyArg_ParseTuple(args, "O!O!z#:gtk_widget_dnd_data_set", &PyGtk_Type,
			  &wid, &PyGdkEvent_Type, &event, &string, &len))
        return NULL;
    gtk_widget_dnd_data_set(GTK_WIDGET(PyGtk_Get(wid)), PyGdkEvent_Get(event),
			    (gpointer) string, len);
    Py_INCREF(Py_None);
    return Py_None;
}
%}
void gtk_widget_shape_combine_mask(GtkWidget *w, GdkBitmap *mask, int x,int y);
void gtk_widget_dnd_drag_add(GtkWidget *widget);
%native(gtk_widget_dnd_drag_set) PyObject *gtk__widget_dnd_drag_set(
						    PyObject *s, PyObject *a);
%native(gtk_widget_dnd_drop_set) PyObject *gtk__widget_dnd_drop_set(
						    PyObject *s, PyObject *a);
%native(gtk_widget_dnd_data_set) PyObject *gtk__widget_dnd_data_set(
						    PyObject *s, PyObject *a);

int GTK_IS_CONTAINER(GtkObject *o);
void gtk_container_border_width(GtkContainer *c, int bw);
void gtk_container_add(GtkContainer *c, GtkWidget *w);
void gtk_container_remove(GtkContainer *c, GtkWidget *w);
void gtk_container_set_resize_mode(GtkContainer *container, GtkResizeMode m);
void gtk_container_check_resize(GtkContainer *c);
// gtk_container_foreach
int gtk_container_focus(GtkContainer *c, GtkDirectionType d);
void gtk_container_set_focus_child(GtkContainer *c, GtkWidget *child);
void gtk_container_set_focus_vadjustment(GtkContainer *c, GtkAdjustment *adj);
void gtk_container_set_focus_hadjustment(GtkContainer *c, GtkAdjustment *adj);
GList *gtk_container_children(GtkContainer *c);
void gtk_container_register_toplevel(GtkContainer *container);
void gtk_container_unregister_toplevel(GtkContainer *container);
void gtk_container_resize_children(GtkContainer *container);
int gtk_container_child_type(GtkContainer *container);

int GTK_IS_WINDOW(GtkObject *o);
GtkWidget *gtk_window_new(GtkWindowType wt);
void gtk_window_set_title(GtkWindow *w, char *title);
void gtk_window_set_wmclass(GtkWindow *w, char *wmc_name, char *wmc_class);
void gtk_window_set_focus(GtkWindow *w, GtkWidget *focus);
void gtk_window_set_default(GtkWindow *w, GtkWidget *default);
void gtk_window_set_policy(GtkWindow *w, int ashrink, int agrow, int auto_s);
void gtk_window_add_accel_group(GtkWindow *w, GtkAccelGroup *group);
void gtk_window_remove_accel_group(GtkWindow *w, GtkAccelGroup *group);
void gtk_window_position(GtkWindow *w, GtkWindowPosition pos);
int gtk_window_activate_focus(GtkWindow *w);
int gtk_window_activate_default(GtkWindow *w);
%{
static PyObject *gtk__window_set_icon(PyObject *self, PyObject *args) {
	PyGtk_Object *o, *pix, *mask;
        GtkWidget *win;
	if (!PyArg_ParseTuple(args, "O!O!O!:gtk_window_set_icon", &PyGtk_Type,
			&o, &PyGdkWindow_Type, &pix, &PyGdkWindow_Type, &mask))
		return NULL;
	win = GTK_WIDGET(PyGtk_Get(o));
	gtk_widget_realize(win);
	gdk_window_set_icon(win->window, NULL, PyGdkWindow_Get(pix),
			    PyGdkWindow_Get(mask));
	Py_INCREF(Py_None);
	return Py_None;
}
static PyObject *gtk__window_set_icon_name(PyObject *self, PyObject *args) {
	PyGtk_Object *o;
	char *name;
	if (!PyArg_ParseTuple(args, "O!s:gtk_window_set_icon_name",
			&PyGtk_Type, &o, &name))
		return NULL;
	gdk_window_set_icon_name(GTK_WIDGET(PyGtk_Get(o))->window, name);
	Py_INCREF(Py_None);
	return Py_None;
}
%}
%native(gtk_window_set_icon) PyObject *gtk__window_set_icon(
	PyObject *self, PyObject *args);
%native(gtk_window_set_icon_name) PyObject *gtk__window_set_icon_name(
	PyObject *self, PyObject *args);

// GtkAccelGroup functions
GtkAccelGroup *gtk_accel_group_new();
GtkAccelGroup *gtk_accel_group_get_default();
int gtk_accel_group_activate(GtkAccelGroup *accel_group, int accel_key,
			     GdkModifierType accel_mods);
int gtk_accel_groups_activate(GtkObject *object, int accel_key,
			      GdkModifierType accel_mods);
void gtk_accel_group_attach(GtkAccelGroup *accel_group, GtkObject *object);
void gtk_accel_group_detach(GtkAccelGroup *accel_group, GtkObject *object);
void gtk_accel_group_lock(GtkAccelGroup *accel_group);
void gtk_accel_group_unlock(GtkAccelGroup *accel_group);
void gtk_accel_group_lock_entry(GtkAccelGroup *accel_group, int accel_key,
				GdkModifierType accel_mods);
void gtk_accel_group_unlock_entry(GtkAccelGroup *accel_group, int accel_key,
				  GdkModifierType accel_mods);
void gtk_accel_group_add(GtkAccelGroup *accel_group, int accel_key,
			 GdkModifierType accel_mods, GtkAccelFlags accel_flags,
			 GtkObject *object, char *accel_signal);
void gtk_accel_group_remove(GtkAccelGroup *accel_group, int accel_key,
			    GdkModifierType accel_mods, GtkObject *object);
