/* This module contains the gtk_page widget, which is the "back end" to
   Web text widgets including html. */

#ifndef __GTK_PAGE_H__
#define __GTK_PAGE_H__

#undef USE_TYPE1

#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GTK_PAGE(obj)           GTK_CHECK_CAST (obj, gtk_page_get_type (), GtkPage)
#define GTK_PAGE_CLASS(klass)   GTK_CHECK_CLASS_CAST (klass, gtk_page_get_type (), GtkPageClass)
#define GTK_IS_PAGE(obj)        GTK_CHECK_TYPE (obj, gtk_page_get_type ())

typedef struct _GtkPage        GtkPage;
typedef struct _GtkPageClass   GtkPageClass;

/* Internal data structures (maybe shouldn't be in public .h file? */
typedef struct _GtkPageFont    GtkPageFont;
typedef struct _GtkPageLink    GtkPageLink;
typedef struct _GtkPageAttr    GtkPageAttr;
typedef struct _GtkPageLine    GtkPageLine;
typedef struct _GtkPageWord    GtkPageWord;

struct _GtkPageFont {
  char *name;
  gint size;
  gboolean bold;
  gboolean italic;

#ifdef USE_TYPE1
  gint t1fontid;
#else
  GdkFont *font;
#endif
  gint space_width; /* only valid if font != NULL */
};

struct _GtkPageLink {
  char *url;
};

struct _GtkPageAttr {
  gint font;
  gint link;
  gint32 color;

  gint left_indent_first;
  gint left_indent_rest;
  gint right_indent;

  gint align;
};

#define GTK_PAGE_ALIGN_LEFT 0
#define GTK_PAGE_ALIGN_CENTER 1
#define GTK_PAGE_ALIGN_RIGHT 2

struct _GtkPageLine {
  gint num_words;
  gint num_words_max; /* number allocated */
  gint y_top;
  gint x_size, y_ascent, y_descent, y_space;
  gboolean hard;      /* false = soft break, true = hard break */
  gboolean first;     /* true = first line in paragraph */
  GtkPageWord *words;
};

struct _GtkPageWord {
  /* At some point, this is going to become a variant record (i.e. it
     could point to a widget instead of just being text). */

  gint x_size, y_ascent, y_descent;
  gint x_space; /* space after the word, only if it's not a break */
  gint content_type;
  union {
    char *text;
    GtkWidget *widget;
  } content;

  gint attr;
};

#define GTK_PAGE_CONTENT_TEXT 0
#define GTK_PAGE_CONTENT_WIDGET 1

struct _GtkPage {
  GtkContainer container;

  GdkGC *gc;

  GtkPageLine *lines;
  gint num_lines;
  gint num_lines_max; /* number allocated */

  gint width;         /* the width (not including pad) at which line wrap
			 was calculated. If this changes, then the whole
			 thing should get re-wrapped. */

  GtkPageFont *fonts;
  gint num_fonts;
  gint num_fonts_max;

  GtkPageLink *links;
  gint num_links;
  gint num_links_max;

  GdkColor *colors;
  gint num_colors;
  gint num_colors_max;

  GtkPageAttr *attrs;
  gint num_attrs;
  gint num_attrs_max;

  /* Stuff for doing redraws */

  GdkRectangle clear;  /* Rectangle that must be cleared. */
  GdkRectangle redraw; /* Rectangle that must be redrawn. */

  gint redraw_start_line;

  /* The link under a button press */
  gint link_pressed;

  /* The link under the button */
  gint hover_link;
};

struct _GtkPageClass
{
  GtkContainerClass parent_class;

  void (* link) (GtkPage *page,
		 char *url);
  void (* status) (GtkPage *page,
		   char *string);
};


guint      gtk_page_get_type  (void);
GtkWidget* gtk_page_new       (void);

void gtk_page_set_width (GtkPage *page, gint width);

void gtk_page_update_begin (GtkPage *page);
void gtk_page_update_end (GtkPage *page);

void gtk_page_init_attr (GtkPage *page, GtkPageAttr *attr);
gint gtk_page_find_font (GtkPage *page, const GtkPageFont *font);
gint gtk_page_new_link (GtkPage *page, const char *url);
gint gtk_page_find_color (GtkPage *page, gint32 color);
gint gtk_page_find_attr (GtkPage *page, const GtkPageAttr *attr);
void gtk_page_add_text (GtkPage *page, char *text, gint attr);
void gtk_page_add_widget (GtkPage *page, GtkWidget *widget, gint attr);
void gtk_page_add_space (GtkPage *page, gint attr);
void gtk_page_linebreak (GtkPage *page);
void gtk_page_parbreak (GtkPage *page, gint space);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_PAGE_H__ */
