'\"et
.if t .TH IMXBM 3IM "September 24, 1991" "San Diego Supercomputer Center" "SDSC IMAGE LIBRARY"
.if n .TH IMXBM 3IM "September 24, 1991" "SDSC" "SDSC IMAGE LIBRARY"
.SH NAME
imxbm \- SDSC X11 XBM file translation
.SH SYNOPSIS
.nf
\fB
#include <stdio.h>
#include "sdsc.h"
#include "im.h"
.sp 1
int ImFileRead( fd, "xbm", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFRead( fp, "xbm", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileWrite( fd, "xbm", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFWrite( fp, "xbm", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
\fR
.fi
.SH DESCRIPTION
\fBxbm\fR bitmap image files are generated by MIT's X Window System,
version 11 (hereafter referred to as X11).
\fBxbm\fR files are generated by the X11 \fBbitmap\fR(1) bitmap editor and
used by most X11 tools to define cursors, icons, and other monochrome
glyphs.
See the X11 documentation set for details on how to use tools and subroutines
dealing with X11 bitmaps.
.SH "FILE RECOGNITION"
X11 \fBxbm\fR files are recognized by the following filename
suffixes:  .xbm and .bm.
.SH NOTES
SDSC image library support of the X11 \fBxbm\fR format does not require
use of any X11 libraries and contains no proprietary code.  X11 \fBxbm\fR
format handling
is available on any machine for which the SDSC image library is available.
.LP
\fBxbm\fR files contain simple C code with two \fB#define\fR's
for the width and height of the image, two optional \fB#define\fR's
for the X and Y location of the cursor hot spot, and one static character
array declaration and initialization for the image bits as follows:
.RS 0.5i
.LP
.nf
\fB#define \fIname\fB_width  \fIxxx\fR
\fB#define \fIname\fB_height \fIyyy\fR
\fB#define \fIname\fB_x_hot  \fIxhot\fR
\fB#define \fIname\fB_y_hot  \fIyhot\fR
\fBstatic char \fIname_bits\fB[ ] = {\fR
	\fI... ASCII hex data ...\fR
\fB};\fR
.fi
.RE
.LP
\fIxxx\fR and \fIyyy\fR define the width and height of the image stored in
the static character array.
.LP
\fIxhot\fR and \fIyhot\fR define the hot spot location
if the image is to be used as a cursor.
.LP
The array is initialized with hex byte values, with each byte holding 8
1-bit pixel values.
.SS "Reading X11 XBM files"
The SDSC image library reads X11 \fBxbm\fR bitmap glyphs
and maps them to \fBIMVFBMONO\fR VFBs without color lookup tables (CLTs).
.LP
\fBxbm\fR hot spot locations, if present, are ignored.
.SS "Writing X11 XBM files"
The SDSC image library writes \fBIMVFBMONO\fR VFBs as X11
\fBxbm\fR bitmap glyphs.
.LP
Other image library VFB types are converted to \fBIMVFBMONO\fR VFBs prior
to being written out.  See the \fBImFileWrite\fR(3IM) \fBman\fP page for
details.
.LP
Image width and height \fB#define\fR's are based on the VFB's width and
height.
.LP
\fIWarning:\fR  The X11 bitmap editor \fBbitmap\fR(1) was designed to
edit small glyphs, like icons and cursors.  It tends to be have severe
difficulty with large bitmaps, such as those that can be generated
using the SDSC image library. 
.LP
Hot spot \fB#define\fR's are not output.
.LP
The \fIname\fR portion of the \fB#define\fR and static array names are determined
as follows:
.RS 0.5i
.LP
If the filename tag is not present in the \fBflagsTable\fR argument to
\fBImFileWrite\fR(3IM), \fIname\fR defaults to \fBstream\fR.
.LP
If the filename tag is present, the name is stripped of any leading
path (up to the last /).  Characters up to the first character not
in the set 0-9a-zA-Z_ are used to construct the name.  If the first character
is numeric, a leading x is prepended.  For example,
.RS 0.5i
.LP
.TS
l l.
\fBflagsTable filename	Name replacement\fP
myfile.xbm	myfile
/this/that/the_other.xbm	the_other
42.xbm	x42
blurt^&#$$.xbm	blurt
.TE
.RE
.RE
.SH ERRORS
In addition to those listed for \fBImFileRead\fR(3IM),
X11 \fBxbm\fR file reading returns the following error codes: 
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC	Cannot allocate enough memory
IMESYNTAX	Syntax error in parsing \fBxbm\fR file
IMESYS	System call error in read operation
.TE
.if t .in -0.5i
.if n .in -5
.LP
In addition to those listed for \fBImFileWrite\fR(3IM),
X11 \fBxbm\fR file writing returns the following error codes: 
.ne 2
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC	Cannot allocate enough memory
IMESYS	System call error in write operation
.TE
.if t .in -0.5i
.if n .in -5
.SH DOCUMENTATION
\fBbitmap\fP(1) from the X11 \fBman\fP page set.
.sp
\fIXlib - C Language X Interface\fR, MIT X Window System, Version 11.
.SH SEE ALSO
\fBimconv\fR(1IM),
\fBimfile\fR(1IM),
\fBimformats\fR(1IM)
.SH AUTHOR
Dave Nadeau
.br
San Diego Supercomputer Center
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
