'\"et
.if t .TH IMCLTROLL 1IM "October 13, 1992" "San Diego Supercomputer Center" "IMAGE TOOLS" 
.if n .TH IMCLTROLL 1IM "October 13, 1992" "SDSC" "IMAGE TOOLS"
.SH NAME
imcltroll  -  Roll color lookup table by a number of entries
.SH SYNOPSIS
\fBimcltroll\fR [\fIoptions\fR] \fIinfilename\fR \fIoutfilename\fR
.SH DESCRIPTION
\fBimcltroll\fR reads each image in the input file, extracts the color lookup
table, rolls it, then writes it and its image to
the output file.  The input and output image file formats may be different.
.SH OPTIONS
\fBimcltroll\fR has a variety of options in the following five categories:
.LP
.RS +0.5i
.TS
l l.
File Selection	What input and output files to use
Format Selection	What image file format to use
Format Control	What variant of a file format to generate
Standard	Standard generic options on all SDSC tools
Rolling	How the image's CLT is rolled
.TE
.RE
.LP
\fIFile Selection\fR, \fIFormat Selection\fR, \fIFormat Control\fR, and
\fIStandard\fR options are common to all SDSC image tools and are
discussed in depth in the \fBman\fP page for \fBimconv\fR(1IM).
.LP
All options can be abbreviated to the first few unique characters.
.LP
.SS "Rolling Options"
Rolling a color lookup table, or CLT, copies entry 0 to entry \fIn\fR,
entry 1 to entry \fIn\fR+1, entry 2 to entry \fIn\fR+2, and so on.
Entries that roll off the bottom of the CLT wrap around back to the top of
the CLT, creating a rolling, or cycling, effect in the copy.
.LP
The \fB-roll \fIn\fR option selects rolling of the CLT by \fIn\fR entries.
Positive values for \fIn\fR roll entries downwards towards the bottom of the
CLT, while negative values roll entries upwards towards the top.
.LP
The input file must contain images that use CLTs, such as color-indexed images.
RGB images, for instance, typically do not have CLTs and are inappropriate
for use by \fBimcltroll\fR.
.SH NOTES
CLT rolling is a technique used to find and highlight 
aspects of an image generated, for example, by a CAT-scan.  
Different color indexes in a CAT-scan correspond to 
different types of matter, such as bone, muscle,
and air.  To highlight just the bone, a CLT may be constructed that sets
a range of color indexes to, say, bright red, and sets the rest to black.
.LP
When the red range of the CLT corresponds to the CAT-scan's bone
indexes, then all boney matter in the image is highlighted in red.
To highlight a different set of image color indexes, roll the CLT far
enough to bring the reds into the right index range, such as those for muscle.
By sweeping the red values back and forth through the CLT, one can zero in
on color indexes of interest.
.LP
In rare, specialized applications, RGB images may have color lookup tables.
In these cases, \fBimcltroll\fR will correctly roll the RGB image's
color lookup table, store it, and place the RGB image back into the output
file.  However, many RGB image display tools choose to ignore CLTs
associated with RGB images.  These tools will fail to show the effects
of rolling the color lookup table.  This is the fault of the RGB image
display tool, and not \fBimcltroll\fR.
.LP
Sometimes RGB images have color lookup tables.  When you rotate the 
color lookup table, you may not perceive any changes in the image 
since some display programs may throw this color lookup table out 
and use just the RGB information.
.LP
For notes regarding file format conversion and standard image tool 
options, see the \fBman\fP page on \fBimconv\fR(1IM).
.LP
With no roll arguments, the actions of \fBimcltroll\fR default to the
same as the SDSC image format conversion tool \fBimconv\fR(1IM), but
they take a little longer.
.LP
Error messages are reported to \fBstderr\fR.
.SH EXAMPLES
Roll an XWD image's color lookup table by 30 entries:
.RS 0.5i
.LP
\fBimcltroll in.xwd -roll 30 out.xwd\fR
.RE
.LP
Roll a color indexed Sun rasterfile backwards 5 entries and store the
result as a GIF file:
.RS 0.5i
.LP
\fBimcltroll in.ras -roll -5 out.gif\fR
.RE
.LP
.SH "SEE ALSO"
\fBimroll\fR (1IM),
\fBImCltRoll\fR (3IM)
.sp 1
For information on SDSC's image library, see \fBimintro\fR(3IM). 
.sp 1
For information on the individual image file formats, see
their respective \fBman\fR pages:
\fBimbmp\fR (3IM),
\fBimcur\fR (3IM),
\fBimeps\fR (3IM),
\fBimgif\fR (3IM),
\fBimhdf\fR (3IM),
\fBimico\fR (3IM),
\fBimicon\fR (3IM),
\fBimiff\fR (3IM),
\fBimmpnt\fR (3IM),
\fBimpbm\fR (3IM),
\fBimpcx\fR (3IM),
\fBimpgm\fR (3IM),
\fBimpic\fR (3IM),
\fBimpict\fR (3IM),
\fBimpix\fR (3IM),
\fBimpnm\fR (3IM),
\fBimppm\fR (3IM),
\fBimps\fR (3IM),
\fBimras\fR (3IM),
\fBimrgb\fR (3IM),
\fBimrla\fR (3IM),
\fBimrle\fR (3IM),
\fBimrpbm\fR (3IM),
\fBimrpgm\fR (3IM),
\fBimrpnm\fR (3IM),
\fBimrppm\fR (3IM),
\fBimsynu\fR (3IM),
\fBimtga\fR (3IM),
\fBimtiff\fR (3IM),
\fBimviff\fR (3IM),
\fBimx\fR (3IM),
\fBimxbm\fR (3IM),
\fBimxwd\fR (3IM)
.SH AUTHOR
Chris Groening
.br
San Diego Supercomputer Center
.LP
See the individual file format \fBman\fR pages for the authors of the underlying
format read and write code.  The names of these \fBman\fR pages begin
with the letters "im," followed by the format name.
For example, the name of the TIFF \fBman\fR page is \fBimtiff\fR.
To display it, enter \fBman imtiff\fR.
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
