'\"et
.if t .TH IMROLL 1IM "October 13, 1992" "San Diego Supercomputer Center" "IMAGE TOOLS" 
.if n .TH IMROLL 1IM "October 13, 1992" "SDSC" "IMAGE TOOLS"
.SH NAME
imroll  -  Rolls images vertically and/or horizontally
.SH SYNOPSIS
\fBimroll\fR [\fIoptions\fR] \fIinfilename\fR \fIoutfilename\fR
.SH DESCRIPTION
\fBimroll\fR reads each image in the input file, rolls it 
vertically, horizontally, or both, then writes it to the output file.
The input and output image file formats may be different.
.SH OPTIONS
\fBimroll\fR has a variety of options in the following five categories:
.LP
.RS +0.5i
.TS
l l.
File Selection	What input and output files to use
Format Selection	What image file format to use
Format Control	What variant of a file format to generate
Standard	Standard generic options on all SDSC tools
Rolling	How the image can be rolled
.TE
.RE
.LP
\fIFile Selection\fR, \fIFormat Selection\fR, \fIFormat Control\fR, and
\fIStandard\fR options are common to all SDSC image tools and are
discussed in depth in the \fBman\fP page for \fBimconv\fR(1IM).
.LP
All options can be abbreviated to the first few unique characters.
.LP
.SS "Rolling Options"
.LP
Rolling an image copies pixel (0,0) to pixel (x,y),
pixel (1,0) to (x+1,y), pixel (2,0) to
(x+2,y), and so on.  Pixels that fall off the image
edges wrap around to the opposite edge.  The effect is to slide an image
horizontally and/or vertically, wrapping around in a cyclical fashion.
.LP
\fB-xroll \fIvalue\fR 
.IP
Rolls the image horizontally by \fIvalue\fR pixels.
Positive values of \fIvalue\fR roll left-to-right, negative values
roll right-to-left.
.LP
\fB-yroll \fIvalue\fR 
.IP
Rolls the image vertically by \fIvalue\fR pixels.
Positive values of \fIvalue\fR roll top-to-bottom, negative values
roll bottom-to-top.
.LP
\fB-xroll\fR and \fB-yroll\fR may be given in combination in order to
roll in both the X and Y directions simultaneously.
.SH NOTES
.LP
Image rolling may be used for a variety of simple pan effects, such as
cyclical backgrounds for cartoon chase-sequence animations.
.LP
Image rolling may also be used in the processing of scanned or generated
texture images prior to repeated side-by-side texture mapping, such as
for grassy planes, carpeted areas, or brick or stone walls.  In each of these
cases, the original texture image will be repeated over a large area
with the left edge of one copy butting up against the right edge of the
next copy, and the top edge of one copy butting up against
the bottom edge of the next.
To avoid obvious grid lines in texturing, it is
important that the left and right edges, and top and bottom edges, of the
texture match each other.  This may be done by bringing the image into a
paint system and adjusting the pixels to make them match.
.LP
However, it is hard to visually match the left edge of an image with its
right edge when those edges aren't next to each other.  \fBimroll\fR
may be used to bring them next to each other.  Roll the image half the
image's width and height.  This places the left-right and top-bottom edges
next to each other in the middle of the image.  Now, bring the image into a
paint system and smear the joining line.  The image will then be ready for
seamless, side-by-side texture mapping.
.LP
For notes regarding file format conversion and standard image tool
options, see the \fBman\fP page on \fBimconv\fR(1IM).
.LP
Error messages are reported to \fBstderr\fR.
.LP
With no roll arguments, the actions of \fBimroll\fR default to the
same as the SDSC image format conversion tool \fBimconv\fR(1IM), but
they take a little longer.
.SH EXAMPLES
Roll a Wavefront RLB file 30 pixels to the right and store the result into
an SGI RGB file:
.RS 0.5i
.LP
\fBimroll original.rlb -xroll 30 rolled.rgb\fR
.RE
.LP
Roll a Sun raster file 100 pixels to the left and 50 pixels down:
.RS 0.5i
.LP
\fBimroll incoming.ras -xroll -100 -yroll 50 outgoing.ras\fR
.RE
.SH "SEE ALSO"
\fBimcltroll\fR (1IM),
\fBimcopy\fR (1IM),
\fBimrotate\fR (1IM),
\fBimshear\fR (1IM),
\fBimscale\fR (1IM),
\fBImVfbRoll\fR (3IM)
.sp 1
For information on SDSC's image library, see \fBimintro\fR(3IM). 
.sp 1
For information on the individual image file formats, see
their respective \fBman\fR pages:
\fBimbmp\fR (3IM),
\fBimcur\fR (3IM),
\fBimeps\fR (3IM),
\fBimgif\fR (3IM),
\fBimhdf\fR (3IM),
\fBimico\fR (3IM),
\fBimicon\fR (3IM),
\fBimiff\fR (3IM),
\fBimmpnt\fR (3IM),
\fBimpbm\fR (3IM),
\fBimpcx\fR (3IM),
\fBimpgm\fR (3IM),
\fBimpic\fR (3IM),
\fBimpict\fR (3IM),
\fBimpix\fR (3IM),
\fBimpnm\fR (3IM),
\fBimppm\fR (3IM),
\fBimps\fR (3IM),
\fBimras\fR (3IM),
\fBimrgb\fR (3IM),
\fBimrla\fR (3IM),
\fBimrle\fR (3IM),
\fBimrpbm\fR (3IM),
\fBimrpgm\fR (3IM),
\fBimrpnm\fR (3IM),
\fBimrppm\fR (3IM),
\fBimsynu\fR (3IM),
\fBimtga\fR (3IM),
\fBimtiff\fR (3IM),
\fBimviff\fR (3IM),
\fBimx\fR (3IM),
\fBimxbm\fR (3IM),
\fBimxwd\fR (3IM)
.SH AUTHOR
Chris Groening
.br
San Diego Supercomputer Center
.LP
See the individual file format \fBman\fR pages for the authors of the underlying
format read and write code.  The names of these \fBman\fR pages begin
with the letters "im," followed by the format name.
For example, the name of the TIFF \fBman\fR page is \fBimtiff\fR.
To display it, enter \fBman imtiff\fR.
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
