'\"t
.if t .TH IMIFF 3IM "August 19, 1992" "San Diego Supercomputer Center" "SDSC IMAGE LIBRARY"
.if n .TH IMIFF 3IM "August 19, 1992" "SDSC" "SDSC IMAGE LIBRARY"
.SH NAME
imiff \- Sun-TAAC file translation
.SH SYNOPSIS
.nf
\fB
#include <stdio.h>
#include "sdsc.h"
#include "im.h"
.sp 1
int ImFileRead( fd, "iff", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFRead( fp, "iff", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileWrite( fd, "iff", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFWrite( fp, "iff", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
\fR
.fi
.SH DESCRIPTION
.LP
\fBiff\fR image files are generated by Sun Microsystems TAAC software
such as \fBvoxvu\fR(1) and \fBcloudvu\fR(1).
See the \fITAAC-1 Application Accelerator: Software Reference 
Manual\fR for information on how to use 
these programs.
.LP
Note that image files compressed with the Sun-TAAC utility \fBmake_movie\fR(1)
cannot be read by the SDSC image library.
.SH "FILE RECOGNITION"
\fBiff\fP files are recognized by the following filename suffix: .iff.
.SH NOTES
SDSC image library support of the Sun-TAAC \fBiff\fR format does not
require use of Sun-TAAC tools or hardware and contains no proprietary
code.  Sun-TAAC \fBiff\fR format handling is available on any machine
for which the SDSC image library is available. 
.SS "Reading Sun-TAAC IFF files"
The SDSC image library reads unencoded, non-interlaced,
24-bit RGB and 32-bit RGB+Alpha Sun-TAAC \fBiff\fR file images
and maps them to \fBIMVFBRGB\fR or \fB(IMVFBRGB | IMVFBALPHA)\fR
VFBs without CLTs.
.LP
The library reads unencoded, 8-bit color index Sun-TAAC \fBiff\fR images
with CLTs and maps them to \fBIMVFBINDEX8\fR VFBs with CLTs.
Note that color index images never have an alpha plane.
.SS "Writing Sun-TAAC IFF files"
The SDSC image library writes \fBIMVFBRGB\fR
and \fB(IMVFBRGB | IMVFBALPHA)\fR VFBs to  
unencoded, non-interlaced 24-bit RGB or 32-bit RGB+Alpha
Sun-TAAC \fBiff\fR files.
Scanline- and plane-interlaced modes are not available in \fBiff\fR files.
.LP
The image library writes \fBIMVFBINDEX8\fR VFBs with CLTs as
unencoded, 8-bit color index images with CLTs in Sun-TAAC \fBiff\fR files.
.LP
Other image library VFB types are converted to \fBIMVFBRGB\fR or
\fBIMVFBINDEX8\fR VFBs prior
to being written out.  See the \fBImFileWrite\fR(3IM) \fBman\fP page for
details.
.LP
\fBiff\fR does not support any form of image compression.
.SH ERRORS
In addition to those listed for \fBImFileRead\fR(3IM),
Sun-TAAC \fBiff\fR file reading returns the following error codes:
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEDEPTH	Unknown image depth
IMEFORMAT	Bad format
IMEMAGIC	Bad magic number
IMEMALLOC	Cannot allocate enough memory
IMESYS	System call error in read operation
IMESYNTAX	Syntax error
.TE
.if t .in -0.5i
.if n .in -5
.LP
In addition to those listed for \fBImFileWrite\fR(3IM),
Sun-TAAC \fBiff\fR file writing returns the following error codes:
.ne 2
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC	Cannot allocate enough memory
IMESYS	System call error in write operation
.TE
.if t .in -0.5i
.if n .in -5
.SH DOCUMENTATION
\fISun-TAAC User Manual, Volume Rendering Package\fR, Sun Microsystems.
.SH "SEE ALSO"
\fBImIntro\fR(3IM),
\fBImErrNo\fR(3IM),
\fBimconv\fR(1IM),
\fBimfile\fR(1IM),
\fBimformats\fR(1IM),
\fBimras\fR(3IM)
.SH AUTHOR
T. Todd Elvins
.br
San Diego Supercomputer Center
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
