'\"et
.if t .TH IMRLE 3IM "August 24, 1992" "San Diego Supercomputer Center" "SDSC IMAGE LIBRARY"
.if n .TH IMRLE 3IM "August 24, 1992" "SDSC" "SDSC IMAGE LIBRARY"
.SH NAME
imrle \- Utah RLE file translation
.SH SYNOPSIS
.nf
\fB
#include <stdio.h>
#include "sdsc.h"
#include "im.h"
.sp 1
int ImFileRead( fd, "rle", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFRead( fp, "rle", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileWrite( fd, "rle", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFWrite( fp, "rle", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
\fR
.fi
.SH DESCRIPTION
\fBrle\fR image files are generated by the tools of Utah's Raster Toolkit.
See the Utah documentation set for details on how to use these tools.
.SH "FILE RECOGNITION"
Utah \fBrle\fR files are only recognized by the following filename 
suffix: .rle
.SH NOTES
SDSC image library support of the Utah \fBrle\fR format does not require
use of any Utah tools and contains no proprietary code.  Utah \fBrle\fR
format handling 
is available on any machine for which the SDSC image library is available.
.LP
The Utah \fBrle\fR format is very flexible and allows the definition of a
wide range of image depths.
Depth parameters include two ways to define color channels:
.LP
1.  Each pixel has a number of "channels" of information, such as
one channel for color index images, and three channels for
red-green-blue (RGB) images.  The \fBrle\fR format puts no restriction
on the number of pixel "color channels" an image may have.
.LP
2.  If a color lookup table (CLT) is present, each entry has a number
of "channels" of information, such as three channels for a
red-green-blue (RGB) color table (the only well-defined case).  The
\fBrle\fR format puts no restrictions on the number of CLT "color map
channels" an image may have.
.Le
Such a flexible file format design allows for the standard image types:
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l l.
Color index	1 channel/pixel	Stores color index
	3 channels/map entry	Stores RGB value

RGB	3 channels/pixel	Stores RGB value
	no color map
.TE
.if t .in -0.5i
.if n .in -5
.LP
Unfortunately, such a flexible file format can also specify a very wide range
of implausible image types.  So, clearly, 
restrictions have to be made.
The image library's support of Utah \fBrle\fR image files restricts images
to either 8-bit color index images 
(1 color channel, 3 color map color channels)
or 24-bit RGB images (3 color channels, 0 or 3 color map color channels).
.SS "Reading Utah RLE files"
The SDSC image library can read Utah \fBrle\fR files
and map them to VFBs as follows:
.ne 4
.LP
.TS
l l.
\fBDepth/color	Mapped to VFB\fR
8-bit color index, with or without CLT	\fBIMVFBINDEX8\fR
8-bit color index + alpha, with or without CLT	\fB(IMVFBINDEX8 | IMVFBALPHA)\fR
24-bit RGB, with or without CLT	\fBIMVFBRGB\fR
24-bit RGB + alpha, with or without CLT	\fB(IMVFBRGB | IMVFBALPHA)\fR
.TE
.LP
If the image has a color map, the VFB includes a CLT.
.SS "Writing Utah RLE files"
Images to be written out are mapped from image library VFBs as follows:
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
\fBMapped from VFB 	Depth/color\fR  
IMVFBINDEX8	8-bit color index, with or without CLT
IMVFBRGB	24-bit RGB, with or without CLT
.TE
.if t .in -0.5i
.if n .in -5
.LP
If the incoming VFB has a CLT, the image written to the Utah
\fBrle\fR file contains a CLT.
.LP
Other image library VFB types are converted to one of the above types
prior to being written out.  See the \fBImFileWrite\fR(3IM) \fBman\fP
page for details.
.SH ERRORS
In addition to those listed for \fBImFileRead\fR(3IM),
Utah \fBrle\fR file reading returns the following error codes: 
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC	Cannot allocate enough memory
IMESYNTAX	Syntax error in incoming file
IMESYS	System call error in read operation
.TE
.if t .in -0.5i
.if n .in -5
.LP
In addition to those listed for \fBImFileWrite\fR(3IM),
Utah \fBrle\fR file writing returns the following error codes: 
.ne 2
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC	Cannot allocate enough memory
IMESYS	System call error in write operation
.TE
.if t .in -0.5i
.if n .in -5
.SH DOCUMENTATION
\fIDesign of the Utah RLE Format\fR, Spencer W. Thomas, University of
Utah, Department of Computer Science
.SH SEE ALSO
\fBImIntro\fR(3IM),
\fBImErrNo\fR(3IM),
\fBimconv\fR(1IM),
\fBimfile\fR(1IM),
\fBimformats\fR(1IM)
.SH AUTHOR
Dave Nadeau
.br
San Diego Supercomputer Center
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
