/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vringint.h
 >>>>            Author: Scott Wilson
 >>>> Date Last Updated: Mon Apr 15 22:17:04 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vringint_h_
#define _vringint_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vringint Argument Structure
*
****************************************************************/

typedef struct _vringint  {

/*
 *  input image (Required infile)
 */
char	*i_file;	/* input image FILENAME */
int	 i_flag;	/* input image FLAG */

/*
 *  resulting output image (Required outfile)
 */
char	*o_file;	/* resulting output image FILENAME */
int	 o_flag;	/* resulting output image FLAG */

/*
 *  X coordinate of ring center (Optional float)
 */
float	 x_float;	/* X coordinate of ring center FLOAT */
int	 x_flag;   	/* X coordinate of ring center FLAG */

/*
 *  Y coordinate of ring center (Optional float)
 */
float	 y_float;	/* Y coordinate of ring center FLOAT */
int	 y_flag;   	/* Y coordinate of ring center FLAG */

/*
 *  minimum ring radius (Optional float)
 */
float	 rmin_float;	/* minimum ring radius FLOAT */
int	 rmin_flag;   	/* minimum ring radius FLAG */

/*
 *  maximum ring radius (Optional float)
 */
float	 rmax_float;	/* maximum ring radius FLOAT */
int	 rmax_flag;   	/* maximum ring radius FLAG */

/*
 *  step interval between rings (Optional float)
 */
float	 step_float;	/* step interval between rings FLOAT */
int	 step_flag;   	/* step interval between rings FLAG */

/*
 *  angular step interval in degrees (Optional float)
 */
float	 ang_float;	/* angular step interval in degrees FLOAT */
int	 ang_flag;   	/* angular step interval in degrees FLAG */

/*
 *  line integral (0) or ring integral (1) (Optional logical)
 */
int	 t_logic;	/* line integral (0) or ring integral (1) LOGIC */
int	 t_flag;  	/* line integral (0) or ring integral (1) FLAG */

}  vringint_struct;

vringint_struct *vringint;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define CHECKINPUT(program, image) \
        proper_num_images(program,image,1,TRUE); \
        if (propertype(program,image,VFF_TYP_BIT,FALSE) || \
            propertype(program,image,VFF_TYP_2_BYTE,FALSE) || \
            propertype(program,image,VFF_TYP_4_BYTE,FALSE) || \
            propertype(program,image,VFF_TYP_DOUBLE,FALSE)) \
        { \
            (void) fprintf(stderr, "Image data type must be \
VFF_TYP_1_BYTE || VFF_TYP_FLOAT\n"); \
            exit(1); \
        } \
        proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE); \
        proper_map_scheme(program,image,VFF_MS_NONE,TRUE)
/* -include_macros_end */

#endif
