/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vibf.c
 >>>>
 >>>>      Program Name: vibf
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Compute Ion Beam Figuring Pointspread Function
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Mon Apr 15 22:19:51 1991
 >>>>
 >>>>          Routines: main- the main program for vibf
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vibf.h"


/****************************************************************
 *
 * Routine Name:  main program for vibf
 *
 *       Input:  
 *      -surface  surface image 
 *      -sputter  sputter yield image 
 *      -dist  ion source distance from reference plane (m)   (0.000 < value < 1.000)
 *      -w  width in meters of the beam patch   (0.000 < value < 1.000)
 *      -psf  Pointspread output image 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *surface, *sputter, *psf, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);

        surface = readimage(vibf->surface_file);
        if (surface == NULL) exit(1);                    

        sputter = readimage(vibf->sputter_file);
        if (sputter == NULL) exit(1);                    

        if (surface->data_storage_type != VFF_TYP_FLOAT)
          {
            fprintf(stderr,"vibf: Surface image must be a FLOAT image\n");
            exit(1);
          }
        if (sputter->data_storage_type != VFF_TYP_FLOAT)
          {
            fprintf(stderr,"vibf: Sputter yield image must be a FLOAT image\n");
            exit(1);
          }
/* -main_before_lib_call_end */

/* -main_library_call */
        if(! lvibf(surface, sputter,vibf->dist_float,vibf->w_float,&psf) )
        {
            (void) fprintf(stderr, "lvibf Failed\n");
            exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        (void) writeimage(vibf->psf_file, psf);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vibf 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vibf :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCompute Ion Beam Figuring Pointspread Function\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-surface  surface image  (infile)\n");
	fprintf(stderr,"\t-sputter  sputter yield image  (infile)\n");
	fprintf(stderr,"\t-dist  ion source distance from reference plane (m)  (float,  0.000 to 1.000)\n");
	fprintf(stderr,"\t-w  width in meters of the beam patch  (float,  0.000 to 1.000)\n");
	fprintf(stderr,"\t-psf  Pointspread output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vibf\n");
	fprintf(stderr, "\t[-U] Gives the usage for vibf\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vibf.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vibf.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vibf
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*surface_pstr = 
	"\nEnter: (surface) surface image \n        {infile}: "; 
char	*sputter_pstr = 
	"\nEnter: (sputter) sputter yield image \n        {infile}: "; 
char	*dist_pstr = 
	"\nEnter: (dist) ion source distance from reference plane (m) \n        {float,  0.000 to 1.000}: "; 
char	*w_pstr = 
	"\nEnter: (w) width in meters of the beam patch \n        {float,  0.000 to 1.000}: "; 
char	*psf_pstr = 
	"\nEnter: (psf) Pointspread output image \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vibf", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vibf.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vibf: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vibf.ans");
		}

	     }

	}

	/*
	 * allocate the vibf structure
	 */
	vibf = (vibf_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vibf_struct));

	/*
	 * get required arguments for vibf
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vibf->surface_flag = vget_infile(fid, prompt_flag,
			"-surface", surface_pstr, &(vibf->surface_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vibf->surface_flag))
		{
		    fprintf(stderr, "\t\tsurface is required, please re-enter: \n");
		    vibf->surface_flag = vget_infile(fid, prompt_flag,
		    "-surface", surface_pstr, &(vibf->surface_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-surface' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vibf->sputter_flag = vget_infile(fid, prompt_flag,
			"-sputter", sputter_pstr, &(vibf->sputter_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vibf->sputter_flag))
		{
		    fprintf(stderr, "\t\tsputter is required, please re-enter: \n");
		    vibf->sputter_flag = vget_infile(fid, prompt_flag,
		    "-sputter", sputter_pstr, &(vibf->sputter_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-sputter' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vibf->dist_flag = vget_float(fid, prompt_flag,
			"-dist", dist_pstr, &(vibf->dist_float),
			0.200000, 0.000000, 1.000000)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vibf->dist_flag))
		{
		    fprintf(stderr, "\t\tdist is required, please re-enter: \n");
		    vibf->dist_flag = vget_float(fid, prompt_flag,
		    "-dist", dist_pstr, &(vibf->dist_float),
		    0.200000, 0.000000, 1.000000);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-dist' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vibf->w_flag = vget_float(fid, prompt_flag,
			"-w", w_pstr, &(vibf->w_float),
			0.070000, 0.000000, 1.000000)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vibf->w_flag))
		{
		    fprintf(stderr, "\t\tw is required, please re-enter: \n");
		    vibf->w_flag = vget_float(fid, prompt_flag,
		    "-w", w_pstr, &(vibf->w_float),
		    0.070000, 0.000000, 1.000000);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-w' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vibf->psf_flag = vget_outfile(fid, prompt_flag,
			"-psf", psf_pstr, &(vibf->psf_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vibf->psf_flag))
		{
		    fprintf(stderr, "\t\tpsf is required, please re-enter: \n");
		    vibf->psf_flag = vget_outfile(fid, prompt_flag,
		    "-psf", psf_pstr, &(vibf->psf_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-psf' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



