/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: Fimg2viff.c
 >>>>
 >>>>      Program Name: Fimg2viff
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Conversion from Fremont (4.7 Tesla  Magnet)  Image  to  VIFF
 >>>>	Format
 >>>>	
 >>>>	
 >>>>            Author: Donna Koechner
 >>>>
 >>>> Date Last Updated: Sun Mar 10 11:30:01 1991
 >>>>
 >>>>          Routines: main- the main program for Fimg2viff
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "Fimg2viff.h"


/****************************************************************
 *
 * Routine Name:  main program for Fimg2viff
 *
 *       Input:  
 *           -i  input raw data file 
 *           -o  resulting output image (viff file) 
 *
 *
 *           [-r] number of rows  (value >= 0)
 *           [-c] number of columns  (value >= 0)
 *           [-h] number of bytes to offset from the start the input file  (value >= 0)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct  xvimage *image;
char    *malloc();
int     file;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args())
{
  fprintf(stderr, "%s: Illegal arguments on command line.\n", program);
  exit(1);
}
/* -main_before_lib_call_end */

/* -main_library_call */
if ( (file = open_input(Fimg2viff->i_file)) < 0)
  {
    fprintf(stderr,"lFimg2viff: Unable to access input file %s\n",
                   Fimg2viff->i_file);
    exit(1);
  }

if(! lFimg2viff(file, &image, Fimg2viff->r_int, 
                  Fimg2viff->c_int, Fimg2viff->h_int, VFF_TYP_1_BYTE))
{
    (void) fprintf(stderr, "lFimg2viff Failed\n");
    exit(1);
}
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(Fimg2viff->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for Fimg2viff 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "Fimg2viff :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tConversion from Fremont (4.7 Tesla  Magnet)  Image  to  VIFF\n");
	fprintf(stderr, "\tFormat\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input raw data file  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image (viff file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-r]  number of rows (integer, >= 0) [128]\n");
	fprintf(stderr,"\t[-c]  number of columns (integer, >= 0) [128]\n");
	fprintf(stderr,"\t[-h]  number of bytes to offset from the start the input file (integer, >= 0) [2048]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for Fimg2viff\n");
	fprintf(stderr, "\t[-U] Gives the usage for Fimg2viff\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called Fimg2viff.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses Fimg2viff.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for Fimg2viff
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input raw data file \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image (viff file) \n        {outfile}: "; 
char	*r_pstr = 
	"\nEnter: (r) number of rows \n        {integer, >= 0 [128] }: "; 
char	*c_pstr = 
	"\nEnter: (c) number of columns \n        {integer, >= 0 [128] }: "; 
char	*h_pstr = 
	"\nEnter: (h) number of bytes to offset from the start the input file \n        {integer, >= 0 [2048] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "Fimg2viff", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "Fimg2viff.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "Fimg2viff: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "Fimg2viff.ans");
		}

	     }

	}

	/*
	 * allocate the Fimg2viff structure
	 */
	Fimg2viff = (Fimg2viff_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (Fimg2viff_struct));

	/*
	 * get required arguments for Fimg2viff
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(Fimg2viff->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(Fimg2viff->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(Fimg2viff->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    Fimg2viff->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(Fimg2viff->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(Fimg2viff->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(Fimg2viff->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(Fimg2viff->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    Fimg2viff->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(Fimg2viff->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for Fimg2viff
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	Fimg2viff->r_flag = vget_int(fid, prompt_flag,
	"-r", r_pstr, &(Fimg2viff->r_int),
	128, 1, 1);

	Fimg2viff->c_flag = vget_int(fid, prompt_flag,
	"-c", c_pstr, &(Fimg2viff->c_int),
	128, 1, 1);

	Fimg2viff->h_flag = vget_int(fid, prompt_flag,
	"-h", h_pstr, &(Fimg2viff->h_int),
	2048, 1, 1);


}



