/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: idct2d.c
 >>>>
 >>>>      Program Name: idct2d
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Compute blockwise two-dimensional  INVERSE  Discrete  Cosine
 >>>>	Transform (IDCT) of an image
 >>>>	
 >>>>	
 >>>>            Author: Michael Gilge, gilge@icsi.berkeley.edu

        Copyright 1991, Michael Gilge. All rights reserved.
        Distribution and use permitted as provided in the 
        KHOROS copyright as long as this notice is attached
        to the code and its derivatives.
 >>>>
 >>>> Date Last Updated: Mon Apr 22 21:53:33 1991
 >>>>
 >>>>          Routines: main- the main program for idct2d
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "idct2d.h"


/****************************************************************
 *
 * Routine Name:  main program for idct2d
 *
 *       Input:  
 *        -i  input image 
 *        -o  resulting output image 
 *
 *
 *        [-bs] select blocksize 8x8 pixel (0) or 16x16 pixel (1)
 *        [-round] write output image in FLOAT (0 = no rounding, 1 = round to BYTE)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        struct xvimage *image,*readimage();
        int block_size;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);
        image = readimage(idct2d->i_file);
        if (image == NULL) exit(1);
        CHECKINPUT(program, image);
        block_size = (idct2d->bs_logic == 0) ? 8 : 16;
/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lidct2d(image, block_size, idct2d->round_logic) )
    {
        (void) fprintf(stderr, "lidct2d Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(idct2d->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for idct2d 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "idct2d :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCompute blockwise two-dimensional  INVERSE  Discrete  Cosine\n");
	fprintf(stderr, "\tTransform (IDCT) of an image\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-bs]  select blocksize 8x8 pixel (0) or 16x16 pixel (1) (boolean) [false]\n");
	fprintf(stderr,"\t[-round]  write output image in FLOAT (0 = no rounding, 1 = round to BYTE) (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for idct2d\n");
	fprintf(stderr, "\t[-U] Gives the usage for idct2d\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called idct2d.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses idct2d.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for idct2d
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*bs_pstr = 
	"\nEnter: (bs) select blocksize 8x8 pixel (0) or 16x16 pixel (1) \n        {boolean, (y/n)  [no] }: "; 
char	*round_pstr = 
	"\nEnter: (round) write output image in FLOAT (0 = no rounding, 1 = round to BYTE) \n        {boolean, (y/n)  [yes] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "idct2d", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "idct2d.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "idct2d: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "idct2d.ans");
		}

	     }

	}

	/*
	 * allocate the idct2d structure
	 */
	idct2d = (idct2d_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (idct2d_struct));

	/*
	 * get required arguments for idct2d
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(idct2d->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(idct2d->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(idct2d->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    idct2d->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(idct2d->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(idct2d->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(idct2d->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(idct2d->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    idct2d->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(idct2d->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for idct2d
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	idct2d->bs_flag = vget_logic(fid, prompt_flag,
	"-bs", bs_pstr, &(idct2d->bs_logic), 0);

	idct2d->round_flag = vget_logic(fid, prompt_flag,
	"-round", round_pstr, &(idct2d->round_logic), 1);


}



