/*
 *---------------------------------------------------------------------
 *            Copyright 1990 University of New Mexico
 * 
 * Permission to copy and modify this software and its documen- 
 * tation only for internal use in your organization is hereby 
 * granted, provided that this notice is retained thereon and 
 * on all copies.  UNM makes no representations as too the sui- 
 * tability and operability of this software for any purpose. 
 * It is provided 'as is' without express or implied warranty. 
 *  
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT- 
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT- 
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER- 
 * FORMANCE OF THIS SOFTWARE. 
 *  
 * No other rights, including for example, the right to redis- 
 * tribute this software and its documentation or the right to 
 * prepare derivative works, are granted unless specifically 
 * provided in a separate license agreement. 
 * 
 *---------------------------------------------------------------------
 */
#include "unmcopyright.h"
#include "xvforms.h"
#include "form_info.h"


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name:  form_info.c
 >>>>
 >>>>      Program Desc:  code to extract values
 >>>>                     from the graphical user interface 
 >>>>
 >>>>            Author:  automatically generated by conductor
 >>>>
 >>>> Date Last Updated:  Wed Apr 24 11:26:12 1991
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


/********************************************************
*
*  Routine Name: xvf_get_example1
*
*       Purpose: Fills in the user-specified
*                'example1'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                forminfo - pointer to the user-specified
*                'example1'
*
*       Output:  current values stored in  example1
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_example1(formptr, forminfo)

xvf_form *formptr;
example1 *forminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;

	/***** getting 'example1' Form Information structure *****/


	index = 1;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->sub_selected = line_info.selected;
	_xvf_get_sub(formptr, forminfo->sub);

}

/********************************************************
*
*  Routine Name: xvf_get_sub
*
*       Purpose: Fills in the user-specified
*                'example1_sub'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'example1_sub'
*
*       Output:  current values stored in  'example1_sub'
*
*    Called By:  xvf_get_*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_sub(formptr, subforminfo)

xvf_form *formptr;
example1_sub *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 2;


	/*** extracting 'example1->sub'
 	   Subform Information structure ***/


	index = 2;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->one_selected = line_info.selected;
	_xvf_get_one(formptr, subforminfo->one);

}



/********************************************************
*
*  Routine Name: xvf_get_one
*
*       Purpose: Fills in the user-specified
*                'sub_one'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'sub_one'
*
*       Output:  current values stored in  'sub_one'
*
*    Called By:  xvf_get_sub
*

*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_one(formptr, paneinfo)

xvf_form *formptr;
sub_one *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 3;


	/* extracting 'example1->sub->one'
 	   Pane Information structure */

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->add = line_info.selected;
	index++;

	xvf_parse_workspace_line(database[index], &line_info);
	paneinfo->workspace = line_info.workspace;
	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;

	index++;



}


