#!/bin/csh -f

#
# Khoros: $Id$
#
# $Log$
#

# Copyright (C) 1993, 1994, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.

#************************************************************
#
#  Routine Name: kedit - shell script named kedit
#
#       Purpose: ASCII editor (emacs, vi, or xedit (default) )
#
#         Input: argument1 - optional, file to be edited
#		 argument2 - optional, edited file
#
#    Written By: Renato Luppi
#          Date: 12 Nov 1994
#
#************************************************************/

set error_flag = 0

set i_flag = 0
set o_flag  = 0
set ed_flag = 0

set i_file_flag = 0
set o_file_flag = 0
set ed_str_flag = 0

set i_file =             #default = empty
set o_file =             #default = empty
set ed_str = xedit       # default=xedit (xedit emacs vi)


while ($#argv)
  switch($argv[1])
      case -i:
        set i_flag = 1
        breaksw
      case -o:
        set o_flag = 1
        breaksw
      case -ed:
        set ed_flag = 1
        breaksw
      case -U:
        goto usage
        breaksw
      case -[A-T]*:	# not valid switches
      case -[V-Z]*;
      case -[a-h]*:
      case -[j-n]*:
      case -[p-z]*:
        set error_flag = 1
        goto usage
        breaksw
      default:
        if ($i_flag) then
                set i_file = $argv[1]
                set i_file_flag = 1
                set i_flag = 0
        else if ($o_flag) then
                set o_file = $argv[1]
                set o_file_flag = 1
                set o_flag = 0
        else if ($ed_flag) then
                set ed_str = $argv[1]
                set ed_str_flag = 1
                set ed_flag = 0
        endif
        breaksw
  endsw
  shift
end

if (($ed_str != "xedit") && ($ed_str != "emacs") && ($ed_str != "vi")) then
        /bin/sh -c 'echo "Unknown -ed argument" |>&2'
	echo "Unknown -ed argument"
        set error_flag = 1
        goto usage
endif


set cp_flag = 0

if ($i_file_flag) then
	if (! (-e $i_file)) then
		/bin/sh -c 'echo "Unable to open file $i_file" |>&2'
      		echo "Unable to open file $i_file"
      		set error_flag = 1
      		goto usage
	endif
endif

# case both exists:
if ( $o_file_flag && $i_file_flag  && ($i_file != $o_file)) then
		cp $i_file $o_file
		set cp_info_before = `ls -alF $o_file`
		set cp_flag = 1
	endif
endif

# case only input exists
# copy input to temporary file, edit temporary file
# temporary file is deleted if not saved by the editor
if ( $i_file_flag && (! $o_file_flag) ) then
  set aux = `printenv |grep TMPDIR`
  if ( "x$aux" == "x" ) then
    setenv TMPDIR .
  endif
#  printenv TMPDIR
  set o_file = $TMPDIR/kedit$$
  cp $i_file $o_file
  set cp_info_before = `ls -alF $o_file`
  set cp_flag = 1
endif

if ("$ed_str" == "vi") then
  set ed_str = "xterm -e vi"
endif

$ed_str $o_file

set ed_status = $status

if ($cp_flag) then
	set cp_info_after = `ls -alF $o_file`
	if ("$cp_info_after" == "$cp_info_before") then
		\rm $o_file
	endif
endif

if ($ed_status) then
        /bin/sh -c 'echo "Error in $ed_str" |>&2'
	echo "Error in $ed_str"
	set error_flag = 1
   	goto cleanup
endif





cleanup:
    unset i_flag
    unset o_flag
    unset ed_flag

    unset i_file_flag
    unset o_file_flag
    unset ed_str_flag

    unset i_file
    unset o_file
    unset ed_str

    unset cp_info_before
    unset cp_info_after
    unset cp_flag
#    unset mv_flag

    unset ed_status

    if ($error_flag) then
        unset error_flag
        exit 1          # an error
    else
        unset error_flag
        exit 0
    endif

usage:
    echo ""
    echo "kedit: calls your editor"
    echo ""
    echo "Usage:"
    echo "  [-i]     input file"
    echo "  [-o]     output file"
    echo "  [-ed]    editor to be used (xedit emacs vi) [xedit]"
    echo ""
    echo "  [-U]     get this message"
    echo ""
    goto cleanup
