 /*
  * Khoros: $Id: vencode.h,v 1.1 1991/05/10 04:12:19 khoros Exp $
  */

 /*
  * $Log: vencode.h,v $
 * Revision 1.1  1991/05/10  04:12:19  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */

#ifndef	_vencode_h_
#define _vencode_h_

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                              <<<<
   >>>>      file: vencode.h					     <<<<
   >>>>                                                              <<<<
   >>>>      contains: 
   >>>>                This file contains the tables of commands     <<<<
   >>>>      used to implement the automatic encoding/decoding       <<<<
   >>>>      of viff images.					     <<<<
   >>>>                                                              <<<<
   >>>>      The table entitled "compr_cmd" associates the actual    <<<<
   >>>>      command required to encode the data with the encoding   <<<<
   >>>>      scheme declared in KHOROS_HOME/include/viff.h.          <<<<
   >>>>                                                              <<<<
   >>>>      The table entitled "uncompr_cmd" associates the actual  <<<<
   >>>>      command required to decode the data with the encoding   <<<<
   >>>>      scheme declared in  KHOROS_HOME/include/viff.h.         <<<<
   >>>>                                                              <<<<
   >>>>      In both cases, the actual command should be written to  <<<<
   >>>>      accept stdin for the input, and stdout for the output   <<<<
   >>>>      (this is the only requirement as far as viff support is <<<<
   >>>>      required)  For an example of this, see the UNIX         <<<<
   >>>>      compress(1) command.				     <<<<
   >>>>                                                              <<<<
   >>>>      NOTE: The command given will be implanted in a command  <<<<
   >>>>            command string similar to:			     <<<<
   >>>>            % cat input | your-command-here | > output        <<<<
   >>>>            so you can put whatever switches, etc, you want!  <<<<
   >>>>		   Just remember that >> sh <<, not >> csh << will   <<<<
   >>>>		   execute your command!  If the command does not    <<<<
   >>>>		   exist, the support routines will try to detect    <<<<
   >>>>		   this fact and exit cleanly.			     <<<<
   >>>>								     <<<<
   >>>>      date: 4/21/89                                           <<<<
   >>>>								     <<<<
   >>>>	     written by: Scott R. Wilson                             <<<<
   >>>>                                                              <<<<
   >>>>      modifications:					     <<<<
   >>>>                                                              <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */
  
#ifndef	_compr_cmd_
#define _compr_cmd_
static char *compr_cmd[] =
	{"This_should_never_happen",      /* DES-RAW */
         "compress",                      /* DES_COMPRESS */
         "rle",                           /* DES_RLE */
         "transform",                     /* DES_TRANSFORM */
         "ccitt",                         /* DES_CCITT */
         "adpcm",                         /* DES_ADPCM */
         "gencomp"};                      /* DES_GENERIC */
#endif

#ifndef	_uncompr_cmd_
#define _uncompr_cmd_
static char *uncompr_cmd[] =
	{"This_should_never_happen",      /* DES-RAW */
         "uncompress",                    /* DES_COMPRESS */
         "unrle",                         /* DES_RLE */
         "untransform",                   /* DES_TRANSFORM */
         "unccitt",                       /* DES_CCITT */
         "unadpcm",                       /* DES_ADPCM */
         "ungencomp"};                    /* DES_GENERIC */
#endif

/*
  In case you're wondering why This_should_never_happen, you'll
  find that readimage() and writeimage() will trap for VFF_DES_RAW
  and call write() or block_read() directly for efficiency!

*/
  
#endif /* _vencode_h_ */
/* Don't add after the endif */
