 /*
  * Khoros: $Id: getproginfo.c,v 1.1 1991/05/10 15:40:42 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: getproginfo.c,v 1.1 1991/05/10 15:40:42 khoros Exp $";
#endif

 /*
  * $Log: getproginfo.c,v $
 * Revision 1.1  1991/05/10  15:40:42  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "ghost.h"
#include "vinclude.h"

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>			file name: getproginfo.c 	      <<<<
   >>>>                                                       <<<<
   >>>>  Routines to extract info from source for .prog file  <<<<
   >>>>                                                       <<<<
   >>>>			gr_get_cfile_info()		      <<<<
   >>>>			gr_get_hfile_info()		      <<<<
   >>>>			gr_get_lfile_info()		      <<<<
   >>>>			gr_get_man1file_info()		      <<<<
   >>>>			gr_get_man3file_info()		      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */


/************************************************************
*
*  Routine Name: gr_get_cfile_info
*
*      Purpose: This routine gets .prog info from the .c file
*	 	Note that old text blocks will not be over-written
*		if the new text block comes back empty.
*
*        Input: cfilename -  full path to .c file 
*		prog_spec -  pointer to the internal program specification
*               name      -  name of the program being generated
*
*    Called by: ghostreader main
*
*   Written By: Danielle Argiro
*
*************************************************************/

int gr_get_cfile_info(cfilename, prog_spec)
char *cfilename;
char **prog_spec;
{
    int status = 0;
    char *fullpath;
    FILE *cfile;
    char *temp, *dummy;
    char *begin_key, *end_key;

    fullpath = vfullpath(cfilename, NULL, NULL);
    if (!(cfile = fopen(fullpath, "r")))
    {
        fprintf(stderr, "\nghostreader: \n");
        fprintf(stderr, "Error: unable to open '%s' to read .c file\n", 
		fullpath);
	return(FALSE);
    }
     

    /*
     *    get main_variable_list from .c file
     */
    begin_key = VStrcpy("/* -main_variable_list */");
    end_key = VStrcpy("/* -main_variable_list_end */");
    temp = gw_get_prog_info(cfile, begin_key, end_key, 
			    &status, &dummy, &dummy);
    if (status == VALID_TEXT_BLOCK)
        prog_spec[MainVariables] = VStrcpy(temp);
    else if (status == BEGIN_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find begin key '%s'\n", 
			 cfilename, begin_key);
	fprintf(stderr, "marking the beginning of the text block for\n");
	fprintf(stderr, "variable definitions to go to the main program.\n");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }
    else if (status == END_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find end key '%s'\n", 
			 cfilename, end_key);
	fprintf(stderr, "marking the beginning of the text block for\n");
	fprintf(stderr, "variable definitions to go to the main program.\n");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }
   

    /*
     *    get main_before_lib_call from .c file
     */
    begin_key = VStrcpy("/* -main_before_lib_call */");
    end_key = VStrcpy("/* -main_before_lib_call_end */");
    temp = gw_get_prog_info(cfile, begin_key, end_key, 
			    &status, &dummy, &dummy);
    if (status == VALID_TEXT_BLOCK)
        prog_spec[MainBeforeLib] = VStrcpy(temp);
    else if (status == BEGIN_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find begin key '%s'\n", 
			 cfilename, begin_key);
	fprintf(stderr, "marking the beginning of the text block for code\n");
	fprintf(stderr, "to go before the lib call in the main program.\n");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }
    else if (status == END_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find end key '%s'\n", 
			 cfilename, end_key);
	fprintf(stderr, "marking the beginning of the text block for code\n");
	fprintf(stderr, "to go before the lib call in the main program.\n");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }
   
    /*
     *    get main_library_lib from .c file
     */
    begin_key = VStrcpy("/* -main_library_call */");
    end_key = VStrcpy("/* -main_library_call_end */");
    temp = gw_get_prog_info(cfile, begin_key, end_key,
			    &status, &dummy, &dummy);
    if (status == VALID_TEXT_BLOCK)
        prog_spec[MainLibCall] = VStrcpy(temp);
    else if (status == BEGIN_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find begin key '%s'\n", 
			 cfilename, begin_key);
	fprintf(stderr, "marking the beginning of the text block for \n");
	fprintf(stderr, "the library call in the main program.\n");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }
    else if (status == END_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find end key '%s'\n", 
			 cfilename, end_key);
	fprintf(stderr, "marking the beginning of the text block for \n");
	fprintf(stderr, "the library call in the main program.\n");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }

    
    /*
     *    get main_after_lib_call from .c file
     */
    begin_key = VStrcpy("/* -main_after_lib_call */");
    end_key = VStrcpy("/* -main_after_lib_call_end */");
    temp = gw_get_prog_info(cfile, begin_key, end_key, 
			    &status, &dummy, &dummy);
    if (status == VALID_TEXT_BLOCK)
        prog_spec[MainAfterLib] = VStrcpy(temp);
    else if (status == BEGIN_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find begin key '%s'\n", 
			 cfilename, begin_key);
	fprintf(stderr, "marking the beginning of the text block for code\n");
	fprintf(stderr, "to go after the lib call in the main program.\n");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }
    else if (status == END_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find end key '%s'\n", 
			 cfilename, end_key);
	fprintf(stderr, "marking the beginning of the text block for code\n");
	fprintf(stderr, "to go after the lib call in the main program.\n");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }

    /*
     *    get usage_additions from .c file
     */
    begin_key = VStrcpy("/* -usage_additions */");
    end_key = VStrcpy("/* -usage_additions_end */");
    temp = gw_get_prog_info(cfile, begin_key, end_key,
			    &status, &dummy, &dummy);
    if (status == VALID_TEXT_BLOCK)
        prog_spec[UsageAdd]  =  VStrcpy(temp);  
    else if (status == BEGIN_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find begin key '%s'\n", 
			 cfilename, begin_key);
	fprintf(stderr, "marking the additional code\n");
	fprintf(stderr, "to go into the gw_usage() routine.\n");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }
    else if (status == END_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find end key '%s'\n", 
			 cfilename, end_key);
	fprintf(stderr, "marking the additional code\n");
	fprintf(stderr, "to go into the gw_usage() routine.\n");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }

    fclose(cfile);
    return(TRUE);
}


/************************************************************
*
*  Routine Name: gr_get_hfile_info
*
*      Purpose: This routine gets .prog info from the .h file
*	 	Note that old text blocks will not be over-written
*		if the new text block comes back empty.
*
*        Input: hfilename - full path to .h file 
*		prog_spec -  pointer to the internal program specification
*
*    Called by: ghostreader main
*
*   Written By: Danielle Argiro
*
*************************************************************/

int gr_get_hfile_info(hfilename, prog_spec)
char *hfilename;
char **prog_spec;
{
    int status = 0;
    char *fullpath;
    FILE *hfile;
    char *temp, *dummy, *begin_key, *end_key;

    fullpath = vfullpath(hfilename, NULL, NULL);
    if (!(hfile = fopen(fullpath, "r")))
    {
        fprintf(stderr, "\nghostreader: \n");
        fprintf(stderr, "Error: unable to open '%s' to read .h file\n", 
		fullpath);
	return(FALSE);
    }
     
    /*
     *    get include_includes from .h file
     */
    begin_key = VStrcpy("/* -include_includes */");
    end_key = VStrcpy("/* -include_includes_end */");
    temp = gw_get_prog_info(hfile, begin_key, end_key,
			    &status, &dummy, &dummy);
    if (status == VALID_TEXT_BLOCK)
        prog_spec[IncludeIncludes]  = VStrcpy(temp);
    else if (status == BEGIN_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find begin key '%s'\n", 
			 hfilename, begin_key);
	fprintf(stderr, "marking any extra #include statements\n");
	fprintf(stderr, "to go into the include file.\n");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }
    else if (status == END_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find end key '%s'\n", 
			 hfilename, end_key);
	fprintf(stderr, "marking any extra #include statements\n");
	fprintf(stderr, "to go into the include file.\n");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }


    /*
     *    get include_additions from .h file
     */
    begin_key = VStrcpy("/* -include_additions */");
    end_key = VStrcpy("/* -include_additions_end */");
    temp = gw_get_prog_info(hfile, begin_key, end_key,
			    &status, &dummy, &dummy);
    if (status == VALID_TEXT_BLOCK)
        prog_spec[IncludeAdd] = VStrcpy(temp);
    else if (status == BEGIN_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find begin key '%s'\n", 
			 hfilename, begin_key);
	fprintf(stderr, "marking any additional definitions\n");
	fprintf(stderr, "to go into the include file.\n");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }
    else if (status == END_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find end key '%s'\n", 
			 hfilename, end_key);
	fprintf(stderr, "marking any additional definitions\n");
	fprintf(stderr, "to go into the include file.\n");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }


    /*
     *    get include_macros from .h file
     */
    begin_key = VStrcpy("/* -include_macros */");
    end_key = VStrcpy("/* -include_macros_end */");
    temp = gw_get_prog_info(hfile, begin_key, end_key,
			    &status, &dummy, &dummy);
    if (status == VALID_TEXT_BLOCK)
        prog_spec[IncludeMacros]  = VStrcpy(temp);
    else if (status == BEGIN_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find begin key '%s'\n", 
			 hfilename, begin_key);
	fprintf(stderr, "marking any macro definitions\n");
	fprintf(stderr, "to go into the include file.\n");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }
    else if (status == END_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find end key '%s'\n", 
			 hfilename, end_key);
	fprintf(stderr, "marking any macro definitions\n");
	fprintf(stderr, "to go into the include file.\n");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }

    fclose(hfile);
    return(TRUE);
}



/************************************************************
*
*  Routine Name: gr_get_lfile_info
*
*      Purpose: This routine gets .prog info from the l.c file
*
*        Input: lfilename - full path to l.c file 
*		prog_spec -  pointer to the internal program specification
*
*    Called by: ghostreader main
*
*   Written By: Danielle Argiro
*
*************************************************************/

int gr_get_lfile_info(lfilename, prog_spec)
char *lfilename;
char **prog_spec;
{
    int status = 0;
    char *fullpath;
    FILE *lfile;
    char *temp, *dummy, *begin_key, *end_key;

    fullpath = vfullpath(lfilename, NULL, NULL);
    if (!(lfile = fopen(fullpath, "r")))
    {
        fprintf(stderr, "\nghostreader: \n");
        fprintf(stderr, "Error: unable to open '%s' to read l.c file\n", 
		fullpath);
	return(FALSE);
    }

    /*
     *    get library_includes from l.c file
     */
    begin_key = VStrcpy("/* -library_includes */");
    end_key = VStrcpy("/* -library_includes_end */");
    temp = gw_get_prog_info(lfile, begin_key, end_key,
			    &status, &dummy, &dummy);
    if (status == VALID_TEXT_BLOCK)
        prog_spec[LibraryIncludes] = VStrcpy(temp);
    else if (status == BEGIN_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find begin key '%s'\n", 
			 lfilename, begin_key);
	fprintf(stderr, "marking any additional #include statements\n");
	fprintf(stderr, "to go into the library file.\n");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }
    else if (status == END_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find end key '%s'\n", 
			 lfilename, end_key);
	fprintf(stderr, "marking any additional #include statements\n");
	fprintf(stderr, "to go into the library file.\n");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }

    /*
     *    get library_def from l.c file
     */
    begin_key = VStrcpy("/* -library_def */");
    end_key = VStrcpy("/* -library_def_end */");
    temp = gw_get_prog_info(lfile, begin_key, end_key,
			    &status, &dummy, &dummy);
    if (status == VALID_TEXT_BLOCK)
        prog_spec[LibraryDef] = VStrcpy(temp);
    else if (status == BEGIN_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find begin key '%s'\n", 
			 lfilename, begin_key);
	fprintf(stderr, "marking the definition of the library routine\n");
	fprintf(stderr, "to go into the library file.\n");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }
    else if (status == END_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find end key '%s'\n", 
			 lfilename, end_key);
	fprintf(stderr, "marking the definition of the library routine\n");
	fprintf(stderr, "to go into the library file.\n");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }

    /*
     *    get library_code from l.c file
     */
    begin_key = VStrcpy("/* -library_code */");
    end_key = VStrcpy("/* -library_code_end */");
    temp = gw_get_prog_info(lfile, begin_key, end_key,
			    &status, &dummy, &dummy);
    if (status == VALID_TEXT_BLOCK)
        prog_spec[LibraryCode] = VStrcpy(temp);
    else if (status == BEGIN_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find begin key '%s'\n", 
			 lfilename, begin_key);
	fprintf(stderr, "marking the actual code \n");
	fprintf(stderr, "to go into the library file.\n");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }
    else if (status == END_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find end key '%s'\n", 
			 lfilename, end_key);
	fprintf(stderr, "marking the actual code \n");
	fprintf(stderr, "to go into the library file.\n");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }

    fclose(lfile);
    return(TRUE);
}


/************************************************************
*
*  Routine Name: gr_get_man1file_info
*
*      Purpose: This routine gets .prog info from the man.1 file
*
*        Input: man1filename - full path to .1 file 
*		prog_spec -  pointer to the internal program specification
*
*    Called by: ghostreader main
*
*   Written By: Danielle Argiro
*
*************************************************************/

int gr_get_man1file_info(man1filename, prog_spec, name, format)
char *man1filename;
char **prog_spec;
char *name;
int   format;
{
    int status = 0;
    char *fullpath; 
    char begin_key[MaxLength], end_key[MaxLength];
    FILE *man1file;
    char *temp, *dummy;

    fullpath = vfullpath(man1filename, NULL, NULL);
    if (!(man1file = fopen(fullpath, "r")))
    {
        fprintf(stderr, "\nghostreader: \n");
        fprintf(stderr, "Error: unable to open '%s' to read man.1 file\n", 
		fullpath);
	return(FALSE);
    }
     

    /* 
     * get -short_prog_description from man.1 file 
     */
    if (format == NO_TEXT_FORMATTER)
    {
       sprintf(begin_key, "%s \\-", name);
       sprintf(end_key,   ".fi");
    }
    else if (format == NROFF_FORMATTER)
    {
       sprintf(begin_key, "%s \\-", name);
       sprintf(end_key,   ".SH SYNTAX");
    }
    temp = gw_get_prog_info(man1file, begin_key, end_key, &status,
			    &dummy, &dummy);
    if (status == VALID_TEXT_BLOCK)
        prog_spec[ShortProgDesc] = VStrcpy(temp);
    else if (status == BEGIN_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find begin key '%s'\n", 
			 man1filename, begin_key);
	fprintf(stderr, "marking the short program description\n");
	fprintf(stderr, "in the man1 file.");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }
    else if (status == END_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find end key '%s'\n", 
			 man1filename, end_key);
	fprintf(stderr, "marking the short program description\n");
	fprintf(stderr, "in the man1 file.");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }

    /* 
     * get -man1_long_description from man.1 file 
     */
    if (format == NO_TEXT_FORMATTER)
    {
       sprintf(begin_key, "%s :", name);
       sprintf(end_key,   ".fi");
    }
    else if (format == NROFF_FORMATTER)
    {
       sprintf(begin_key, "%s", ".SH DESCRIPTION");
       sprintf(end_key,   ".SH REQUIRED ARGUMENTS");
    }
    temp = gw_get_prog_info(man1file, begin_key, end_key, &status,
			    &dummy, &dummy);
    if (status == VALID_TEXT_BLOCK)
        prog_spec[Man1LongDesc] = VStrcpy(temp);
    else if (status == BEGIN_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find begin key '%s'\n", 
			 man1filename, begin_key);
	fprintf(stderr, "marking the long program description\n");
	fprintf(stderr, "in the man1 file.");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }
    else if (status == END_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find end key '%s'\n", 
			 man1filename, end_key);
	fprintf(stderr, "marking the long program description\n");
	fprintf(stderr, "in the man1 file.");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }

    /* 
     * get -man1_examples from man.1 file 
     */
    if (format == NO_TEXT_FORMATTER)
    {
       sprintf(begin_key, "~~~~~~");
       sprintf(end_key,   ".fi");
    }
    else if (format == NROFF_FORMATTER)
    {
       sprintf(begin_key, ".SH EXAMPLES");
       sprintf(end_key,   ".SH SEE ALSO");
    }
    temp = gw_get_prog_info(man1file, begin_key, end_key, &status,
			    &dummy, &dummy);
    if (status == VALID_TEXT_BLOCK)
        prog_spec[Man1Examples] = VStrcpy(temp);
    else if (status == BEGIN_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find begin key '%s'\n", 
			 man1filename, begin_key);
	fprintf(stderr, "marking the examples of program usage\n");
	fprintf(stderr, "in the man1 file.");
	fprintf(stderr, "In the new .prog file,\n");
	fprintf(stderr, "this text block will be empty.\n");
    }
    else if (status == END_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find end key '%s'\n", 
			 man1filename, end_key);
	fprintf(stderr, "marking the examples of program usage\n");
	fprintf(stderr, "in the man1 file.");
	fprintf(stderr, "In the new .prog file,\n");
	fprintf(stderr, "this text block will be empty.\n");
    }

    /* 
     * get -man1_see_also from man.1 file 
     */
    if (format == NO_TEXT_FORMATTER)
    {
       sprintf(begin_key, "-and-");
       sprintf(end_key,   ".fi");
       temp = gw_get_prog_info(man1file, begin_key, end_key, &status,
                               &dummy, &dummy);
    }
    else if (format == NROFF_FORMATTER)
    {			   
       sprintf(begin_key,
               "intro(1), verror(3), vgparms(3), vutils(3), l%s(3)\n", name);
       sprintf(end_key,   ".SH RESTRICTIONS");

       temp = gw_get_prog_info(man1file, begin_key, end_key, &status,
			    &dummy, &dummy);
       if (status == BEGIN_KEY_NOT_FOUND) {
           sprintf(begin_key, "intro(1), verror(3), vgparms(3), vutils(3)");
           temp = gw_get_prog_info(man1file, begin_key, end_key, &status,
                               &dummy, &dummy);
       }
       if (status == BEGIN_KEY_NOT_FOUND) {
           sprintf(begin_key,
                    "l%s(3), intro(1), verror(3), vgparms(3), vutils(3)", name);
           temp = gw_get_prog_info(man1file, begin_key, end_key, &status,
                            &dummy, &dummy);
       }
    }

    if (status == VALID_TEXT_BLOCK)
        prog_spec[Man1SeeAlso] = VStrcpy(temp);
    else if (status == BEGIN_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find begin key '%s'\n", 
			 man1filename, begin_key);
	fprintf(stderr, "marking any extra lines to be added to the\n");
	fprintf(stderr, "'see also' section of the man1 file.\n");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }
    else if (status == END_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find end key '%s'\n", 
			 man1filename, end_key);
	fprintf(stderr, "marking any extra lines to be added to the\n");
	fprintf(stderr, "'see also' section of the man1 file.\n");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }

    /* 
     * get -man1_restrictions from man.1 file 
     */
    if (format == NO_TEXT_FORMATTER)
    {
       sprintf(begin_key, "+++++");
       sprintf(end_key,   ".fi");
    }
    else if (format == NROFF_FORMATTER)
    {
      sprintf(begin_key, ".SH RESTRICTIONS");
      sprintf(end_key,  ".SH COPYRIGHT");
    }
    temp = gw_get_prog_info(man1file, begin_key, end_key, &status,
			    &dummy, &dummy);
    if (status == VALID_TEXT_BLOCK)
        prog_spec[Man1Restrictions] = VStrcpy(temp);
    else if (status == BEGIN_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find begin key '%s'\n", 
			 man1filename, begin_key);
	fprintf(stderr, "marking any restrictions on program usage\n");
	fprintf(stderr, "to be explained the man1 file.");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }
    else if (status == END_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file %s, unable to find end key '%s'\n", 
			 man1filename, end_key);
	fprintf(stderr, "marking any restrictions on program usage\n");
	fprintf(stderr, "to be explained the man1 file.");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }

    fclose(man1file);
    return(TRUE);
}



/************************************************************
*
*  Routine Name: gr_get_man3file_info
*
*      Purpose: This routine gets .prog info from the man.3 file
*
*        Input: man3filename - full path to .3 file 
*		prog_spec -  pointer to the internal program specification
*
*    Called by: ghostreader main
*
*   Written By: Danielle Argiro
*
*************************************************************/

int gr_get_man3file_info(man3filename, prog_spec, name, format)
char *man3filename;
char **prog_spec;
char *name;
int   format;
{
    int status = 0;
    char *fullpath; 
    char begin_key[MaxLength], end_key[MaxLength];
    FILE *manfile;
    char *temp, *dummy;

    fullpath = vfullpath(man3filename, NULL, NULL);
    if (!(manfile = fopen(fullpath, "r")))
    {
        fprintf(stderr, "\nghostreader: \n");
        fprintf(stderr, "Error: unable to open '%s' to read man.3 file\n", 
		fullpath);
	return(FALSE);
    }
     
    /* 
     * get -short_lib_description from man.3 file 
     */
    if (format == NO_TEXT_FORMATTER)
    {
       sprintf(begin_key, "l%s \\-", name);
       sprintf(end_key,   ".fi");
    }
    else if (format == NROFF_FORMATTER)
    {
       sprintf(begin_key, "l%s \\-", name);
       sprintf(end_key,   ".SH LIBRARY CALL");
    }
    temp = gw_get_prog_info(manfile, begin_key, end_key, &status,
			    &dummy, &dummy);
    if (status == VALID_TEXT_BLOCK)
        prog_spec[ShortLibDesc] = VStrcpy(temp);

    /* 
     * get -man3_long_description from man.3 file 
     */
    if (format == NO_TEXT_FORMATTER)
    {
       sprintf(begin_key, "l%s :", name);
       sprintf(end_key,   ".fi");
    }
    else if (format == NROFF_FORMATTER)
    {
       sprintf(begin_key, ".SH DESCRIPTION");
       sprintf(end_key,   ".SH SEE ALSO");
    }
    temp = gw_get_prog_info(manfile, begin_key, end_key, &status,
			    &dummy, &dummy);
    if (status == VALID_TEXT_BLOCK)
        prog_spec[Man3LongDesc] = VStrcpy(temp); 

    /* 
     * get -man3_see_also from man.3 file 
     */
    if (format == NO_TEXT_FORMATTER)
    {
       sprintf(begin_key, "-and-");
       sprintf(end_key,   ".fi");
    }
    else if (format == NROFF_FORMATTER)
    {
       sprintf(begin_key, "%s(1), intro(3), vipl(3), verror(3), vutils(3)", name);
       sprintf(end_key,   ".SH RESTRICTIONS");
    }
    temp = gw_get_prog_info(manfile, begin_key, end_key, &status,
			    &dummy, &dummy);
    if (status == VALID_TEXT_BLOCK)
        prog_spec[Man3SeeAlso] = VStrcpy(temp);

    /* 
     * get -library_input from man.3 file 
     */
    if (format == NO_TEXT_FORMATTER)
    {
       sprintf(begin_key, "Input to l%s :", name);
       sprintf(end_key,   ".fi");
    }
    else if (format == NROFF_FORMATTER)
    {
       sprintf(begin_key, ".SH INPUT");
       sprintf(end_key,   ".SH OUTPUT");
    }
    temp = gw_get_prog_info(manfile, begin_key, end_key, &status,
			    &dummy, &dummy);
    if (status == VALID_TEXT_BLOCK)
       prog_spec[LibraryInput]  = VStrcpy(temp);

    /* 
     * get -library_output from man.3 file 
     */
    if (format == NO_TEXT_FORMATTER)
    {
       sprintf(begin_key, "Output from l%s :", name);
       sprintf(end_key,   ".fi");
    }
    else if (format == NROFF_FORMATTER)
    {
       sprintf(begin_key, ".SH OUTPUT");
       sprintf(end_key,   ".SH MODIFICATIONS");
    }
    temp = gw_get_prog_info(manfile, begin_key, end_key, &status,
			    &dummy, &dummy);
    if (status == VALID_TEXT_BLOCK)
        prog_spec[LibraryOutput] = VStrcpy(temp);

    /* 
     * get -library_mods from man.3 file 
     */
    if (format == NO_TEXT_FORMATTER)
    {
       sprintf(begin_key, "Modifications to l%s :", name);
       sprintf(end_key,   ".fi");
    }
    else if (format == NROFF_FORMATTER)
    {
       sprintf(begin_key, ".SH MODIFICATIONS");
       sprintf(end_key,   ".SH DESCRIPTION");
    }
    temp = gw_get_prog_info(manfile, begin_key, end_key, &status,
			    &dummy, &dummy);
    if (status == VALID_TEXT_BLOCK)
        prog_spec[LibraryMods] = VStrcpy(temp);

    /* 
     * get -authors from man.3 file 
     */
    sprintf(begin_key, ".SH AUTHOR");
    sprintf(end_key,   ".sp");
    temp = gw_get_prog_info(manfile, begin_key, end_key, &status,
			    &dummy, &dummy);
    if (status == VALID_TEXT_BLOCK)
        prog_spec[Authors] = VStrcpy(temp); 


    /* 
     * get -man3_restrictions from man.3 file 
     */
    if (format == NO_TEXT_FORMATTER)
    {
       sprintf(begin_key, "+++++");
       sprintf(end_key,   ".fi");
    }
    else if (format == NROFF_FORMATTER)
    {
      sprintf(begin_key, ".SH RESTRICTIONS");
      sprintf(end_key,  ".SH AUTHOR");
    }
    temp = gw_get_prog_info(manfile, begin_key, end_key, &status,
			    &dummy, &dummy);
    if (status == VALID_TEXT_BLOCK)
        prog_spec[Man3Restrictions] = VStrcpy(temp);
    else if (status == BEGIN_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file l%s, unable to find begin key '%s'\n", 
			 man3filename, begin_key);
	fprintf(stderr, "marking any restrictions on program usage\n");
	fprintf(stderr, "to be explained the man3 file.");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }
    else if (status == END_KEY_NOT_FOUND)
    {
	fprintf(stderr, "\nghostreader warning:\n");
	fprintf(stderr, "In file l%s, unable to find end key '%s'\n", 
			 man3filename, end_key);
	fprintf(stderr, "marking any restrictions on program usage\n");
	fprintf(stderr, "to be explained the man3 file.");
	fprintf(stderr, "In the new .prog file,");
	fprintf(stderr, "this text block will be empty.\n");
    }

    fclose(manfile);
    return(TRUE);
}
