 /*
  * Khoros: $Id: writeprog.c,v 1.2 1991/12/18 09:58:37 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: writeprog.c,v 1.2 1991/12/18 09:58:37 dkhoros Exp $";
#endif

 /*
  * $Log: writeprog.c,v $
 * Revision 1.2  1991/12/18  09:58:37  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "ghost.h"
#include "vinclude.h"

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>  	File Name: writeprog.c                        <<<<
   >>>>                                                       <<<<
   >>>>               gr_write_progfile()		      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */



/************************************************************
*
*  Routine Name: gr_write_progfile
*
*      Purpose: This routine creates a new .prog file
*
*        Input: prog_spec-  pointer to the internal program specification
*               name     -  name of the program being generated
*
*    Called by: ghostreader main
*
*   Written By: Danielle Argiro
*
*************************************************************/

int gr_write_progfile(filename, prog_spec, keynames, force)
char *filename;
char **prog_spec;
char **keynames[2];
int  force;
{
     FILE *file;
     char  temp[MaxLength], *fullpath, resp;

     /*
      *  see if *.prog file already exists.  If so, prompt to over-write.
      */
     fullpath = vfullpath(filename, NULL, NULL);
     if (access(fullpath, F_OK) == 0)
     {
	 if (!(force))
         {
            fprintf(stderr, "\nOverwrite file '%s'?  [y/n]: ", filename);
            fgets(temp, MaxLength, stdin);
            sscanf(temp, "%c", &resp);
            if ((resp != 'y') && (resp != 'Y')) return(FALSE);
	 }
     }

     /*
      *  create & open *.prog file
      */
     if ((file = fopen(fullpath, "w"))== NULL)
     {
          fprintf(stderr, "\ngr_write_progfile:\n");
          fprintf(stderr, "  Could not create file '%s'\n", filename);
          return(FALSE);
     }

    /*
     *   write out the new .prog file
     */

	/** miscellaneous ***/

     fprintf(file, "%s\n", keynames[0][Authors]);
     if (prog_spec[Authors] != NULL)
        fprintf(file, "%s", prog_spec[Authors]);
     fprintf(file, "%s\n\n", keynames[1][Authors]);

     fprintf(file, "%s\n", keynames[0][ShortProgDesc]);
     if (prog_spec[ShortProgDesc] != NULL)
        fprintf(file, "%s", prog_spec[ShortProgDesc]);
     fprintf(file, "%s\n\n", keynames[1][ShortProgDesc]);

     fprintf(file, "%s\n", keynames[0][ShortLibDesc]);
     if (prog_spec[ShortLibDesc] != NULL)
        fprintf(file, "%s", prog_spec[ShortLibDesc]);
     fprintf(file, "%s\n\n", keynames[1][ShortLibDesc]);

	/** man1 ***/

     fprintf(file, "%s\n", keynames[0][Man1LongDesc]);
     if (prog_spec[Man1LongDesc] != NULL)
        fprintf(file, "%s", prog_spec[Man1LongDesc]);
     fprintf(file, "%s\n\n", keynames[1][Man1LongDesc]);
    
     fprintf(file, "%s\n", keynames[0][Man1Examples]);
     if (prog_spec[Man1Examples] != NULL)
        fprintf(file, "%s", prog_spec[Man1Examples]);
     fprintf(file, "%s\n\n", keynames[1][Man1Examples]);

     fprintf(file, "%s\n", keynames[0][Man1Restrictions]);
     if (prog_spec[Man1Restrictions] != NULL)
        fprintf(file, "%s", prog_spec[Man1Restrictions]);
     fprintf(file, "%s\n\n", keynames[1][Man1Restrictions]);
   
     fprintf(file, "%s\n", keynames[0][Man1SeeAlso]);
     if (prog_spec[Man1SeeAlso] != NULL)
	if (VStrcmp(prog_spec[Man1SeeAlso], "\n")!= 0)
           fprintf(file, "%s", prog_spec[Man1SeeAlso]);
     fprintf(file, "%s\n\n", keynames[1][Man1SeeAlso]);
   
	/** man3 ***/

     fprintf(file, "%s\n", keynames[0][Man3LongDesc]);
     if (prog_spec[Man3LongDesc] != NULL)
	if (VStrcmp(prog_spec[Man3LongDesc], "\n")!= 0)
            fprintf(file, "%s", prog_spec[Man3LongDesc]);
     fprintf(file, "%s\n\n", keynames[1][Man3LongDesc]);

     fprintf(file, "%s\n", keynames[0][Man3Restrictions]);
     if (prog_spec[Man3Restrictions] != NULL)
	if (VStrcmp(prog_spec[Man3Restrictions], "\n")!= 0)
             fprintf(file, "%s", prog_spec[Man3Restrictions]);
     fprintf(file, "%s\n\n", keynames[1][Man3Restrictions]);
   
     fprintf(file, "%s\n", keynames[0][Man3SeeAlso]);
     if (prog_spec[Man3SeeAlso] != NULL)
	if (VStrcmp(prog_spec[Man3SeeAlso], "\n")!= 0)
             fprintf(file, "%s", prog_spec[Man3SeeAlso]);
     fprintf(file, "%s\n\n", keynames[1][Man3SeeAlso]);
   
	/** program usage ***/

     fprintf(file, "%s\n", keynames[0][UsageAdd]);
     if (prog_spec[UsageAdd] != NULL)
         fprintf(file, "%s", prog_spec[UsageAdd]);
     fprintf(file, "%s\n\n", keynames[1][UsageAdd]);
   
	/** .h file ***/

     fprintf(file, "%s\n", keynames[0][IncludeIncludes]);
     if (prog_spec[IncludeIncludes] != NULL)
        fprintf(file, "%s", prog_spec[IncludeIncludes]);
     fprintf(file, "%s\n\n", keynames[1][IncludeIncludes]);

     fprintf(file, "%s\n", keynames[0][IncludeAdd]);
     if (prog_spec[IncludeAdd] != NULL)
        fprintf(file, "%s", prog_spec[IncludeAdd]);
     fprintf(file, "%s\n\n", keynames[1][IncludeAdd]);
   
     fprintf(file, "%s\n", keynames[0][IncludeMacros]);
     if (prog_spec[IncludeMacros] != NULL)
        fprintf(file, "%s", prog_spec[IncludeMacros]);
     fprintf(file, "%s\n\n", keynames[1][IncludeMacros]);
   
	/** .c file ***/

     fprintf(file, "%s\n", keynames[0][MainVariables]);
     if (prog_spec[MainVariables] != NULL)
        fprintf(file, "%s", prog_spec[MainVariables]);
     fprintf(file, "%s\n\n", keynames[1][MainVariables]);
   
     fprintf(file, "%s\n", keynames[0][MainBeforeLib]);
     if (prog_spec[MainBeforeLib] != NULL)
        fprintf(file, "%s", prog_spec[MainBeforeLib]);
     fprintf(file, "%s\n\n", keynames[1][MainBeforeLib]);
   
     fprintf(file, "%s\n", keynames[0][MainLibCall]);
     if (prog_spec[MainLibCall] != NULL)
        fprintf(file, "%s", prog_spec[MainLibCall]);
     fprintf(file, "%s\n\n", keynames[1][MainLibCall]);

     fprintf(file, "%s\n", keynames[0][MainAfterLib]);
     if (prog_spec[MainAfterLib] != NULL)
         fprintf(file, "%s", prog_spec[MainAfterLib]);
     fprintf(file, "%s\n\n", keynames[1][MainAfterLib]);
    
	/** library file ***/

     fprintf(file, "%s\n", keynames[0][LibraryIncludes]);
     if (prog_spec[LibraryIncludes] != NULL)
        fprintf(file, "%s", prog_spec[LibraryIncludes]);
     fprintf(file, "%s\n\n", keynames[1][LibraryIncludes]);
   
     fprintf(file, "%s\n", keynames[0][LibraryInput]);
     if (prog_spec[LibraryInput] != NULL)
	if (VStrcmp(prog_spec[LibraryInput], "\n")!= 0)
             fprintf(file, "%s", prog_spec[LibraryInput]);
     fprintf(file, "%s\n\n", keynames[1][LibraryInput]);
   
     fprintf(file, "%s\n", keynames[0][LibraryOutput]);
     if (prog_spec[LibraryOutput] != NULL)
	if (VStrcmp(prog_spec[LibraryOutput], "\n")!= 0)
             fprintf(file, "%s", prog_spec[LibraryOutput]);
     fprintf(file, "%s\n\n", keynames[1][LibraryOutput]);

     fprintf(file, "%s\n", keynames[0][LibraryDef]);
     if (prog_spec[LibraryDef] != NULL)
         fprintf(file, "%s", prog_spec[LibraryDef]);
     fprintf(file, "%s\n\n", keynames[1][LibraryDef]);
   
     fprintf(file, "%s\n", keynames[0][LibraryCode]);
     if (prog_spec[LibraryCode] != NULL)
         fprintf(file, "%s", prog_spec[LibraryCode]);
     fprintf(file, "%s\n\n", keynames[1][LibraryCode]);
   
     fprintf(file, "%s\n", keynames[0][LibraryMods]);
     if (prog_spec[LibraryMods] != NULL)
	if (VStrcmp(prog_spec[LibraryInput], "\n")!= 0)
            fprintf(file, "%s", prog_spec[LibraryMods]);
     fprintf(file, "%s\n\n", keynames[1][LibraryMods]);

     fclose(file);
     return(TRUE);
}
