 /*
  * Khoros: $Id: prope_colr.c,v 1.1 1991/05/10 15:40:47 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: prope_colr.c,v 1.1 1991/05/10 15:40:47 khoros Exp $";
#endif

 /*
  * $Log: prope_colr.c,v $
 * Revision 1.1  1991/05/10  15:40:47  khoros
 * Initial revision
 *
  */ 

/*
#
# FILE NAME:	prope_colr.c
# 
# AUTHORS:	Tom Sauer, John Rasure
#               Modified from code done origianlly by Marcelo Teran
# 
# DATE:		2/6/89
# 
# DESCRIPTION:	Contains module proper_color_model().
# 
# MODIFICATIONS:
#		John Rasure modified error messages.
#		Sat Jun  2 23:37:39 MDT 1990
# 
# ROUTINES:	proper_color_model()
#		
*/

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */

#include "vinclude.h"	  


/**************************************************************
*
* MODULE NAME: 	proper_color_model()
*
*     PURPOSE:	Check to see if a viff data structure has the correct
*               color space model.
*
*       INPUT:  prog 	- program name
*		*image	- viff data
*		type	- desired color map model
*		exit_flag
*
*      OUTPUT:  If exit_flag is true and match fails, an error 
*          	message is printed.
*      		If exit_flag is false and match fails, return(0).
*
*       USAGE:	If exit_flag is set, The routine will print out an
*		error message and then exit().  In this case, the
*		function should be declared (void).  If exit_flag
*               is not set (equal 0) then the function should be
*		declared int.
*
*
**************************************************************/
proper_color_model(prog,image,type,exit_flag)
char  *prog;
struct xvimage *image;
unsigned long type;
int exit_flag;
{
   if (image->color_space_model != type) {
      if (exit_flag == TRUE) {
         (void) fprintf(stderr, "\nError in program %s: \n",prog);
         (void) fprintf(stderr, 
"The color space model should be converted to make it compatible with\n");
         (void) fprintf(stderr, 
"this program.\n");
         switch(type){
            case VFF_CM_NONE :
               (void) fprintf(stderr, "Color space model should be VFF_CM_NONE\n");
               exit(1);
               break;
            case VFF_CM_genericRGB :
               (void) fprintf(stderr, "Color space model should be VFF_CM_genericRGB\n");
               exit(1);
               break;
            case VFF_CM_ntscRGB :
               (void) fprintf(stderr, "Color space model should be VFF_CM_ntscRGB\n");
               exit(1);
               break;
            case VFF_CM_ntscCMY :
               (void) fprintf(stderr, "Color space model should be VFF_CM_ntscCMY\n");
               exit(1);
               break;
            case VFF_CM_ntscYIQ :
               (void) fprintf(stderr, "Color space model should be VFF_CM_ntscYIQ\n");
               exit(1);
               break;
            case VFF_CM_HSV :
               (void) fprintf(stderr, "Color space model should be VFF_CM_HSV\n");
               exit(1);
               break;
            case VFF_CM_HLS :
               (void) fprintf(stderr, "Color space model should be VFF_CM_HLS\n");
               exit(1);
               break;
            case VFF_CM_IHS :
               (void) fprintf(stderr, "Color space model should be VFF_CM_IHS\n");
               exit(1);
               break;
            case VFF_CM_cieRGB :
               (void) fprintf(stderr, "Color space model should be VFF_CM_cieRGB\n");
               exit(1);
               break;
            case VFF_CM_cieXYZ :
               (void) fprintf(stderr, "Color space model should be VFF_CM_cieXYZ\n");
               exit(1);
               break;
            case VFF_CM_cieUVW :
               (void) fprintf(stderr, "Color space model should be VFF_CM_cieUVW\n");
               exit(1);
               break;
            case VFF_CM_cieucsUVW :
               (void) fprintf(stderr, "Color space model should be VFF_CM_cieucsUVW\n");
               exit(1);
               break;
            case VFF_CM_cieucsSOW :
               (void) fprintf(stderr, "Color space model should be VFF_CM_cieucsSOW\n");
               exit(1);
               break;
            case VFF_CM_cieucsLab :
               (void) fprintf(stderr, "Color space model should be VFF_CM_cieucsLab\n");
               exit(1);
               break;
            case VFF_CM_cieucsLuv :
               (void) fprintf(stderr, "Color space model should be VFF_CM_cieucsLuv\n");
               exit(1);
               break;
            case VFF_CM_GENERIC :
               (void) fprintf(stderr, "Color space model should be VFF_CM_GENERIC\n");
               exit(1);
               break;
            default :
               (void) fprintf(stderr, "Color space model is unknown.\n");
               exit(1);
               break;
	 }
      }
      else {
         return(0);
      }
   }
return(1);
}
