 /*
  * Khoros: $Id: init_makec.c,v 1.2 1991/10/02 00:32:59 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: init_makec.c,v 1.2 1991/10/02 00:32:59 khoros Exp $";
#endif

 /*
  * $Log: init_makec.c,v $
 * Revision 1.2  1991/10/02  00:32:59  khoros
 * HellPatch2
 *
  */ 

/******************************************************************

	Initialize Make File function

	source filename:			init_makec.c

	revision	  date			programmer
	--------	  ----			----------
	   0.0		April-01-85		don hush
	   0.1          Sept 7, 1987            John M Salas

******************************************************************

	usage
	-----
	make = init_makec()

	int make;

	description
	-----------
	make = TRUE if a make file is initiated
	       and FALSE if not.

        0.1 - Modified so that the - symbol can be used as the
	      designation for input/output to be stdin/stdout.
	      In conjunction with uio routines and to keep the
	      UNIX standard.  But, kept the ability to have
	      no input/output file specified.

	other functions called
	----------------------

******************************************************************/

#include "vgparm.h"

char make_name[80];

extern char **av;
init_makec()

{

    char ans[10], *malloc(), *prompt, *temp_name;
    int fd, len, nread, tty_fd;

    if (!get_arg_clc("-A",make_name,'s')) {
	if (make_name[0]=='\0')
	    (void) sprintf(make_name, "%s.ans", av[0]);

	if (!strcmp(make_name,"-"))
	    return(TRUE);

	fd = open(make_name,O_WRONLY,0666);

        if(fd < 0) {
	    if ( (fd = open(make_name,O_WRONLY | O_CREAT,MODE)) < 0 )
                fprintf(stderr,"\nwarning -- init_make cannot open -> %s <-\n",make_name);
	}
	else {

            tty_fd = open("/dev/tty",O_RDWR,MODE);
            if (tty_fd < 0){
/*
... if can not open tty for prompting, exit.
*/
                fprintf(stderr,"\nERROR-init_make cannot open channel to terminal\n");
                exit(1);
            }

            prompt = malloc(BUFFERSIZE);
	    if(prompt == NULL) {
                fprintf(stderr,"\nERROR-init_make cannot allocate more memory\n");
                exit(1);
            }
            sprintf(prompt,"File --> %s <-- already exists !!\nDo you want to overwrite ? (y/n) ",make_name);
            len = strlen(prompt);

            write(tty_fd,prompt,len);
            read(tty_fd,ans,BUFFERSIZE);
/*
... determine if user wants to overwrite ...
*/
            if (ans[0] != 'y') {
                temp_name = malloc(BUFFERSIZE);
	        if(temp_name == NULL) {
                    fprintf(stderr,"\nERROR-init_make cannot allocate more memory\n");
                    exit(1);
                }
/*
... if not, kept prompting till file specified does not excist  ...
*/
                while (fd > 0) {
                    strcpy(prompt,"Please enter a new filename --> ");
                    len = strlen(prompt);

                    write(tty_fd,prompt,len);
                    nread = read(tty_fd,temp_name,BUFFERSIZE);

                    temp_name[nread-1] = '\0';

                    fd = open(temp_name,O_WRONLY,MODE);
                }

                strcpy(make_name,temp_name);

                if ((fd = open(make_name,O_WRONLY | O_CREAT,MODE))<0)
                    fprintf(stderr,"\nwarning -- init_make cannot open -> %s <-\n",temp_name);

                free(temp_name);
                free(prompt);
            }
            else 
/*
... if so, overwrite file as user requested ...
*/
            if ((fd = open(make_name,O_WRONLY | O_TRUNC,MODE))<0)
                fprintf(stderr,"\nwarning -- init_make cannot open -> %s <-\n",make_name);

            close(tty_fd);
        }
	close(fd);
	return(TRUE);
    }
    else
	return(FALSE);
}
