 /*
  * Khoros: $Id: cp_imgdata.c,v 1.2 1991/12/18 09:55:59 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: cp_imgdata.c,v 1.2 1991/12/18 09:55:59 dkhoros Exp $";
#endif

 /*
  * $Log: cp_imgdata.c,v $
 * Revision 1.2  1991/12/18  09:55:59  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

/*
#
# FILE NAME:	cp_imgdata.c
# 
# AUTHORS:	Ron E. Neher
# 
# DATE:		3/23/89
# 
# DESCRIPTION:	Copy image data
# 
# MODIFICATIONS:
# 
*/

/*INCLUDE*/
#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "vdefines.h"	 	
#include "viff.h"	 	
#include <stdio.h>

#define LENGTH 512

/**************************************************************
*
* MODULE NAME: copyimagedata
*
*     PURPOSE: Copy image data
*
*       INPUT: 	img1 -- original image
*		img2 -- pointer to new copy of img1
*		malloc_flg -- if set (=1) malloc room
*
*      OUTPUT: 	returns a 1 upon success and a zero upon failure.
*
* CALLED FROM: 
*
* ROUTINES CALLED:
*
**************************************************************/
int
copyimagedata(img1, img2, malloc_flg)
struct
xvimage	*img1,
	**img2;
int	malloc_flg;
{
long	lsize;

/* room for the image data */

    switch (img1->data_storage_type)
    {
	case VFF_TYP_BIT:
	    lsize = ((img1->row_size+7)/8)*img1->col_size;
	    break;
	case VFF_TYP_1_BYTE:
	    lsize = img1->col_size*img1->row_size;
	    break;
	case VFF_TYP_2_BYTE:
	    lsize = img1->col_size*img1->row_size*sizeof(short);
	    break;
	case VFF_TYP_4_BYTE:
	    lsize = img1->col_size*img1->row_size*sizeof(int);
	    break;
	case VFF_TYP_FLOAT:
	    lsize = img1->col_size*img1->row_size*sizeof(float);
	    break;
	case VFF_TYP_DOUBLE:
	    lsize = img1->col_size*img1->row_size*sizeof(double);
	    break;
	case VFF_TYP_COMPLEX:
	    lsize = img1->col_size*img1->row_size*sizeof(float)*2;
	    break;
	case VFF_TYP_DCOMPLEX:
	    lsize = img1->col_size*img1->row_size*sizeof(double)*2;
	    break;
	default:
	    (void) fprintf(stderr,"copyimagedata: Not valid data \
storage type\n");
	    return(0);
	    break;
    }
    lsize = lsize*img1->num_of_images*img1->num_data_bands;
    if (malloc_flg)
        if (((*img2)->imagedata = malloc((unsigned int) lsize)) == NULL)
        {
	    (void) fprintf(stderr,"copyimagedata: Not enough memory for\
 image data!\n");
	    return(0);
        }

    bcopy(img1->imagedata, (*img2)->imagedata, (int) lsize);

    (*img2)->data_storage_type = img1->data_storage_type;
    (*img2)->row_size = img1->row_size;
    (*img2)->col_size = img1->col_size;
    (*img2)->num_of_images = img1->num_of_images;
    (*img2)->num_data_bands = img1->num_data_bands;

    return(1);
}
