 /*
  * Khoros: $Id: dacorr.c,v 1.2 1992/03/20 23:18:48 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dacorr.c,v 1.2 1992/03/20 23:18:48 dkhoros Exp $";
#endif

 /*
  * $Log: dacorr.c,v $
 * Revision 1.2  1992/03/20  23:18:48  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dacorr.c
 >>>>
 >>>>      Program Name: dacorr
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Autocorrelation sequence of 1-D signal(s)
 >>>>	
 >>>>	

 >>>>            Author: Ramiro Jordan, Jeremy Worley
 >>>>
 >>>> Date Last Updated: Mon Mar  9 20:14:31 1992
 >>>>
 >>>>          Routines: main- the main program for dacorr
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dacorr.h"


/****************************************************************
 *
 * Routine Name:  main program for dacorr
 *
 *       Input:  
 *        -i  input data file (xviff file) 
 *        -o  resulting output file (xviff file) 
 *
 *
 *        [-s] number of points for autocorrelation sequence  (value > 0)
 *        [-j] define arithmetic on data
 *        [-d] data processing direction (0 = down vectors, 1 = across bands)
 *        [-g] type of autocorrelation file to be created
 *		0 (choose biased autocorrelation estimate),
 *		1 (choose unbiased autocorrelation estimate),
 *		or 2 (choose FFT based autocorrelation estimate)
 *		   [default = 0] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image, *readimage();
int     out_option, arith_type, points, process_dir;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);
READIMAGE(image);
CHECKTYPE(program,image);
CHECKINPUT(program,image);

arith_type = dacorr->j_logic;
out_option = dacorr->g_toggle;
points = dacorr->s_int;
process_dir = dacorr->d_logic;
/* -main_before_lib_call_end */

/* -main_library_call */
if(! ldacorr ( image, arith_type, out_option, points, process_dir ) )
        {
            (void) fprintf(stderr, "ldacorr Failed\n");
            exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(dacorr->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dacorr 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dacorr :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tAutocorrelation sequence of 1-D signal(s)\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input data file (xviff file)  (infile)\n");
	fprintf(stderr,"\t-o  resulting output file (xviff file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-s]  number of points for autocorrelation sequence (integer, > 0) [256]\n");
	fprintf(stderr,"\t[-j]  define arithmetic on data (boolean) [true]\n");
	fprintf(stderr,"\t[-d]  data processing direction (0 = down vectors, 1 = across bands) (boolean) [true]\n");
	fprintf(stderr, "\t[-g]  type of autocorrelation file to be created\n");
	fprintf(stderr, "\t\t0  (choose biased autocorrelation estimate),\n");
	fprintf(stderr, "\t\t1  (choose unbiased autocorrelation estimate),\n");
	fprintf(stderr, "\t\tor 2  (choose FFT based autocorrelation estimate)\n");
	fprintf(stderr, "\t\t[default = 0]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dacorr\n");
	fprintf(stderr, "\t[-U] Gives the usage for dacorr\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dacorr.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dacorr.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dacorr
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input data file (xviff file) \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output file (xviff file) \n        {outfile}: "; 
char	*s_pstr = 
	"\nEnter: (s) number of points for autocorrelation sequence \n        {integer, > 0 [256] }: "; 
char	*j_pstr = 
	"\nEnter: (j) define arithmetic on data \n        {boolean, (y/n)  [yes] }: "; 
char	*d_pstr = 
	"\nEnter: (d) data processing direction (0 = down vectors, 1 = across bands) \n        {boolean, (y/n)  [yes] }: "; 
char	*g_pstr = "\nEnter: (g) type of autocorrelation file to be created -- \n      \t\t0 (choose biased autocorrelation estimate)\n\t\t1 (choose unbiased autocorrelation estimate)\n\t\tor 2 (choose FFT based autocorrelation estimate)\n  [0]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dacorr", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dacorr.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dacorr: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dacorr.ans");
		}

	     }

	}

	/*
	 * allocate the dacorr structure
	 */
	dacorr = (dacorr_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dacorr_struct));

	/*
	 * get required arguments for dacorr
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dacorr->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(dacorr->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dacorr->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    dacorr->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(dacorr->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(dacorr->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dacorr->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dacorr->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dacorr->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dacorr->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dacorr
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dacorr->s_flag = vget_int(fid, prompt_flag,
	"-s", s_pstr, &(dacorr->s_int),
	256, 2, 2);

	dacorr->j_flag = vget_logic(fid, prompt_flag,
	"-j", j_pstr, &(dacorr->j_logic), 1);

	dacorr->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(dacorr->d_logic), 1);


	/*
	 * get optional toggles for dacorr
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		dacorr->g_flag = vget_int(fid, prompt_flag,
		"-g", g_pstr, &(dacorr->g_toggle),
		0, 0, 0);

		if ((dacorr->g_toggle == 0 ) || 
		    (dacorr->g_toggle == 1 ) || 
		    (dacorr->g_toggle == 2 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		dacorr->g_flag = vget_int(fid, prompt_flag,
		"-g", g_pstr, &(dacorr->g_toggle),
		0, 0, 0);

		if ((dacorr->g_toggle != 0 ) && 
		    (dacorr->g_toggle != 1 ) && 
		    (dacorr->g_toggle != 2 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



