 /*
  * Khoros: $Id: dihart1d.c,v 1.2 1992/03/20 23:22:44 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dihart1d.c,v 1.2 1992/03/20 23:22:44 dkhoros Exp $";
#endif

 /*
  * $Log: dihart1d.c,v $
 * Revision 1.2  1992/03/20  23:22:44  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dihart1d.c
 >>>>
 >>>>      Program Name: dihart1d
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Performs  the  1D  inverse  Hartley  transform  of  a   data
 >>>>	sequence.
 >>>>	
 >>>>	

 >>>>            Author: Jeremy Worley
 >>>>
 >>>> Date Last Updated: Sat Feb 15 16:39:21 1992
 >>>>
 >>>>          Routines: main- the main program for dihart1d
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dihart1d.h"


/****************************************************************
 *
 * Routine Name:  main program for dihart1d
 *
 *       Input:  
 *          -i  input data file (xviff file) 
 *          -o  resulting output file (xviff file) 
 *
 *
 *          [-c] select to center (1) or not to center (0) the transform
 *          [-d] data processing direction (0 = down vectors, 1 = across bands)
 *          [-s] scale fft by 1, 1/N or 1/sqrt(N)
 *		0 (Do not scale the output data),
 *		1 (Scale output data by 1/N),
 *		or 2 (Scale output data by 1/sqrt(N))
 *		   [default = 1] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);

/*
** read in image
*/

image = readimage(dihart1d->i_file); 

   if (image == NULL) { 
      (void) fprintf(stderr, "dihart1d: Can not read input image \n"); 
      exit(1);  /* Quit if bad image */ 
   }

/*
** check to make sure that the data is of the proper type
*/

    if( ! (propertype(program,image,VFF_TYP_FLOAT,FALSE))){ 
          fprintf(stderr,
             "%s: data storage type must be float or complex.",
             program); 
          exit(1); 
    }

/*
** check some other things out about the image
*/

    proper_num_images(program,image,1,TRUE); 
    proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE);

/* -main_before_lib_call_end */

/* -main_library_call */
if(!ldhart1d(image,0,dihart1d->c_logic,dihart1d->s_toggle,dihart1d->d_logic))
        {
            (void) fprintf(stderr, "ldihart1d Failed\n");
            exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(dihart1d->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dihart1d 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dihart1d :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tPerforms  the  1D  inverse  Hartley  transform  of  a   data\n");
	fprintf(stderr, "\tsequence.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
(void) fprintf(stderr,"where \"-c\", the centering factor can be:\n");
(void) fprintf(stderr,"      \"0\" centered about its N/2 term (default)\n");
(void) fprintf(stderr,"      \"1\" not centered\n");
(void) fprintf(stderr,"where \"-s\", the scaling factor can be:\n");
(void) fprintf(stderr,"      \"0\" No scaling (default)\n");
(void) fprintf(stderr,"      \"1\" Scale the output data by 1/N\n");
(void) fprintf(stderr,"      \"2\" Scale the output data by 1/sqrt(N)\n");
(void) fprintf(stderr,"where \"-d\", the direction of processing factor can be:\n");
(void) fprintf(stderr,"      \"0\" process in the vector direction (default)\n");
(void) fprintf(stderr,"      \"1\" process in the band direction\n");


/* -usage_additions_end */

	fprintf(stderr,"\t-i  input data file (xviff file)  (infile)\n");
	fprintf(stderr,"\t-o  resulting output file (xviff file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-c]  select to center (1) or not to center (0) the transform (boolean) [false]\n");
	fprintf(stderr,"\t[-d]  data processing direction (0 = down vectors, 1 = across bands) (boolean) [true]\n");
	fprintf(stderr, "\t[-s]  scale fft by 1, 1/N or 1/sqrt(N)\n");
	fprintf(stderr, "\t\t0  (Do not scale the output data),\n");
	fprintf(stderr, "\t\t1  (Scale output data by 1/N),\n");
	fprintf(stderr, "\t\tor 2  (Scale output data by 1/sqrt(N))\n");
	fprintf(stderr, "\t\t[default = 1]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dihart1d\n");
	fprintf(stderr, "\t[-U] Gives the usage for dihart1d\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dihart1d.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dihart1d.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dihart1d
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input data file (xviff file) \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output file (xviff file) \n        {outfile}: "; 
char	*c_pstr = 
	"\nEnter: (c) select to center (1) or not to center (0) the transform \n        {boolean, (y/n)  [no] }: "; 
char	*d_pstr = 
	"\nEnter: (d) data processing direction (0 = down vectors, 1 = across bands) \n        {boolean, (y/n)  [yes] }: "; 
char	*s_pstr = "\nEnter: (s) scale fft by 1, 1/N or 1/sqrt(N) -- \n      \t\t0 (Do not scale the output data)\n\t\t1 (Scale output data by 1/N)\n\t\tor 2 (Scale output data by 1/sqrt(N))\n  [1]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dihart1d", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dihart1d.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dihart1d: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dihart1d.ans");
		}

	     }

	}

	/*
	 * allocate the dihart1d structure
	 */
	dihart1d = (dihart1d_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dihart1d_struct));

	/*
	 * get required arguments for dihart1d
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dihart1d->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(dihart1d->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dihart1d->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    dihart1d->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(dihart1d->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(dihart1d->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dihart1d->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dihart1d->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dihart1d->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dihart1d->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dihart1d
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dihart1d->c_flag = vget_logic(fid, prompt_flag,
	"-c", c_pstr, &(dihart1d->c_logic), 0);

	dihart1d->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(dihart1d->d_logic), 1);


	/*
	 * get optional toggles for dihart1d
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		dihart1d->s_flag = vget_int(fid, prompt_flag,
		"-s", s_pstr, &(dihart1d->s_toggle),
		1, 0, 0);

		if ((dihart1d->s_toggle == 0 ) || 
		    (dihart1d->s_toggle == 1 ) || 
		    (dihart1d->s_toggle == 2 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		dihart1d->s_flag = vget_int(fid, prompt_flag,
		"-s", s_pstr, &(dihart1d->s_toggle),
		1, 0, 0);

		if ((dihart1d->s_toggle != 0 ) && 
		    (dihart1d->s_toggle != 1 ) && 
		    (dihart1d->s_toggle != 2 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



