 /*
  * Khoros: $Id: viff2mat.c,v 1.3 1992/03/20 23:36:34 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: viff2mat.c,v 1.3 1992/03/20 23:36:34 dkhoros Exp $";
#endif

 /*
  * $Log: viff2mat.c,v $
 * Revision 1.3  1992/03/20  23:36:34  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: viff2mat.c
 >>>>
 >>>>      Program Name: viff2mat
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	viff2mat - outputs a matrix in desired form.
 >>>>	
 >>>>	

 >>>>            Author: Matthew Lawrence,Jeremy Worley
 >>>>
 >>>> Date Last Updated: Thu Mar 19 17:41:57 1992
 >>>>
 >>>>          Routines: main- the main program for viff2mat
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "viff2mat.h"


/****************************************************************
 *
 * Routine Name:  main program for viff2mat
 *
 *       Input:  
 *          -i  input file (image file) 
 *          -o  resulting output file (matrix file) 
 *
 *
 *          [-e] number of elements per line  (value > 0)
 *          [-s] field size  (value > 0)
 *          [-m] number of fractional digits  (value >= 0)
 *          [-j] justification (0 = right, 1 = left)
 *          [-b] bracket type (0 = square, 1 = triangular)
 *          [-d] element delimiter (0 = space, 1 = comma)
 *          [-f] element format(0 - integer, 1 - floating point, 2 - scientific notation
 *		0 (integer ),
 *		1 (floating point ),
 *		or 2 (scientific notation)
 *		   [default = 2] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
   char   style[20], temp[20];
   int errnum;
   struct xvimage *image;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
  if (check_args()) exit(1);

  if((image = readimage(viff2mat->i_file))==NULL){
     (void)fprintf(stderr,"%s:  failed call to readimage()\n",
             program);
     exit(1);
  }
   style[0]='\0';

   /*
    *  Start of building the specified control string for lviff2mat. 
    */

   strcpy(style,"%");

   switch (viff2mat->j_logic) /* Justification. */
      {
      case 0: 
         break;  /* Right justified is default, no additions to style string.*/
      case 1: 
         strcat(style,"-"); /* Left justified, add "-" to control string. */
         break;
      default:   /* Illegal justify specification. */
         (void)fprintf(stderr,"%s:  illegal justification parameter.\n");
         exit(1);
      }

   if((viff2mat->s_int > 0) && (viff2mat->s_int < 1000)) /* Element size.*/
      {
      (void)sprintf(temp,"%d",viff2mat->s_int);
      strcat(style,temp);
      }
   else  /* Size of element too large or too small. */
      {
      (void)fprintf(stderr,"%s, illegal element size. \n",program);
      exit(1);
      }

   strcat(style,".");
      
   if (viff2mat->f_toggle!= 0)  /* If not integer style output, add fract part.*/
      {
      if((viff2mat->m_int>= 0) && (viff2mat->m_int< 1000))
         {
         (void)sprintf(temp,"%d",viff2mat->m_int);
         strcat(style,temp);
         }
      else
         {
         (void)fprintf(stderr,"%s, illegal number of fractional digits. \n",
                  program);
         exit(1);
         }
      }

   switch (viff2mat->f_toggle)
      {
      case 0: /* Integer style output requested. */
         strcat(style,"0f");
         break;
      case 1: /* Floating point style requested. */
         strcat(style,"f");
         break;
      case 2: /* Scientific notation requested. */
         strcat(style,"e");
         break;
      default: /* Illegal specification requested. */
         (void)fprintf(stderr,"%s, illegal output format type requested. \n",
               program);
         exit(1);
      }

   if((viff2mat->e_int <= 0)  && (viff2mat->e_int >= 1000))
      {
      (void)fprintf(stderr,"%s, illegal number of columns specified.\n",
                   program);
      exit(1);
      }

   if((viff2mat->d_logic < 0)  && (viff2mat->d_logic > 1))
      {
      (void)fprintf(stderr,"%s, illegal delimiter specified.\n",program);
      exit(1);
      }

   if((viff2mat->b_logic < 0)  && (viff2mat->b_logic > 1))
      {
      (void)fprintf(stderr,"%s, illegal bracket specified.\n",program);
      exit(1);
      }

/* -main_before_lib_call_end */

/* -main_library_call */
   if(!lviff2mat(viff2mat->o_file,image,style,viff2mat->e_int,
      viff2mat->d_logic,viff2mat->b_logic,&errnum))
      {
      (void)fprintf(stderr,"%s:  failed call to lviff2mat, error %d\n",
            program,errnum);
      exit(1);
      }
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for viff2mat 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "viff2mat :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tviff2mat - outputs a matrix in desired form.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input file (image file)  (infile)\n");
	fprintf(stderr,"\t-o  resulting output file (matrix file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-e]  number of elements per line (integer, > 0) [6]\n");
	fprintf(stderr,"\t[-s]  field size (integer, > 0) [10]\n");
	fprintf(stderr,"\t[-m]  number of fractional digits (integer, >= 0) [6]\n");
	fprintf(stderr,"\t[-j]  justification (0 = right, 1 = left) (boolean) [true]\n");
	fprintf(stderr,"\t[-b]  bracket type (0 = square, 1 = triangular) (boolean) [false]\n");
	fprintf(stderr,"\t[-d]  element delimiter (0 = space, 1 = comma) (boolean) [false]\n");
	fprintf(stderr, "\t[-f]  element format(0 - integer, 1 - floating point, 2 - scientific notation\n");
	fprintf(stderr, "\t\t0  (integer ),\n");
	fprintf(stderr, "\t\t1  (floating point ),\n");
	fprintf(stderr, "\t\tor 2  (scientific notation)\n");
	fprintf(stderr, "\t\t[default = 2]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for viff2mat\n");
	fprintf(stderr, "\t[-U] Gives the usage for viff2mat\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called viff2mat.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses viff2mat.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for viff2mat
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input file (image file) \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output file (matrix file) \n        {outfile}: "; 
char	*e_pstr = 
	"\nEnter: (e) number of elements per line \n        {integer, > 0 [6] }: "; 
char	*s_pstr = 
	"\nEnter: (s) field size \n        {integer, > 0 [10] }: "; 
char	*m_pstr = 
	"\nEnter: (m) number of fractional digits \n        {integer, >= 0 [6] }: "; 
char	*j_pstr = 
	"\nEnter: (j) justification (0 = right, 1 = left) \n        {boolean, (y/n)  [yes] }: "; 
char	*b_pstr = 
	"\nEnter: (b) bracket type (0 = square, 1 = triangular) \n        {boolean, (y/n)  [no] }: "; 
char	*d_pstr = 
	"\nEnter: (d) element delimiter (0 = space, 1 = comma) \n        {boolean, (y/n)  [no] }: "; 
char	*f_pstr = "\nEnter: (f) element format(0 - integer, 1 - floating point, 2 - scientific notation -- \n      \t\t0 (integer )\n\t\t1 (floating point )\n\t\tor 2 (scientific notation)\n  [2]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "viff2mat", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "viff2mat.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "viff2mat: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "viff2mat.ans");
		}

	     }

	}

	/*
	 * allocate the viff2mat structure
	 */
	viff2mat = (viff2mat_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (viff2mat_struct));

	/*
	 * get required arguments for viff2mat
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(viff2mat->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(viff2mat->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(viff2mat->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    viff2mat->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(viff2mat->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(viff2mat->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(viff2mat->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(viff2mat->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    viff2mat->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(viff2mat->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for viff2mat
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	viff2mat->e_flag = vget_int(fid, prompt_flag,
	"-e", e_pstr, &(viff2mat->e_int),
	6, 2, 2);

	viff2mat->s_flag = vget_int(fid, prompt_flag,
	"-s", s_pstr, &(viff2mat->s_int),
	10, 2, 2);

	viff2mat->m_flag = vget_int(fid, prompt_flag,
	"-m", m_pstr, &(viff2mat->m_int),
	6, 1, 1);

	viff2mat->j_flag = vget_logic(fid, prompt_flag,
	"-j", j_pstr, &(viff2mat->j_logic), 1);

	viff2mat->b_flag = vget_logic(fid, prompt_flag,
	"-b", b_pstr, &(viff2mat->b_logic), 0);

	viff2mat->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(viff2mat->d_logic), 0);


	/*
	 * get optional toggles for viff2mat
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		viff2mat->f_flag = vget_int(fid, prompt_flag,
		"-f", f_pstr, &(viff2mat->f_toggle),
		2, 0, 0);

		if ((viff2mat->f_toggle == 0 ) || 
		    (viff2mat->f_toggle == 1 ) || 
		    (viff2mat->f_toggle == 2 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		viff2mat->f_flag = vget_int(fid, prompt_flag,
		"-f", f_pstr, &(viff2mat->f_toggle),
		2, 0, 0);

		if ((viff2mat->f_toggle != 0 ) && 
		    (viff2mat->f_toggle != 1 ) && 
		    (viff2mat->f_toggle != 2 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



