 /*
  * Khoros: $Id: lmlud.c,v 1.4 1992/03/20 23:47:03 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lmlud.c,v 1.4 1992/03/20 23:47:03 dkhoros Exp $";
#endif

 /*
  * $Log: lmlud.c,v $
 * Revision 1.4  1992/03/20  23:47:03  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lmlud.c
 >>>>
 >>>>      Program Name: mlud
 >>>>
 >>>> Date Last Updated: Tue Feb 25 00:57:47 1992 
 >>>>
 >>>>          Routines: lmlud - the library call for mlud
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
#define CLEANUP \
    {  /* cleanup workspace before leaving */ \
       if(amatrix!=NULL)free((char *)amatrix); \
       if(zvector!=NULL)free((char *)zvector); \
       if(ipvt!=NULL)free((char *)ipvt); \
       if(bmatrix!=NULL)free((char *)ipvt); \
    } /* end of cleanup code */

typedef struct complex {
  double re,im;
} complex;
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lmlud - library call for mlud
*
* Purpose:
*    
*    compute the LU decomposition of a matrix
*    
*    

* Input:
*    
*    image          real or complex matrix.
*    
*    

* Output:
*    
*    image          real or complex matrix containing the  lower  tri-
*                   angular  of  the  LU  decomposition  of  the input
*                   matrix.
*    
*    uimage         real or complex matrix containing the  upper  tri-
*                   angular  of  the  LU  decomposition  of  the input
*                   matrix.
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    

*
* Written By: Jeremy Worley
*    
*    Jeremy Worley Tue Feb 25 00:56:55 MST 1992
*              arguments rows  and  cols  to  llud()  were  explicitly
*              declared  and  functions  called in lmlud() were expli-
*              citly declared.
*    
*    

****************************************************************/


/* -library_def */
int lmlud(image,uimage)
  struct xvimage *image, *uimage;
/* -library_def_end */

/* -library_code */
{
  int i,uidx,rows,cols,bands,type;
  double *kern,*matrix,*umatrix;
  char *program = "lmlud";
  int proper_num_images(),lvcast(),llud();

  bands = (int)image->num_data_bands;
  rows = (int)image->col_size;
  cols = (int)image->row_size;

  if(!proper_num_images(program,image,1,FALSE)){
     fprintf(stderr,"%s:  image structure should contain only one image.\n",
         program);
     return(0);
  }

/*
** cast all of the data up to double or double complex
*/

   if(image->data_storage_type==VFF_TYP_COMPLEX || image->data_storage_type==
        VFF_TYP_DCOMPLEX){
      if(!lvcast(&image,(int)1,(int)VFF_TYP_DCOMPLEX)){
         fprintf(stderr,"%s:  Failure to cast up to double complex.\n",program);
         return(0);
      }
      type = 1;
   }else{
      if(!lvcast(&image,(int)1,(int)VFF_TYP_DOUBLE)){
         fprintf(stderr,"%s:  Failure to cast up to double.\n",program);
         return(0);
      }
      type = 0;
   }

  if((matrix = (double *)malloc(bands*rows*cols*(type+1)*sizeof(double)))
       ==NULL){
     (void)fprintf(stderr,"%s:  unable to allocate s matrix.\n",program);
     return(0);
  }

  if((umatrix = (double *)malloc(bands*rows*cols*(type+1)*sizeof(double)))
       ==NULL){
     (void)fprintf(stderr,"%s:  unable to allocate u matrix.\n",program);
     return(0);
  }

/*
** process all of the data
*/

   kern = (double *)(image->imagedata);
   for(i=0;i<bands;i++){
      uidx = (type+1)*rows*cols*i;
      if(!llud(&(matrix[uidx]),&(umatrix[uidx]),kern,rows,cols,type)){
         fprintf(stderr,"%s:  Failed call to static routine.\n",program);
         return(0);
      }

      kern += (type+1)*rows*cols;
   }

/*
** free up our junk and get the heck outa here.
*/

   uimage->data_storage_type = image->data_storage_type;
   uimage->row_size = cols;
   uimage->col_size = rows;
   uimage->num_data_bands = bands;

   image->imagedata = (char *)matrix;
   uimage->imagedata = (char *)umatrix;

   return(1);
}

/***********************************************************************
*
*  Routine Name: 
*
*          Date:
*        
*       Purpose:  
*
*         Input: 
*
*        Output: 
*
*    Written By:  
*
* Modifications:
*
***********************************************************************/

int llud(lmatrix,umatrix,matrix,rows,cols,type)
  double *lmatrix, *umatrix, *matrix;
  int type,rows,cols;
{
  int   index1,index2,k,j;
  void zgedi_(), zgeco_();
  void  swap();

  complex *amatrix,*zvector=NULL;
  int *ipvt=NULL;
  double rcond,*bmatrix=NULL;
  int linvert(),lmult();

  char *program = "lmlud";

/*
** test some junk
*/

  if(rows!=cols){
     fprintf(stderr,"%s:  matrix must be square.\n",program);
     return(0);
  }

  if(rows<=0 || cols<=0){
     fprintf(stderr,"%s:  matrix dimensions must be nonzero.\n",program);
     return(0);
  }

  if(matrix==NULL || lmatrix==NULL || umatrix==NULL){
     fprintf(stderr,"%s:  null matrix not allowed.\n",program);
     return(0);
  }

/*
** allocate memory for junk
*/

  amatrix = (complex *)malloc((unsigned)rows * cols * sizeof(complex));
  if(amatrix==NULL){
     fprintf(stderr,"%s:  [1]memory allocation failure.\n",program);
     CLEANUP;
     return(0);
  }

  zvector = (complex *)malloc((unsigned)cols * sizeof(complex));
  if(zvector==NULL){
     fprintf(stderr,"%s:  [2]memory allocation failure.\n",program);
     CLEANUP;
     return(0);
  }

  ipvt = (int *)malloc((unsigned)cols * sizeof(int));
  if(ipvt==NULL){
     fprintf(stderr,"%s:  [3]memory allocation failure.\n",program);
     CLEANUP;
     return(0);
  }

  bmatrix = (double *)malloc((unsigned)rows*cols*(type+1)*sizeof(double));
  if(bmatrix==NULL){
     fprintf(stderr,"%s:  [4]memory allocation failure.\n",program);
     CLEANUP;
     return(0);
  }

/*
** transpose data 'cause were working with that brain-dead excuse for
** a language FORTRAN... 
*/

  if(type == 0){
     for(j=0;j<rows;j++){
         for(k=0;k<cols;k++){
            amatrix[j*cols+k].re = matrix[j+k*cols];
            amatrix[j*cols+k].im = 0.0;
         }
     }
  }else{
     for(j=0;j<rows;j++){
         for(k=0;k<cols;k++){
            index1 = j*cols + k;
            index2 = j + k*cols ;
            amatrix[index1].re = matrix[2*index2];
            amatrix[index1].im = matrix[2*index2 + 1];
         }
     }
  }

/*
** zgeco factors a complex*16 matrix by gaussian elimination
** and estimates the condition of the matrix.
*/

  (void)zgeco_(amatrix,&rows,&cols,ipvt,&rcond,zvector);

/*
** grab the upper part of the matrix...
*/

  if(type == 0){
     for(j=0;j<cols;j++){
         for(k=0;k<rows;k++){
            if(k<=j){
              umatrix[j+k*rows] = amatrix[j*cols+k].re;
            }else{
              umatrix[j+k*rows] = 0.0;
            }
         }
     }
  }else{
     for(j=0;j<cols;j++){
         for(k=0;k<rows;k++){
            index1 = j*cols + k;
            index2 = j + k*rows ;
            if(k<=j){
               umatrix[2*index2] = amatrix[index1].re;
               umatrix[2*index2 + 1] = amatrix[index1].im;
            }else{
               umatrix[2*index2] = umatrix[2*index2+1] = 0.0;
            }
         }
     }
  }

/*
** call a couple of our own functions to get inverse of umatrix and
** then multiply it with amatrix for our lmatrix
*/

  if(!linvert(bmatrix,umatrix,rows,cols,type)){
     fprintf(stderr,"%s:  failed call to lminvert.\n",program);
     return(0);
  }

  if(!lmult(lmatrix,matrix,rows,cols,type,bmatrix,rows,cols,type)){
     fprintf(stderr,"%s:  failed call to lmmult.\n",program);
     return(0);
  }

  return(1);
}
/* -library_code_end */
