 /*
  * Khoros: $Id: lvmapdlg.c,v 1.1 1991/05/10 15:43:20 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvmapdlg.c,v 1.1 1991/05/10 15:43:20 khoros Exp $";
#endif

 /*
  * $Log: lvmapdlg.c,v $
 * Revision 1.1  1991/05/10  15:43:20  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvmapdlg.c
 >>>>
 >>>>      Program Name: vmapdlg
 >>>>
 >>>> Date Last Updated: Sun Mar  3 16:16:08 1991 
 >>>>
 >>>>          Routines: lvmapdlg - the library call for vmapdlg
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
struct {
    int majr;
    int R;
    int G;
    int B;
}
map_table[] =
{
       /*
        * This table contains the color values for any dlg feature that
        * has a major attribute within a range.  For instance, and major
        * attribute between 50 and 59 will be considered hydrography and
        * colored blue (0, 0, 255).  These colors may be found in the file
        * /usr/lib/X11/rgb.txt.  Because of redefinition of some of the
        * categories, some appear twice.  Roads and trails have been
        * redefined.  The old major attribute was 100, and the new major
        * attribute is 170.  Both have been included in the table so both
        * old and new data can be used.
        */
       /* hypsography */
        20,           165,     42,     42,      /* brown */

       /* streams */
        30,             0,      0,    238,      /* blue 2 */

       /* water bodies */
        40,             0,      0,    205,      /* blue 3 */

       /* hydrography */
        50,             0,      0,    255,      /* blue 1 */

       /* coastal features */
        60,             0,      0,    139,      /* blue 4 */

       /* surface cover */
        70,             0,    255,      0,      /* green */

       /* non-vegatative surface features */
        80,             0,    255,    255,      /* cyan */

       /* boundaries */
        90,           192,    192,    192,      /* grey */

       /* roads and trails */
       100,           255,      0,      0,      /* red */

       /* railroads */
       110,           255,    165,     79,      /* tan */

       /* water navigation */
       120,           224,    238,    238,      /* azure 1 */

       /* pipelines and transmission lines */
       130,           255,    255,      0,      /* yellow */

       /* other significant manmade structures */
       140,           255,      0,    255,      /* magenta */

       /* survey control and markers */
       150,           255,    165,      0,      /* orange */

       /* roads and trails */
       170,           255,      0,      0,      /* red */

       /* railroads */
       180,           255,    165,     79,      /* tan */

       /* pipelines and transmission lines */
       190,           255,    255,      0,      /* yellow */

       /* other significant manmade structures */
       200,           255,      0,    255,      /* magenta */

       /* US public land survey system */
       300,           255,    192,    203,      /* pink */

       /* end of table marker */
        -1,             0,      0,      0
};

#define CHECKLIBINPUT(program, img) {                                         \
        if (!proper_map_scheme (program, img, VFF_MS_ONEPERBAND, FALSE)) {    \
            fprintf (stderr, "error in lvmapdlg: input image must be ");      \
            fprintf (stderr, "VFF_MS_ONEPERBAND\n");                          \
            return (0);                                                       \
        }                                                                     \
        if (!proper_map_size (program, img, 1, 2, FALSE)) {                   \
            fprintf (stderr, "error in lvmapdlg: input image must have ");    \
            fprintf (stderr, "maps with 1 row and 2 columns\n");             \
            return (0);                                                       \
        }                                                                     \
        if (!proper_map_type (program, img, VFF_MAPTYP_2_BYTE, FALSE)) {      \
            fprintf (stderr, "error in lvmapdlg: input image must be ");      \
            fprintf (stderr, "VFF_MAPTYP_2_BYTE\n");                          \
            return (0);                                                       \
        }                                                                     \
        if (!proper_num_images (program, img, 1, FALSE)) {                    \
            fprintf (stderr, "error in lvmapdlg: input image must contain "); \
            fprintf (stderr, "only 1 image\n");                               \
            return (0);                                                       \
        }                                                                     \
}
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvmapdlg - library call for vmapdlg
*
* Purpose:
*    
*    Change the map  of  an  image  imported  from  DLG  data  to
*    displayable colors.
*    
*    
* Input:
*    
*         1. img -- double pointer to the input xvimage structure.
*    
*         The input image and location data will be copied to the out-
*         put  image,  but the header and the maps will be lost, so be
*         careful not to overwrite important data.
*    
*    
* Output:
*    
*         1. img -- double pointer to  the  input  xvimage  structure,
*         which now points to the output structure.
*    
*         This function returns 1 on success and 0 on failure.
*    
*    
*
* Written By: Per Lysne
****************************************************************/


/* -library_def */
int
lvmapdlg (img)
struct xvimage **img;
/* -library_def_end */

/* -library_code */
{
    int i, band, attributes_found;
    short majr, minr, *oldmap;
    char *program="lvmapdlg";
    unsigned char *newmap;

    struct xvimage *newimg;

    if (img==NULL) {
        fprintf (stderr, "error in lvmapdlg: bad input image\n");
        return (0);
    }

    CHECKLIBINPUT (program, *img);

    /*
     * Create a new image that will hold the data after it has been
     * converted to RGB.  The image parameters are all the same 
     * except that the map is changed from the dlg attributes map
     * to an RGB map.  The dimensions of the image and its location
     * vector are 0 because I am going to use the image and location
     * data from the old image so I don't want to malloc any new space.
     */
    newimg = createimage (0, 0, VFF_TYP_BIT, 1,
                         (*img)->num_data_bands, (*img)->comment, 3, 2,
                         VFF_MS_ONEPERBAND, VFF_MAPTYP_1_BYTE,
                         (*img)->location_type, 0);
    if (newimg==NULL) {
        fprintf (stderr, "error in lvmapdlg: createimage failed\n");
        return (0);
    }

    /*
     * Transfer the pointers to the image and location data from
     * the old image to the new image with the RGB map and free the
     * old image.
     */
    newimg->location_dim = (*img)->location_dim;
    newimg->location = (*img)->location;
    newimg->row_size  = (*img)->row_size;
    newimg->col_size  = (*img)->col_size;
    newimg->imagedata = (*img)->imagedata;
                            
    newimg->color_space_model = VFF_CM_genericRGB;
    newimg->map_enable = VFF_MAP_OPTIONAL; 

    for (band=0; band<newimg->num_data_bands; band++) {

        /*
         * oldmap points to the map for this band in the old image, the
         * map size is 2 shorts.
         */
        oldmap = (short *) (*img)->maps;
        oldmap = oldmap + band*2;

        /*
         * newmap points to the map for this band in the new image, the
         * map size is 6 bytes.
         */
        newmap = (unsigned char *) newimg->maps;
        newmap = newmap + band*6;

        /*
         * Initialize all of the locations in the new map to 0.  The
         * first line will be left a 0s to indicate that for this
         * map index, the rgb color should be black.
         */
        for (i=0; i<6; i++) *(newmap+i)=0;

        /* Major and minor attributes from the second line of the old map. */
        majr = *(oldmap); minr = *(oldmap+1);

        /*
         * Search through the table looking for the major
         * attribute found in the map from the old band.  Once it
         * is found, set the new map entries to the corresponding
         * rgb values.
         */
        i=0;
        attributes_found=FALSE;
        while (map_table[i].majr!= -1) {
            if ((map_table[i].majr<=majr) && (majr<map_table[i].majr+10)) {
                attributes_found=TRUE;
                *(newmap+1) = map_table[i].R;
                *(newmap+3) = map_table[i].G;
                *(newmap+5) = map_table[i].B;
            }
            i++;
        }

        /* Assign white as the default if no color was found in the table. */
        if (!attributes_found) {
            printf ("warning: could not assign a color to the following ");
            printf ("attribute pair:\n");
            printf ("    majr=%d\n", majr);
            printf ("    minr=%d\n\n", minr);
            printf ("default color will be white\n");
            *(newmap+1) = (char) 255;
            *(newmap+3) = (char) 255;
            *(newmap+5) = (char) 255;
        }
    }

    free ((*img)->maps);
    free (*img);
    *img=newimg;

    return (1);
}
/* -library_code_end */
