#! /bin/csh -f

# 
#  Khoros: $Id: kmakeall.csh,v 1.6 1992/03/25 17:29:35 dkhoros Exp $
#

#
# $Log: kmakeall.csh,v $
# Revision 1.6  1992/03/25  17:29:35  dkhoros
# VirtualPatch5
#
# Revision 1.3  1991/12/18  08:54:55  dkhoros
# HellPatch3
#
# 

#
# FILE NAME:	kmakeall.csh
# 
# AUTHORS:	Charlie Gage, Tom Sauer
# 
# DATE:		3/7/91
# 
# DESCRIPTION:	Script used to make source on all machines.
# 
# MODIFICATIONS:  This code was modified from vmakeall written by Ron Neher
#	          Added code to accept mach file input. 3/7/91  c.gage
# 
# ROUTINES:	kmakeall_csh.csh
#		

onintr cleanup

set path = ( . $KHOROS_HOME/bin $path /usr/local/bin /usr/ucb \
             /usr/bin /bin /usr/local/etc/ /usr/etc /etc )

# Set up environment variables
#----------------------------------------------------------
if ( ! $?KHOROS_HOME ) then
   echo ""
   echo "kmakeall: Error, must have the KHOROS_HOME "
   echo "          environment variable set to proceed."
   echo ""
   exit 1
endif

if (! $?KHOROS_MAIL ) then
   echo ""
   echo "vinstall: Error KHOROS_MAIL environment variable is not set"
   echo ""
   exit 1
endif

set MAKE = make

set args = ""

umask 002

set m_flg1  = 0
set m_flg2  = 0
set f_flg1 = 0
set f_flg2 = 0
set r_flg1 = 0
set r_flg2 = 0
set other_flg = 0
set TOOLBOX

while ($#argv)
    switch ($argv[1])
	case -U:
	    goto usage
	    breaksw
	case -V:
	    goto version
	    breaksw
        case -toolbox:             # set mach file argument
	    if ($m_flg1 || $m_flg2) goto usage
            set m_flg1 = 1
	    breaksw
	case -f:                # set fullpath flag
            if ($f_flg1 || $r_flg1 || $f_flg2 || $r_flg2) goto usage
            set f_flg1 = 1
	    breaksw
	case -r:                # set relpath flag
            if ($f_flg1 || $r_flg1 || $f_flg2 || $r_flg2) goto usage
            set r_flg1 = 1
	    breaksw
	default:
            if ($f_flg1) then             # get fullpath dir
                set f_flg1 = 0
                set f_flg2 = 1
                set FULLPATH = $argv[1]
            else if ($r_flg1) then        # get relpath dir
                set r_flg1 = 0
                set r_flg2 = 1
                set RELPATH = $argv[1]
            else if ($m_flg1) then        # get the mach file
                set m_flg1 = 0
                set m_flg2 = 1
               set TOOLBOX = $argv[1]
	    else                          # get make args
		set args = "$args $argv[1]"
	    endif
	    breaksw
    endsw
    shift
end

# check to see if -f or -r is still set
#-----------------------------------------------------
    if ($f_flg1 || $r_flg1 || $m_flg1) goto usage
    if ($f_flg2 && $r_flg2) goto usage

# set the FULLPATH variable if not defined
#-----------------------------------------------------
if ( ! $f_flg2 && ! $r_flg2 ) then
   set FULLPATH = `pwd`
else if (! $f_flg2 && $r_flg2) then
       set FULLPATH = $RELPATH
else
       set RELPATH = ""
endif

# source the default mach file if one was not specified
#-----------------------------------------------------

if ($m_flg2 ) then
  if ($?KHOROS_TOOLBOX) then
      set MACHPATH = `grep -i ^$TOOLBOX':' $KHOROS_TOOLBOX | awk -F: '{ printf "%s", $2 }' `
      set MACHFILE = `echo $TOOLBOX | tr A-Z a-z`
      set MACH = $MACHPATH/repos/config/src_conf/{$MACHFILE}_mf
      set MACH = `eval echo $MACH`

      set define_list = ( `cat $KHOROS_TOOLBOX | awk -F: '{ printf "%s ", $1 }' ` )

      foreach name ( $define_list)
         set $name = `grep -i $name $KHOROS_TOOLBOX | awk -F: '{ printf "%s", $2 }' `
      end
  else
    echo ""
    echo "kmakeall:   Error, A toolbox was specified, but the environment"
    echo "            KHOROS_TOOLBOX has not been set. Please use 'setenv'"
    echo "            to set the KHOROS_TOOLBOX environment variable"
    echo ""
    exit 1
  endif
endif

set FULLHOST = `hostname`
if (! $m_flg2 ) then
    if (-f $KHOROS_HOME/repos/config/src_conf/default_mach.{$FULLHOST}) then
	 set MACH = $KHOROS_HOME/repos/config/src_conf/default_mach.{$FULLHOST}
    else if (-e $KHOROS_HOME/repos/config/src_conf/default_mach) then
	 set MACH = $KHOROS_HOME/repos/config/src_conf/default_mach
    else
        echo ""
        echo "kmakeall: The mach_def file does not exist"
        echo " Please either specify a mach_def file or create one"
        echo " in $KHOROS_HOME/repos/config/src_conf/default_mach"
        echo " For more information please Khoros Manual Vol 1, Ch. 9"
        echo ""
        goto cleanup
    endif
else if (-f $MACH.{$FULLHOST}) then
           set MACH = $MACH.{$FULLHOST}
    else if (! -f $MACH) then
           echo ""
           echo "kmakeall: Error, the mach file '$MACH' for the toolbox"
           echo "specified was not found. Please create a mach file" 
	   echo "in $MACH"
           echo ""
           exit 1
    endif
endif

source $MACH
echo "using '$MACH' file"


# Get info from mach file
#-----------------------------------------------------
set USER = $KHOROS_USER
set NUM_MACHINES = $#KHOROS_MACHINES
set NUM_DIR = $#KHOROS_MACH_DIR
set NUM_SRC = $#KHOROS_SRC_TOP

if ($USER == "") then
   echo ""
   echo "kmakeall: KHOROS_USER environment variable not set."
   echo " Please check your mach file for this variable."
   echo ""
   goto cleanup
endif

if ($NUM_MACHINES != $NUM_DIR && $NUM_MACHINES != $NUM_SRC || $NUM_DIR < 1) then
       echo " "
       echo "kmakeall: Error, incorrect number of entries in default_mach file"
       echo " Please check that the number of entries in each field"
       echo " is the same (ie. number of entires must correspond)."
       echo " "
       goto cleanup
endif

if (! -d $LOCAL_SRC_TOP)  then
      echo ""
      echo "kmakeall: Error, The LOCAL_SRC_TOP field is not set"
      echo "Please set this field in the mach_def file"
      goto cleanup
endif


# Check to see if .rhosts file exists, if not then
# copy over the .rhosts.bk to .rhosts for the rsh to work
#-----------------------------------------------------
if ( ! -e ~{$KHOROS_USER}/.rhosts && $NUM_MACHINES > 0) then
  if ( ! -e ~{$KHOROS_USER}/.rhosts.bk) then
     echo "Please set up a .rhost file in ~{$KHOROS_USER}"
     goto cleanup
  else
   echo ""
   echo "Copying ~$KHOROS_USER/.rhosts.bk to ~$KHOROS_USER/.rhosts"
   echo ""
   \cp ~$KHOROS_USER/.rhosts.bk ~$KHOROS_USER/.rhosts
 endif
endif


# for each machine, attempt to make source
#-----------------------------------------------------

     set HOMEDIR = $LOCAL_SRC_TOP
     if ( ($FULLPATH != $HOMEDIR) && (! $r_flg2) ) then
         set RELPATH = `echo $FULLPATH | sed -e "s|$HOMEDIR/||"`
     else if ( ! $r_flg2 ) then
        set RELPATH
     else if ( $r_flg2 && $HOMEDIR == $FULLPATH) then
         set RELPATH
     endif

     if (! -d $HOMEDIR/$RELPATH) then
	 echo ""
         echo "The source directory, $HOMEDIR/$RELPATH is invalid."
	 echo ""
         goto cleanup
     endif


  @ i = 1
  foreach machine ($KHOROS_MACHINES)
      if ($RELPATH == "") then
        set DESTDIR = $KHOROS_MACH_DIR[$i]
      else
        set DESTDIR = $KHOROS_MACH_DIR[$i]/$RELPATH
      endif

      set HOMEDIR = $KHOROS_SRC_TOP[$i]
      echo ""
      echo "Attempting to rsh to $machine."
      echo "$machine will send e-mail to you upon completion of make."
      echo ""
      rsh $machine -l $USER \
         "umask 002; \
         touch /tmp/make.$$; \
         echo "make $args" >>& /tmp/make.$$; \
         echo "on $machine in: $DESTDIR" >>& /tmp/make.$$; \
         cd $DESTDIR >>& /tmp/make.$$; \
         $MAKE $args >>& /tmp/make.$$; 	\
         mail -s '"$MAKE in dir: $DESTDIR"' $KHOROS_MAIL < /tmp/make.$$ ; \
         \rm -f /tmp/make.$$" &		#CMMD#
      @ i++
  end

# removing  .rhosts file
# - -----------------------------------------------------
sleep 15
goto cleanup

# -------------------------------------------------------
usage:
    echo ""
    echo "kmakeall:  makes and installs routines for Khoros"
    echo ""
    echo ""
    echo "usage:"
    echo "  kmakeall [-V] [-U] [-mach] [-f full_path | -r relative_path]"
    echo "                 [make options]"
    echo ""
    echo "where: " 
    echo "        [-toolbox]  the Toolbox name"
    echo "        [-f]        is the full path"
    echo "        [-r]        is relative path to top level src directory"
    echo "        [-V]       gives the version for kmakeall"
    echo "        [-U]        gives the usage for kmakeall"
    echo ""
    echo "If NO path is specified, then the current directory is used."
    echo ""
    echo ""
    exit 0

version:
    source $KHOROS_HOME/repos/config/scripts/script_version
    set VERSION = $KHOROS_VERSION
    set RELEASE = $KHOROS_RELEASE
    echo ""
    echo "kmakeall:  Khoros Release: Version $VERSION.$RELEASE"
    echo ""
    unset KHOROS_VERSION
    unset KHOROS_RELEASE
    exit 0

cleanup:
if ( -e ~$KHOROS_USER/.rhosts) then
   \mv ~$KHOROS_USER/.rhosts ~$KHOROS_USER/.rhosts.bk
endif

# Clean up variables
#--------------------------------------------------
unset KHOROS_USER
unset KHOROS_MACHINES
unset KHOROS_MACH_DIR
unset KHOROS_SRC_TOP
unset LOCAL_SRC_TOP

exit 0  # normal exit

