 /*
  * Khoros: $Id: project.c,v 1.2 1991/10/01 23:57:04 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: project.c,v 1.2 1991/10/01 23:57:04 khoros Exp $";
#endif

 /*
  * $Log: project.c,v $
 * Revision 1.2  1991/10/01  23:57:04  khoros
 * HellPatch2
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.  
*---------------------------------------------------------------------- */

#include "unmcopyright.h"	 /* Copyright 1991 by UNM */
/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>     file name: project.c                              <<<<
   >>>>                                                       <<<<
   >>>>   description: These routines are used to manage      <<<<
   >>>>		       the project template files             <<<< 
   >>>>                                                       <<<<
   >>>>      routines: add_project()                          <<<<
   >>>>                                                       <<<<
   >>>>        author: Tom Sauer Wed Aug 28 08:38:44 MDT 1991 <<<<
   >>>>                                                       <<<<
   >>>> modifications:                                        <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "imkmf.h"

/***********************************************************************
*
*  Routine Name: add_project()
*
*          Date: Aug 28, 1991
*        
*       Purpose:  Add the #include file to the Imakefile for
* 		  toolboxes.
*
*         Input: project - name of the toolbox
*		 outfile - output device
*
*        Output: writes #include into Imakefile
*
*    Written By: Tom Sauer 
*
* Modifications:
*
***********************************************************************/
add_project(project, outfile)

char *project;
FILE *outfile;
{

	char c, *cptr, *toolbox, *toolbox_file, *status;
	char *vtoolbox_path();
	
	if (strcmp(project, "Toolbox"))
	{
	   if (project[0] == '$')
	     project++;

	   toolbox = vupper_string(project, NULL);
	   status = vtoolbox_path(toolbox);
	   if (status == NULL)
	   {
	       fprintf(stderr, "imkmf: The toolbox name '%s' is not a valid toolbox.\n", project);
	       fprintf(stderr, "       Please check the name of the toolbox and rerun imkmf\n");
	      free(toolbox);
	      myexit(1);
	   }
	
           toolbox = vlower_string(toolbox, toolbox);
	
	   fprintf(outfile, "#include <%s.def>\n\n", toolbox);
	   free(status);
	   free(toolbox);
	}
	else
	{
	   fprintf(outfile, "#include <%s.def>\n\n", project);
	}
}

