 /*
  * Khoros: $Id: lvblend.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvblend.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvblend.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvblend.c
 >>>>
 >>>>      Program Name: vblend
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:50:32 1991 
 >>>>
 >>>>          Routines: lvblend - the library call for vblend
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvblend - library call for vblend
*
* Purpose:
*    
*    Blend two images using  X*image1 + (1-X)*image2  where X  is
*    the blend ratio.
*    
*    
* Input:
*    
*         img1 - pointer to the first input image structure
*         img2 - pointer to the second input image structure
*         img3 - optional pointer to the blend image structure
*         x    - optional blend ratio
*         mflg - if 1 specifies the use of  a  blending  image,  if  0
*         specifies
*                the use of a blend ratio
*    
*         either x or mflg must be specified, and  if  mflg  is  true,
*         then  img3  must  be  a  valid  image  pointer. img3 must be
*         VFF_TYP_FLOAT and must have the  same  number  of  rows  and
*         columns as img1 and img2.
*    
*         If both a blend mask image and a blend ratio are  specified,
*         then  the  blend  mask  image  is dominant, and the ratio is
*         ignored.
*    
*    
* Output:
*    
*         img1 - blended image attached to img1 pointer
*    
*    
*
* Written By: Scott Wilson
*    
*    28-Dec-89 Added blend image support. Scott Wilson
*    
*    
****************************************************************/


/* -library_def */
int
lvblend(img1,img2,img3,x,mflg)
struct xvimage *img1, *img2,*img3;
float x;
int mflg;
/* -library_def_end */

/* -library_code */
{
    int    j, k;
    int    *i1,*i2,*i3;
    short  *s1,*s2,*s3;
    float  *f1,*f2,*f3;
    float  *m;
    unsigned char *c1,*c2,*c3;
    float y;

    if (mflg) m = (float *)(img3->imagedata);
    else y = 1.0-x;

    switch (img1->data_storage_type)
      {
        case VFF_TYP_BIT :
          fprintf(stderr,"lvblend: Don't know how to blend BIT images\n");
          return(0);
          break;
        case VFF_TYP_1_BYTE : 
          k = img1->row_size*img1->col_size;
          c1 = (unsigned char *)(img1->imagedata);
          c2 = (unsigned char *)(img2->imagedata);
          c3 = (unsigned char *)(img1->imagedata);
          if (!mflg) for (j=0; j<k; j++) *c3++ = x*(*c1++) + y*(*c2++);
          else
            {
              for (j=0; j<k; j++) 
                {
                  *c3++ = (*m)*(*c1++)+(1-(*m))*(*c2++);
                  m++;
                }
            }
          break;
        case VFF_TYP_2_BYTE :
          k = img1->row_size*img1->col_size;
          s1 = (short *)(img1->imagedata);
          s2 = (short *)(img2->imagedata);
          s3 = (short *)(img1->imagedata);
          if (!mflg) for (j=0; j<k; j++) *s3++ = x*(*s1++) + y*(*s2++);
          else
            {
              for (j=0; j<k; j++) 
                {
                  *s3++ = (*m)*(*s1++)+(1-(*m))*(*s2++);
                  m++;
                }
            }
          break;
        case VFF_TYP_4_BYTE :
          k = img1->row_size*img1->col_size;
          i1 = (int *)(img1->imagedata);
          i2 = (int *)(img2->imagedata);
          i3 = (int *)(img1->imagedata);
          if (!mflg) for (j=0; j<k; j++) *i3++ = x*(*i1++) + y*(*i2++);
          else
            {
              for (j=0; j<k; j++) 
                {
                  *i3++ = (*m)*(*i1++)+(1-(*m))*(*i2++);
                  m++;
                }
            }
          break;
        case VFF_TYP_FLOAT :
          k = img1->row_size*img1->col_size;
          f1 = (float *)(img1->imagedata);
          f2 = (float *)(img2->imagedata);
          f3 = (float *)(img1->imagedata);
          if (!mflg) for (j=0; j<k; j++) *f3++ = x*(*f1++) + y*(*f2++);
          else
            {
              for (j=0; j<k; j++) 
                {
                  *f3++ = (*m)*(*f1++)+(1-(*m))*(*f2++);
                  m++;
                }
            }
          break;
        case VFF_TYP_COMPLEX :
          k = img1->row_size*img1->col_size;

          f1 = (float *)(img1->imagedata);
          f2 = (float *)(img2->imagedata);
          f3 = (float *)(img1->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  *f3 = x*(*f1) + y*(*f2);
                  *(f3+1) = x*(*(f1+1)) + y*(*(f2+1));
                  f1 += 2; f2 += 2; f3 += 2;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  *f3 = (*m)*(*f1) + (1-(*m))*(*f2);
                  *(f3+1) = (*m)*(*(f1+1)) + (1-(*m))*(*(f2+1));
                  f1 += 2; f2 += 2; f3 += 2; m++;
                }
            }
          break;
        default:
          fprintf(stderr,"lvblend: Unknown data storage type, %d\n",img1->data_storage_type);
          return(0);
          break;
      }
      return(1);
}
/* -library_code_end */
