 /*
  * Khoros: $Id: lvblse.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvblse.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvblse.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvblse.c
 >>>>
 >>>>      Program Name: vblse
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:45:39 1991 
 >>>>
 >>>>          Routines: lvblse - the library call for vblse
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
#define VCALL(func) if (!func) { fprintf(stderr,"%s failed\n","func"); return(0); }
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvblse - library call for vblse
*
* Purpose:
*    
*    Perform   band-limited   surface   extrapolation   (adaptive
*    apodization)
*    
*    
* Input:
*    
*    image          Pointer to input image.
*    
*    mask           Pointer to valid data mask  image  the  the  above
*                   input image.
*    
*    psf            Pointer to pointspread function image.
*    
*    count          Iteration count (int)
*    
*    
* Output:
*    
*    image          pointer to which the resultant image is  attached.
*                   The original image is overwritten and the original
*                   data area is freed.
*    
*    
*
* Written By: Scott Wilson
*    
*    12-Feb-90 Scott Wilson - Patched around the disappearance of  the
*    original FFT calls.
*    
*    
****************************************************************/


/* -library_def */
int
lvblse(image,mask,psf,count)
struct xvimage *image,*mask,*psf;
int count;
/* -library_def_end */

/* -library_code */
  {
    int rows,cols,i;
    float ratio;
    struct xvimage *psf_fft,*accum,*filt_fft,*tmp;

    cols = image->row_size;
    rows = image->col_size;

    if (image->data_storage_type != VFF_TYP_FLOAT &&
        image->num_data_bands != 1 &&
        image->map_scheme != VFF_MS_NONE)
      {
        fprintf(stderr,"lvblse: Invalid input image\n");
        return(0);
      }
    if (mask->data_storage_type != VFF_TYP_FLOAT &&
        mask->num_data_bands != 1 &&
        mask->map_scheme != VFF_MS_NONE)
      {
        fprintf(stderr,"lvblse: Invalid input mask\n");
        return(0);
      }
    if (mask->col_size != rows || mask->row_size != cols ||
        psf->col_size  != rows || psf->row_size  != cols)
      {
        fprintf(stderr,"lvblse: Input images are of different sizes!\n");
        return(0);
      }

    psf_fft = copyimage(psf);
    VCALL(lvfft(psf,NULL,1,&psf_fft,0,NULL,0,NULL,0));
    accum = copyimage(image);

    for (i=0; i<count; i++)
      {
        ratio = (float)(count-i)/(float)count;
        VCALL(lvfft(accum,NULL,1,&tmp,0,NULL,0,NULL,0));
        freeimage(accum);
        accum = tmp;
        VCALL(lvgconst(&filt_fft,rows,cols,VFF_TYP_COMPLEX,1.0,0.0,1));
        VCALL(lvblend(filt_fft,psf_fft,NULL,ratio,0));
        VCALL(lvmul(accum,filt_fft,NULL,0,1));
        freeimage(filt_fft);
        VCALL(lvfft(accum,NULL,0,NULL,1,&tmp,0,NULL,1));
        freeimage(accum);
        accum = tmp;
        VCALL(lvreplace(accum,image,mask));
      }

    freeimage(psf_fft);
    bcopy(accum->imagedata,image->imagedata,rows*cols*sizeof(float));
    freeimage(accum);
    return(1);
  }
/* -library_code_end */
