 /*
  * Khoros: $Id: lvgrow.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvgrow.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvgrow.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvgrow.c
 >>>>
 >>>>      Program Name: vgrow
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:39:51 1991 
 >>>>
 >>>>          Routines: lvgrow - the library call for vgrow
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvgrow - library call for vgrow
*
* Purpose:
*    
*    Computes the median axis inverse transform.
*    
*    
* Input:
*    
*         image _ an xvimage structure
*    
*    
* Output:
*    
*         image _ holds the result.
*    
*    
*
* Written By: Pascal Adam
*    
*    Ghosted by Pascal ADAM Fri Jun  1 17:35:45 MDT 1990
*    Bug fixed by Pascal ADAM Mon Jun  4 10:04:07 MDT 1990
*    
*    
****************************************************************/


/* -library_def */
int
lvgrow(image)
struct xvimage *image;
/* -library_def_end */

/* -library_code */

{

    unsigned char *cptr;

    int i, j, k, nc, nr, val;

    int fin;
 
    char   *program = "lvgrow";

    /* Check type,... of image */
    if (!(propertype(program, image, VFF_TYP_1_BYTE, FALSE))) {
        (void) fprintf (stderr, "\n\n%s:   ", program);
        (void) fprintf (stderr, "lvgrow: image must be of type byte\n");
        return (0);
    }
    if (!(proper_num_images (program, image, 1, FALSE))) {
        (void) fprintf (stderr, "\n\n%s:   ", program);
        (void) fprintf (stderr, "Can only work on files with one image\n\n");
        return (0);
    }
    if (!(proper_num_bands (program, image, 1, FALSE))) {
        (void) fprintf (stderr,"\n\n%s:   ", program);
        (void) fprintf (stderr,"Can only work on images with 1 data band\n\n");
        return (0);
    }

    nr = image->col_size;
    nc = image->row_size;


    cptr   = (unsigned char *) image->imagedata;


    /* Growing process ...... scanning of input image */
    /* until the growing process stops .............. */
    do 
    {
       fin = TRUE;
       for (i=1;i<nr;i++)
       {
           for (j=1;j<nc;j++)
           { 
               val = *(cptr+i*nc+j);
               switch(val) 
               {
                case 0: 
                case 1: 
                  break;

                default:
                  fin = FALSE;
                  val--;
                  *(cptr+i*nc+j) = val;
                  k= (i-1)*nc+j;
                  if ((k >= 0) || (k < nc*nr)) 
                  {
                     if (*(cptr+k) < val ) *(cptr+k) = val;
                  }
                  else 
                  {
                    (void)fprintf(stderr,"lvgrow : lvgrow failed\n"); 
                    (void)fprintf(stderr,
                     "The Input Image has to be a medial axis image\n");
                  }
                  k= (i+1)*nc+j;
                  if ((k >= 0) || (k < nc*nr)) 
                  {
                    if (*(cptr+k) < val ) *(cptr+k) = val;
                  }
                  else 
                  {
                    (void)fprintf(stderr,"lvgrow : lvgrow failed\n"); 
                    (void)fprintf(stderr,
                    "The Input Image has to be a medial axis image\n");
                  }

                  k= i*nc+j-1;
                  if ((k >= 0) || (k < nc*nr))
                  {
                    if (*(cptr+k) < val ) *(cptr+k) = val;
                  }
                  else 
                  {
                    (void)fprintf(stderr,"lvgrow : lvgrow failed\n"); 
                    (void)fprintf(stderr,
                    "The Input Image has to be a medial axis image\n");
                  }

                  k= i*nc+j+1;
                  if ((k >= 0) || (k < nc*nr)) 
                  {
                    if (*(cptr+k) < val ) *(cptr+k) = val;
                  }
                  else 
                  {
                    (void)fprintf(stderr,"lvgrow : lvgrow failed\n"); 
                    (void)fprintf(stderr,
                    "The Input Image has to be a medial axis image\n");
                  }
               }
           }
       }
    }
    while (fin == FALSE);
    
    cptr   = (unsigned char *) image->imagedata;

    for (i=0; i< nc*nr ;i++)  *(cptr+i) = *(cptr+i) * 255;

    return(1);
        
}
/* -library_code_end */
