 /*
  * Khoros: $Id: lvqerr.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvqerr.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvqerr.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvqerr.c
 >>>>
 >>>>      Program Name: vqerr
 >>>>
 >>>> Date Last Updated: Thu Mar  7 16:15:28 1991 
 >>>>
 >>>>          Routines: lvqerr - the library call for vqerr
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvqerr - library call for vqerr
*
* Purpose:
*    
*    Compute the quantization error between a quantized image and
*    the original.
*    
*    
* Input:
*    
*    img1           quantized VIFF image structure
*    
*    img2           original VIFF image structure
*    
*    img3           gating mask image
*    
*    mflg           a flag set (equal 1) if gating mask available
*    
*    rms            pointer to a DOUBLE to receive the RMS error
*    
*    
* Output:
*    
*    rms            is modified to contain the RMS quantization error
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    
* Written By:
*
*    
*    
****************************************************************/


/* -library_def */
int
lvqerr(img1,img2,img3,mflg,rms)
struct xvimage *img1, *img2, *img3;
int   mflg;
double *rms;
/* -library_def_end */

/* -library_code */
{
    int    i, j, k, count;
    unsigned char *c1,*c2,*c3,*c4,*mpc;
    short         *s1,*s2,*s3,*s4,*mps;
    int           *i1,*i2,*i3,*i4,*mpi;
    float         *f1,*f2,*f3,*f4,*mpf;
    double err,e;
    unsigned int mapind;

    err = 0;
    count = 0;

    switch (img2->data_storage_type)
      {
        case VFF_TYP_BIT :
          fprintf(stderr,"lvqerr: Don't know how to handle BIT images\n");
          return(0);
          break;

        case VFF_TYP_1_BYTE : 
          k = img1->row_size*img1->col_size;
          mpc = (unsigned char *)(img1->maps);
          if (!mflg)
            {
              c2 = (unsigned char *)(img2->imagedata);
              for (i=0; i<img2->num_data_bands; i++)
                {
                  if (img1->data_storage_type == VFF_TYP_1_BYTE)
                    c1 = (unsigned char *)(img1->imagedata);
                  else
                    i1 = (int *)(img1->imagedata);
                  for (j=0; j<k; j++)
                    {
                      if (img1->data_storage_type == VFF_TYP_1_BYTE)
                        mapind = i*img1->map_col_size + *c1++;
                      else
                        mapind = i*img1->map_col_size + *i1++;
                      e = (double)(mpc[mapind]) - (double)(*c2++);
                      err += e*e;
                      count++;
                    }
                }
            }
          else
            {
              c2 = (unsigned char *)(img2->imagedata);
              for (i=0; i<img2->num_data_bands; i++)
                {
                  if (img1->data_storage_type == VFF_TYP_1_BYTE)
                    c1 = (unsigned char *)(img1->imagedata);
                  else
                    i1 = (int *)(img1->imagedata);
                  c3 = (unsigned char *)(img3->imagedata);
                  for (j=0; j<k; j++)
                    {
                      if (*c3++)
                        {
                          if (img1->data_storage_type == VFF_TYP_1_BYTE)
                            mapind = i*img1->map_col_size + *c1++;
                          else
                            mapind = i*img1->map_col_size + *i1++;
                          e = (double)(mpc[mapind]) - (double)(*c2++);
                          err += e*e;
                          count++;
                        }
                      else
                        {
                          if (img1->data_storage_type == VFF_TYP_1_BYTE) c1++;
                          else i1++;
                          c2++;
                        }
                    }
                }
            }
          break;
 
        case VFF_TYP_2_BYTE :
          k = img1->row_size*img1->col_size;
          mps = (short *)(img1->maps);
          if (!mflg)
            {
              s2 = (short *)(img2->imagedata);
              for (i=0; i<img2->num_data_bands; i++)
                {
                  if (img1->data_storage_type == VFF_TYP_1_BYTE)
                    c1 = (unsigned char *)(img1->imagedata);
                  else
                    i1 = (int *)(img1->imagedata);
                  for (j=0; j<k; j++)
                    {
                      if (img1->data_storage_type == VFF_TYP_1_BYTE)
                        mapind = i*img1->map_col_size + *c1++;
                      else
                        mapind = i*img1->map_col_size + *i1++;
                      e = (double)(mps[mapind]) - (double)(*s2++);
                      err += e*e;
                      count++;
                    }
                }
            }
          else
            {
              s2 = (short *)(img2->imagedata);
              for (i=0; i<img2->num_data_bands; i++)
                {
                  if (img1->data_storage_type == VFF_TYP_1_BYTE)
                    c1 = (unsigned char *)(img1->imagedata);
                  else
                    i1 = (int *)(img1->imagedata);
                  s3 = (short *)(img3->imagedata);
                  for (j=0; j<k; j++)
                    {
                      if (*s3++)
                        {
                          if (img1->data_storage_type == VFF_TYP_1_BYTE)
                            mapind = i*img1->map_col_size + *c1++;
                          else
                            mapind = i*img1->map_col_size + *i1++;
                          e = (double)(mps[mapind]) - (double)(*s2++);
                          err += e*e;
                          count++;
                        }
                      else
                        {
                          if (img1->data_storage_type == VFF_TYP_1_BYTE) c1++;
                          else i1++;
                          s2++;
                        }
                    }
                }
            }
          break;
 

        case VFF_TYP_4_BYTE :
          k = img1->row_size*img1->col_size;
          mpi = (int *)(img1->maps);
          if (!mflg)
            {
              i2 = (int *)(img2->imagedata);
              for (i=0; i<img2->num_data_bands; i++)
                {
                  if (img1->data_storage_type == VFF_TYP_1_BYTE)
                    c1 = (unsigned char *)(img1->imagedata);
                  else
                    i1 = (int *)(img1->imagedata);
                  for (j=0; j<k; j++)
                    {
                      if (img1->data_storage_type == VFF_TYP_1_BYTE)
                        mapind = i*img1->map_col_size + *c1++;
                      else
                        mapind = i*img1->map_col_size + *i1++;
                      e = (double)(mpi[mapind]) - (double)(*i2++);
                      err += e*e;
                      count++;
                    }
                }
            }
          else
            {
              i2 = (int *)(img2->imagedata);
              for (i=0; i<img2->num_data_bands; i++)
                {
                  if (img1->data_storage_type == VFF_TYP_1_BYTE)
                    c1 = (unsigned char *)(img1->imagedata);
                  else
                    i1 = (int *)(img1->imagedata);
                  i3 = (int *)(img3->imagedata);
                  for (j=0; j<k; j++)
                    {
                      if (*i3++)
                        {
                          if (img1->data_storage_type == VFF_TYP_1_BYTE)
                            mapind = i*img1->map_col_size + *c1++;
                          else
                            mapind = i*img1->map_col_size + *i1++;
                          e = (double)(mpi[mapind]) - (double)(*i2++);
                          err += e*e;
                          count++;
                        }
                      else
                        {
                          if (img1->data_storage_type == VFF_TYP_1_BYTE) c1++;
                          else i1++;
                          i2++;
                        }
                    }
                }
            }
          break;
 

        case VFF_TYP_FLOAT :
          k = img1->row_size*img1->col_size;
          mpf = (float *)(img1->maps);
          if (!mflg)
            {
              f2 = (float *)(img2->imagedata);
              for (i=0; i<img2->num_data_bands; i++)
                {
                  if (img1->data_storage_type == VFF_TYP_1_BYTE)
                    c1 = (unsigned char *)(img1->imagedata);
                  else
                    i1 = (int *)(img1->imagedata);
                  for (j=0; j<k; j++)
                    {
                      if (img1->data_storage_type == VFF_TYP_1_BYTE)
                        mapind = i*img1->map_col_size + *c1++;
                      else
                        mapind = i*img1->map_col_size + *i1++;
                      e = (double)(mpf[mapind]) - (double)(*f2++);
                      err += e*e;
                      count++;
                    }
                }
            }
          else
            {
              f2 = (float *)(img2->imagedata);
              for (i=0; i<img2->num_data_bands; i++)
                {
                  if (img1->data_storage_type == VFF_TYP_1_BYTE)
                    c1 = (unsigned char *)(img1->imagedata);
                  else
                    i1 = (int *)(img1->imagedata);
                  f3 = (float *)(img3->imagedata);
                  for (j=0; j<k; j++)
                    {
                      if (*f3++)
                        {
                          if (img1->data_storage_type == VFF_TYP_1_BYTE)
                            mapind = i*img1->map_col_size + *c1++;
                          else
                            mapind = i*img1->map_col_size + *i1++;
                          e = (double)(mpf[mapind]) - (double)(*f2++);
                          err += e*e;
                          count++;
                        }
                      else
                        {
                          if (img1->data_storage_type == VFF_TYP_1_BYTE) c1++;
                          else i1++;
                          f2++;
                        }
                    }
                }
            }
          break;

        case VFF_TYP_COMPLEX :
          fprintf(stderr,"lvqerr: Unsupported data type!\n");
          return(0);
          break;

        default:
          fprintf(stderr,"lvqerr: Unknown data storage type, %d\n",img1->data_storage_type);
          return(0);
          break;
      }
      err = err / count;
      *rms = sqrt(err);
      return(1);
}
/* -library_code_end */
