 /*
  * Khoros: $Id: lrfclass.h,v 1.1 1991/05/10 15:46:01 khoros Exp $
  */

 /*
  * $Log: lrfclass.h,v $
 * Revision 1.1  1991/05/10  15:46:01  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lrfclass.h
 >>>>            Author: Tom Sauer and Charlie Gage
 >>>> Date Last Updated: Tue Apr  9 08:35:36 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _lrfclass_h_
#define _lrfclass_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    lrfclass Argument Structure
*
****************************************************************/

typedef struct _lrfclass  {

/*
 *  input image (Required infile)
 */
char	*i1_file;	/* input image FILENAME */
int	 i1_flag;	/* input image FLAG */

/*
 *  cluster center image (Required infile)
 */
char	*i2_file;	/* cluster center image FILENAME */
int	 i2_flag;	/* cluster center image FLAG */

/*
 *  cluster variance image (Required infile)
 */
char	*i3_file;	/* cluster variance image FILENAME */
int	 i3_flag;	/* cluster variance image FLAG */

/*
 *  weight image (Required infile)
 */
char	*i4_file;	/* weight image FILENAME */
int	 i4_flag;	/* weight image FLAG */

/*
 *  classified image (Required outfile)
 */
char	*o_file;	/* classified image FILENAME */
int	 o_flag;	/* classified image FLAG */

/*
 *  Border Width (Optional integer)
 */
int	 b_int; 	/* Border Width INT */
int	 b_flag;	/* Border Width FLAG */

}  lrfclass_struct;

lrfclass_struct *lrfclass;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READIMAGE1(image) \
        image = readimage(lrfclass->i1_file);  \
        if (image == NULL) {  \
        (void) fprintf(stderr, "lrfclass: Can not read input image \n");  \
        exit(1);  /* Quit if bad image */ \
        }

#define READIMAGE2(cc_img) \
        cc_img = readimage(lrfclass->i2_file);  \
        if (cc_img == NULL) {  \
        (void) fprintf(stderr,"lrfclass: Can not read cluster center image\n"); \
        exit(1);  /* Quit if bad image */ \
        }

#define READIMAGE3(var_img) \
        var_img = readimage(lrfclass->i3_file);  \
        if (var_img == NULL) {  \
        (void) fprintf(stderr,"lrfclass: Can not read variance image\n"); \
        exit(1);  /* Quit if bad image */ \
        }

#define READIMAGE4(wt_img) \
        wt_img = readimage(lrfclass->i4_file);  \
        if (wt_img == NULL) {  \
        (void) fprintf(stderr,"lrfclass: Can not read weight image\n"); \
        exit(1);  /* Quit if bad image */ \
        }

#define CHECKTYPE(program, image) \
   if( !(propertype(program, image, VFF_TYP_FLOAT, TRUE)) ) { \
      fprintf(stderr,"%s: data storage type must be FLOAT.",program); \
      exit(1); \
    }

#define CHECKINPUT(program, image) \
        (void) proper_num_images(program,image,1,TRUE); \
        \
        (void) proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE)
/* -include_macros_end */

#endif
