 /*
  * Khoros: $Id: lrftrain.c,v 1.1 1991/05/10 15:46:03 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lrftrain.c,v 1.1 1991/05/10 15:46:03 khoros Exp $";
#endif

 /*
  * $Log: lrftrain.c,v $
 * Revision 1.1  1991/05/10  15:46:03  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lrftrain.c
 >>>>
 >>>>      Program Name: lrftrain
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Trains on an image for the weights  used  in  the  Localized
 >>>>	Receptive Field classifier.
 >>>>	
 >>>>	
 >>>>            Author: Tom Sauer and Charlie Gage
 >>>>
 >>>> Date Last Updated: Tue Apr  9 08:34:34 1991
 >>>>
 >>>>          Routines: main- the main program for lrftrain
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "lrftrain.h"


/****************************************************************
 *
 * Routine Name:  main program for lrftrain
 *
 *       Input:  
 *          -i1  input image 
 *          -i2  cluster center image 
 *          -i3  cluster variance image 
 *          -i4  cluster number image 
 *          -o  weight image 
 *          -f  output file for training statistics 
 *
 *
 *          [-d] MSE display interval  (value >= 0)
 *          [-cv] convergence value  (value > 0.0)
 *          [-meu] weight update value  (0.000 < value < 1.000)
 *          [-n] Maximum number of iterations  (value > 0)
 *          [-delta] Min delta MSE value  (value > 0.0)
 *          [-b] Border Width  (0 < value < 100)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage  *image,         /* input image */
                *cc_img,        /* cluster center image */
                *var_img,       /* cluster variance image */
                *cn_img,        /* cluster number image */
                *wt_img,        /* output weight image */
                *readimage();
FILE *printdev;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args())
{
  fprintf(stderr, "%s: Illegal arguments on command line.\n", program);
  exit(1);
}

/* Read in INPUT image for processing */
READIMAGE1(image);
CHECKTYPE(program, image);
CHECKINPUT(program, image);

/* Read in CLUSTER CENTER image as input for initial LRF nodes */
READIMAGE2(cc_img);
CHECKTYPE(program, cc_img);
CHECKINPUT(program, cc_img);

/* Read in VARIANCE image to get trace for widths of LRF centers */
READIMAGE3(var_img);
CHECKTYPE(program, var_img);
CHECKINPUT(program, var_img);

/* Read in CLUSTER NUMBER image */
READIMAGE4(cn_img);
CHECKTYPEINT(program, cn_img);
CHECKINPUT(program, cn_img);

/* Check for proper number of bands in images. */
if ( image->num_data_bands != (cc_img->num_data_bands - 1)) {
   fprintf(stderr,"lrfclass: The center/class image does not contain the correct\n");
   fprintf(stderr, "number of data_bands\n");
   fprintf(stderr, "Should have %d bands, but contains %d bands\n", (image->num_data_bands + 1), cc_img->num_data_bands);
   fprintf(stderr, "Please ensure that the classified (ie. supervised) image\n");
   fprintf(stderr, " has been appended to the cluster center image.\n");
   exit(1);
}
if ( image->num_data_bands != var_img->num_data_bands) {
    fprintf(stderr, "lrfclass: The variance image does not contain the correct\n");
    fprintf(stderr, "number of data_bands\n");
    fprintf(stderr, "Should have %d bands, but contains %d bands\n", image->num_data_bands , var_img->num_data_bands);
    exit(1);
}

if (lrftrain->f_flag) {
   if (! vwrite_ascii(lrftrain->f_file, &printdev))
   {
      (void) fprintf(stderr, "%s:  Can't open ascii output file: \n",program);
      exit(1);
   }
}
else
  printdev = stdout;

/* -main_before_lib_call_end */

/* -main_library_call */
if(! llrftrain (image, cc_img, var_img, cn_img, &wt_img, lrftrain->cv_float, 
                lrftrain->meu_float, lrftrain->b_int, lrftrain->n_int, 
                lrftrain->d_int, lrftrain->delta_float, printdev) )
{
  (void) fprintf(stderr, "llrftrain Failed\n");
  exit(1);
}
/* -main_library_call_end */

/* -main_after_lib_call */
/* Write out the weight image */
writeimage(lrftrain->o_file, wt_img);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for lrftrain 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "lrftrain :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tTrains on an image for the weights  used  in  the  Localized\n");
	fprintf(stderr, "\tReceptive Field classifier.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  input image  (infile)\n");
	fprintf(stderr,"\t-i2  cluster center image  (infile)\n");
	fprintf(stderr,"\t-i3  cluster variance image  (infile)\n");
	fprintf(stderr,"\t-i4  cluster number image  (infile)\n");
	fprintf(stderr,"\t-o  weight image  (outfile)\n");
	fprintf(stderr,"\t-f  output file for training statistics  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-d]  MSE display interval (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-cv]  convergence value (float, > 0.0) [0.1]\n");
	fprintf(stderr,"\t[-meu]  weight update value (float,  0.000 to 1.000) [0.5]\n");
	fprintf(stderr,"\t[-n]  Maximum number of iterations (integer, > 0) [10000000]\n");
	fprintf(stderr,"\t[-delta]  Min delta MSE value (float, > 0.0) [1e-09]\n");
	fprintf(stderr,"\t[-b]  Border Width (integer, 0 to 100) [0]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for lrftrain\n");
	fprintf(stderr, "\t[-U] Gives the usage for lrftrain\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called lrftrain.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses lrftrain.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for lrftrain
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) input image \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) cluster center image \n        {infile}: "; 
char	*i3_pstr = 
	"\nEnter: (i3) cluster variance image \n        {infile}: "; 
char	*i4_pstr = 
	"\nEnter: (i4) cluster number image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) weight image \n        {outfile}: "; 
char	*f_pstr = 
	"\nEnter: (f) output file for training statistics \n        {outfile}: "; 
char	*d_pstr = 
	"\nEnter: (d) MSE display interval \n        {integer, >= 0 [0] }: "; 
char	*cv_pstr = 
	"\nEnter: (cv) convergence value \n        {float, > 0.0 [0.100000] }: "; 
char	*meu_pstr = 
	"\nEnter: (meu) weight update value \n        {float,  0.000 to 1.000 [0.500000] }: "; 
char	*n_pstr = 
	"\nEnter: (n) Maximum number of iterations \n        {integer, > 0 [10000000] }: "; 
char	*delta_pstr = 
	"\nEnter: (delta) Min delta MSE value \n        {float, > 0.0 [0.000000] }: "; 
char	*b_pstr = 
	"\nEnter: (b) Border Width \n        {integer, 0 to 100 [0] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "lrftrain", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "lrftrain.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "lrftrain: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "lrftrain.ans");
		}

	     }

	}

	/*
	 * allocate the lrftrain structure
	 */
	lrftrain = (lrftrain_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (lrftrain_struct));

	/*
	 * get required arguments for lrftrain
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(lrftrain->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(lrftrain->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(lrftrain->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    lrftrain->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(lrftrain->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(lrftrain->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(lrftrain->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(lrftrain->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    lrftrain->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(lrftrain->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(lrftrain->i3_flag = vget_infile(fid, prompt_flag,
			"-i3", i3_pstr, &(lrftrain->i3_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(lrftrain->i3_flag))
		{
		    fprintf(stderr, "\t\ti3 is required, please re-enter: \n");
		    lrftrain->i3_flag = vget_infile(fid, prompt_flag,
		    "-i3", i3_pstr, &(lrftrain->i3_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i3' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(lrftrain->i4_flag = vget_infile(fid, prompt_flag,
			"-i4", i4_pstr, &(lrftrain->i4_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(lrftrain->i4_flag))
		{
		    fprintf(stderr, "\t\ti4 is required, please re-enter: \n");
		    lrftrain->i4_flag = vget_infile(fid, prompt_flag,
		    "-i4", i4_pstr, &(lrftrain->i4_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i4' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(lrftrain->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(lrftrain->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(lrftrain->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    lrftrain->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(lrftrain->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(lrftrain->f_flag = vget_outfile(fid, prompt_flag,
			"-f", f_pstr, &(lrftrain->f_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(lrftrain->f_flag))
		{
		    fprintf(stderr, "\t\tf is required, please re-enter: \n");
		    lrftrain->f_flag = vget_outfile(fid, prompt_flag,
		    "-f", f_pstr, &(lrftrain->f_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-f' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for lrftrain
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	lrftrain->d_flag = vget_int(fid, prompt_flag,
	"-d", d_pstr, &(lrftrain->d_int),
	0, 1, 1);

	lrftrain->cv_flag = vget_float(fid, prompt_flag,
	"-cv", cv_pstr, &(lrftrain->cv_float),
	0.100000, 2.000000, 2.000000);

	lrftrain->meu_flag = vget_float(fid, prompt_flag,
	"-meu", meu_pstr, &(lrftrain->meu_float),
	0.500000, 0.000000, 1.000000);

	lrftrain->n_flag = vget_int(fid, prompt_flag,
	"-n", n_pstr, &(lrftrain->n_int),
	10000000, 2, 2);

	lrftrain->delta_flag = vget_float(fid, prompt_flag,
	"-delta", delta_pstr, &(lrftrain->delta_float),
	0.000000, 2.000000, 2.000000);

	lrftrain->b_flag = vget_int(fid, prompt_flag,
	"-b", b_pstr, &(lrftrain->b_int),
	0, 0, 100);


}



