 /*
  * Khoros: $Id: viso2.h,v 1.1 1991/05/10 15:46:05 khoros Exp $
  */

 /*
  * $Log: viso2.h,v $
 * Revision 1.1  1991/05/10  15:46:05  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: viso2.h
 >>>>            Author: Tom Sauer, Donna Koechner
 >>>> Date Last Updated: Tue Mar  5 22:20:33 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _viso2_h_
#define _viso2_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    viso2 Argument Structure
*
****************************************************************/

typedef struct _viso2  {

/*
 *  input image (Required infile)
 */
char	*i1_file;	/* input image FILENAME */
int	 i1_flag;	/* input image FLAG */

/*
 *  output image specifying which vector belongs to what cluster (Required outfile)
 */
char	*o1_file;	/* output image specifying which vector belongs to what cluster FILENAME */
int	 o1_flag;	/* output image specifying which vector belongs to what cluster FLAG */

/*
 *  output image for cluster centers (Required outfile)
 */
char	*o2_file;	/* output image for cluster centers FILENAME */
int	 o2_flag;	/* output image for cluster centers FLAG */

/*
 *  output variance (Required outfile)
 */
char	*o3_file;	/* output variance FILENAME */
int	 o3_flag;	/* output variance FLAG */

/*
 *  output file for kmeans statistics (Optional outfile)
 */
char	*f2_file;	/* output file for kmeans statistics FILENAME */
int	 f2_flag;	/* output file for kmeans statistics FLAG */

/*
 *  specifies minimum number of samples per cluster (default = 1) (Optional integer)
 */
int	 n_int; 	/* specifies minimum number of samples per cluster (default = 1) INT */
int	 n_flag;	/* specifies minimum number of samples per cluster (default = 1) FLAG */

/*
 *  specifies splitting factor (splitting factor increase -> less splitting) (default = 10000000) (Optional float)
 */
float	 s_float;	/* specifies splitting factor (splitting factor increase -> less splitting) (default = 10000000) FLOAT */
int	 s_flag;   	/* specifies splitting factor (splitting factor increase -> less splitting) (default = 10000000) FLAG */

/*
 *  specifies merging factor (merging factor decreases -> less merging) (default = 0) (Optional float)
 */
float	 m_float;	/* specifies merging factor (merging factor decreases -> less merging) (default = 0) FLOAT */
int	 m_flag;   	/* specifies merging factor (merging factor decreases -> less merging) (default = 0) FLAG */

/*
 *  specifies splitting convergence (default = 0) (Optional float)
 */
float	 sc_float;	/* specifies splitting convergence (default = 0) FLOAT */
int	 sc_flag;   	/* specifies splitting convergence (default = 0) FLAG */

/*
 *  specifies merging convergence (default = 0) (Optional float)
 */
float	 mc_float;	/* specifies merging convergence (default = 0) FLOAT */
int	 mc_flag;   	/* specifies merging convergence (default = 0) FLAG */

/*
 *  specifies placement of new cluster centers during splitting (default = 0.5) (Optional float)
 */
float	 p_float;	/* specifies placement of new cluster centers during splitting (default = 0.5) FLOAT */
int	 p_flag;   	/* specifies placement of new cluster centers during splitting (default = 0.5) FLAG */

/*
 *  specifies maximum number of iterations for kmeans (default = 100000) (Optional integer)
 */
int	 ik_int; 	/* specifies maximum number of iterations for kmeans (default = 100000) INT */
int	 ik_flag;	/* specifies maximum number of iterations for kmeans (default = 100000) FLAG */

/*
 *  specifies maximum number of iterations for iso2 (default = 100000) (Optional integer)
 */
int	 ii_int; 	/* specifies maximum number of iterations for iso2 (default = 100000) INT */
int	 ii_flag;	/* specifies maximum number of iterations for iso2 (default = 100000) FLAG */

/*
 *  specifies maximum number of clusters (default = 50) (Optional integer)
 */
int	 k_int; 	/* specifies maximum number of clusters (default = 50) INT */
int	 k_flag;	/* specifies maximum number of clusters (default = 50) FLAG */

/*
 *   specifies the border width in pixels (default = 0) (Optional integer)
 */
int	 b_int; 	/*  specifies the border width in pixels (default = 0) INT */
int	 b_flag;	/*  specifies the border width in pixels (default = 0) FLAG */

/*----  these are an Optional mutually exclusive group ----*/
/*
 *  use First K Vectors As Cluster Centers (default = 5) (Required integer)
 */
int	 c_int; 	/* use First K Vectors As Cluster Centers (default = 5) INT */
int	 c_flag;	/* use First K Vectors As Cluster Centers (default = 5) FLAG */

/*
 *  input ASCII file for x-y coordinates of cluster centers (Required infile)
 */
char	*f1_file;	/* input ASCII file for x-y coordinates of cluster centers FILENAME */
int	 f1_flag;	/* input ASCII file for x-y coordinates of cluster centers FLAG */

/*
 *  input image cluster center values (Required infile)
 */
char	*i2_file;	/* input image cluster center values FILENAME */
int	 i2_flag;	/* input image cluster center values FLAG */

/*-------------------------------------------*/

}  viso2_struct;

viso2_struct *viso2;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(image) \
image = readimage(viso2->i1_file); \
if(image == NULL){ \
(void) fprintf(stderr,"viso2: Image could not be read\n"); \
exit(1); \
}

#define CHECKINPUT(program, image) \
(void) proper_num_images(program,image,1,TRUE); \
\
(void) proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE); \
\
(void) propertype(program, image, VFF_TYP_FLOAT, TRUE)
/* -include_macros_end */

#endif
