 /*
  * Khoros: $Id: vlabel.h,v 1.1 1991/05/10 15:46:10 khoros Exp $
  */

 /*
  * $Log: vlabel.h,v $
 * Revision 1.1  1991/05/10  15:46:10  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vlabel.h
 >>>>            Author: Pascal ADAM
 >>>> Date Last Updated: Tue Mar  5 22:20:57 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vlabel_h_
#define _vlabel_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vlabel Argument Structure
*
****************************************************************/

typedef struct _vlabel  {

/*
 *  output image after the labelling process (Required outfile)
 */
char	*o_file;	/* output image after the labelling process FILENAME */
int	 o_flag;	/* output image after the labelling process FLAG */

/*
 *  if flag= 1 the small regions will be merged together in connex regions, or will be included to existing labelled regions (Required logical)
 */
int	 merge_logic;	/* if flag= 1 the small regions will be merged together in connex regions, or will be included to existing labelled regions LOGIC */
int	 merge_flag;  	/* if flag= 1 the small regions will be merged together in connex regions, or will be included to existing labelled regions FLAG */

/*
 * 1 for euclidean distance, 2 for city block (Required integer toggle - )
 */
int	 m_toggle;		/* 1 for euclidean distance, 2 for city block INT TOGGLE */
int	 m_flag;		/* 1 for euclidean distance, 2 for city block FLAG */

/*
 * 1 for the 4 connectivity, 2 for 8 connectivity (Required integer toggle - )
 */
int	 c_toggle;		/* 1 for the 4 connectivity, 2 for 8 connectivity INT TOGGLE */
int	 c_flag;		/* 1 for the 4 connectivity, 2 for 8 connectivity FLAG */

/*----- these are a Required mutually exclusive group ----*/
/*
 *  input image (Required infile)
 */
char	*i1_file;	/* input image FILENAME */
int	 i1_flag;	/* input image FLAG */

/*
 *  input image for cluster centers (Required infile)
 */
char	*i2_file;	/* input image for cluster centers FILENAME */
int	 i2_flag;	/* input image for cluster centers FLAG */

/*-------------------------------------------*/

/*----- these are a Required mutually exclusive group ----*/
/*
 *  Number of region that the user wishes to get from the labelling process (Required integer)
 */
int	 n_int; 	/* Number of region that the user wishes to get from the labelling process INT */
int	 n_flag;	/* Number of region that the user wishes to get from the labelling process FLAG */

/*
 *  the higher the factor the finer the regions (Required float)
 */
float	 f_float;	/* the higher the factor the finer the regions FLOAT */
int	 f_flag;   	/* the higher the factor the finer the regions FLAG */

/*-------------------------------------------*/

/*
 *  input image for cluster numbers (Optional infile)
 */
char	*i3_file;	/* input image for cluster numbers FILENAME */
int	 i3_flag;	/* input image for cluster numbers FLAG */

/*
 *  output file for vlabel result display (Optional outfile)
 */
char	*asc_file;	/* output file for vlabel result display FILENAME */
int	 asc_flag;	/* output file for vlabel result display FLAG */

/*
 *  specifies the border width in pixels (default = 0) (Optional integer)
 */
int	 w_int; 	/* specifies the border width in pixels (default = 0) INT */
int	 w_flag;	/* specifies the border width in pixels (default = 0) FLAG */

/*
 *  Minimum number of pixel to keep in label region (Optional float)
 */
float	 s_float;	/* Minimum number of pixel to keep in label region FLOAT */
int	 s_flag;   	/* Minimum number of pixel to keep in label region FLAG */

}  vlabel_struct;

vlabel_struct *vlabel;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
