 /*
  * Khoros: $Id: vmindis.c,v 1.1 1991/05/10 15:46:12 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vmindis.c,v 1.1 1991/05/10 15:46:12 khoros Exp $";
#endif

 /*
  * $Log: vmindis.c,v $
 * Revision 1.1  1991/05/10  15:46:12  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vmindis.c
 >>>>
 >>>>      Program Name: vmindis
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Minimum Distance Classifier
 >>>>	
 >>>>	
 >>>>            Author: Tom Sauer
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:21:04 1991
 >>>>
 >>>>          Routines: main- the main program for vmindis
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vmindis.h"


/****************************************************************
 *
 * Routine Name:  main program for vmindis
 *
 *       Input:  
 *         -i1  input image 
 *         -i2  input image 
 *         -o  output image specifying which vector belongs to what cluster 
 *
 *
 *         [-b]  specifies the border width in pixels (default = 0)  (0 < value < 100)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image, *center, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);
/* -main_before_lib_call_end */

/* -main_library_call */
READINPUT1 (image);
READINPUT2 (image);
CHECKINPUT (program, image);

CHECKINPUT(program, center);
if ( image -> num_data_bands != (center->num_data_bands - 1)) {
   fprintf(stderr,"vmindis: The center/class image does not contain the correct\n");
   fprintf(stderr,"number of data_bands\n");
   fprintf(stderr,"Should have %d bands, but contains %d bands\n",(image->num_data_bands + 1), center->num_data_bands);
   exit(1);
   }

  /* Call the lib routine for minimum distance algorithm */

if(! lvmindis(image, center, vmindis->b_int))
  {
    (void) fprintf(stderr, "lvmindis Failed\\n");
    exit(1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(vmindis->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vmindis 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vmindis :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tMinimum Distance Classifier\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  input image  (infile)\n");
	fprintf(stderr,"\t-i2  input image  (infile)\n");
	fprintf(stderr,"\t-o  output image specifying which vector belongs to what cluster  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-b]   specifies the border width in pixels (default = 0) (integer, 0 to 100) [0]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vmindis\n");
	fprintf(stderr, "\t[-U] Gives the usage for vmindis\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vmindis.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vmindis.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vmindis
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) input image \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image specifying which vector belongs to what cluster \n        {outfile}: "; 
char	*b_pstr = 
	"\nEnter: (b)  specifies the border width in pixels (default = 0) \n        {integer, 0 to 100 [0] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vmindis", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vmindis.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vmindis: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vmindis.ans");
		}

	     }

	}

	/*
	 * allocate the vmindis structure
	 */
	vmindis = (vmindis_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vmindis_struct));

	/*
	 * get required arguments for vmindis
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vmindis->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(vmindis->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmindis->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    vmindis->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(vmindis->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vmindis->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(vmindis->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmindis->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    vmindis->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(vmindis->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vmindis->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vmindis->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmindis->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vmindis->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vmindis->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vmindis
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vmindis->b_flag = vget_int(fid, prompt_flag,
	"-b", b_pstr, &(vmindis->b_int),
	0, 0, 100);


}



