 /*
  * Khoros: $Id: vquant.h,v 1.3 1991/12/18 09:33:14 dkhoros Exp $
  */

 /*
  * $Log: vquant.h,v $
 * Revision 1.3  1991/12/18  09:33:14  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vquant.h
 >>>>            Author: Scott Wilson
 >>>> Date Last Updated: Thu Nov 14 16:03:07 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vquant_h_
#define _vquant_h_

#include "vinclude.h"


/* -include_includes */
struct vector
  {
    float *vec;                           /* Vector components */
    int count;                            /* Pixel count */
    struct vector *prev;                  /* Ptrs to previous & next vector */
    struct vector *next;
    struct pixel *pixlist;                /* List of pixels of this vector */
    struct pixel *pixtail;                /* End of pixel list */
  };

struct pixel
  {
    short x,y;                            /* Location of pixel */
    struct pixel *next;                   /* Pointer to next one */
  };

struct vector *vhead,*vtail;               /* Composite vector list */
struct vector *vh[65536],*vt[65536];       /* Hash index vector lists */

struct box
  {
    float *vmin,*vmax;                    /* Bounds on box */
    struct vector *vectors;               /* List of vectors in box */
    struct box *next;                     /* Next box */
    int count;                            /* Number of pixels in box */
  };

struct box *boxhead,*boxtail;

int ndim;                                 /* Dimensionality of space */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vquant Argument Structure
*
****************************************************************/

typedef struct _vquant  {

/*
 *  input image (Required infile)
 */
char	*i_file;	/* input image FILENAME */
int	 i_flag;	/* input image FLAG */

/*
 *  output resulting image (Required outfile)
 */
char	*o_file;	/* output resulting image FILENAME */
int	 o_flag;	/* output resulting image FLAG */

/*
 * Select splitting axis (Required integer toggle - )
 */
int	 axis_toggle;		/* Select splitting axis INT TOGGLE */
int	 axis_flag;		/* Select splitting axis FLAG */

/*
 *  cluster center output image (Optional outfile)
 */
char	*o1_file;	/* cluster center output image FILENAME */
int	 o1_flag;	/* cluster center output image FLAG */

/*
 *  cluster variance output image (Optional outfile)
 */
char	*o2_file;	/* cluster variance output image FILENAME */
int	 o2_flag;	/* cluster variance output image FLAG */

/*
 *  number of vectors (Optional integer)
 */
int	 n_int; 	/* number of vectors INT */
int	 n_flag;	/* number of vectors FLAG */

/*
 *  Output Image Map Enable (Optional logical)
 */
int	 m_logic;	/* Output Image Map Enable LOGIC */
int	 m_flag;  	/* Output Image Map Enable FLAG */

/*
 *  Select split point - False: mid-span, True: mean (Optional logical)
 */
int	 s_logic;	/* Select split point - False: mid-span, True: mean LOGIC */
int	 s_flag;  	/* Select split point - False: mid-span, True: mean FLAG */

}  vquant_struct;

vquant_struct *vquant;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(image)\
  image = readimage(vquant->i_file);\
  if (image == NULL)\
    {\
      (void) fprintf(stderr,"vquant: unable to read input image\\n");\
      exit(1);\
    }

#define CHECKINPUT(program,image)\
  propertype(program,image,VFF_TYP_FLOAT,TRUE);\
  proper_num_images(program,image,1,TRUE);\
  proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE);
/* -include_macros_end */

#endif
