 /*
  * Khoros: $Id: vgamut.c,v 1.2 1991/10/02 00:26:41 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vgamut.c,v 1.2 1991/10/02 00:26:41 khoros Exp $";
#endif

 /*
  * $Log: vgamut.c,v $
 * Revision 1.2  1991/10/02  00:26:41  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vgamut.c
 >>>>
 >>>>      Program Name: vgamut
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Compress 3-band (24-bit) images to N-plane pseudo color
 >>>>	
 >>>>	

 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Sat Aug 24 21:24:08 1991
 >>>>
 >>>>          Routines: main- the main program for vgamut
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vgamut.h"


/****************************************************************
 *
 * Routine Name:  main program for vgamut
 *
 *       Input:  
 *        -i  input image filename 
 *        -o  output image filename 
 *
 *
 *        [-n] specifies the number of colors to compress to  (1 < value < 256)
 *        [-p] grey levels are truncated to this number of bits  (1 < value < 8)
 *        [-r] fraction of color splits based on color subspace 2-norm  (0.000 < value < 1.000)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        struct xvimage *image, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);
        image = readimage(vgamut->i_file);
        if (image == NULL) exit(1);                   /* Quit if bad image */
        CHECKINPUT(program,image);
/* -main_before_lib_call_end */

/* -main_library_call */
        if(!lvgamut(image,vgamut->n_int,vgamut->p_int,vgamut->r_float))
          {
            (void) fprintf(stderr, "lvgamut Failed\n");
            exit(1);
          }
/* -main_library_call_end */

/* -main_after_lib_call */
        writeimage(vgamut->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vgamut 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vgamut :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCompress 3-band (24-bit) images to N-plane pseudo color\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image filename  (infile)\n");
	fprintf(stderr,"\t-o  output image filename  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-n]  specifies the number of colors to compress to (integer, 1 to 256) [128]\n");
	fprintf(stderr,"\t[-p]  grey levels are truncated to this number of bits (integer, 1 to 8) [6]\n");
	fprintf(stderr,"\t[-r]  fraction of color splits based on color subspace 2-norm (float,  0.000 to 1.000) [0.5]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vgamut\n");
	fprintf(stderr, "\t[-U] Gives the usage for vgamut\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vgamut.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vgamut.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vgamut
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image filename \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image filename \n        {outfile}: "; 
char	*n_pstr = 
	"\nEnter: (n) specifies the number of colors to compress to \n        {integer, 1 to 256 [128] }: "; 
char	*p_pstr = 
	"\nEnter: (p) grey levels are truncated to this number of bits \n        {integer, 1 to 8 [6] }: "; 
char	*r_pstr = 
	"\nEnter: (r) fraction of color splits based on color subspace 2-norm \n        {float,  0.000 to 1.000 [0.500000] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vgamut", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vgamut.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vgamut: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vgamut.ans");
		}

	     }

	}

	/*
	 * allocate the vgamut structure
	 */
	vgamut = (vgamut_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vgamut_struct));

	/*
	 * get required arguments for vgamut
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vgamut->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vgamut->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgamut->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vgamut->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vgamut->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgamut->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vgamut->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgamut->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vgamut->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vgamut->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vgamut
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vgamut->n_flag = vget_int(fid, prompt_flag,
	"-n", n_pstr, &(vgamut->n_int),
	128, 1, 256);

	vgamut->p_flag = vget_int(fid, prompt_flag,
	"-p", p_pstr, &(vgamut->p_int),
	6, 1, 8);

	vgamut->r_flag = vget_float(fid, prompt_flag,
	"-r", r_pstr, &(vgamut->r_float),
	0.500000, 0.000000, 1.000000);


}



