 /*
  * Khoros: $Id: vrtoc.c,v 1.2 1992/03/20 22:53:20 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vrtoc.c,v 1.2 1992/03/20 22:53:20 dkhoros Exp $";
#endif

 /*
  * $Log: vrtoc.c,v $
 * Revision 1.2  1992/03/20  22:53:20  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vrtoc.c
 >>>>
 >>>>      Program Name: vrtoc
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Convert REAL data to COMPLEX form
 >>>>	
 >>>>	

 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Mon Mar  9 19:30:17 1992
 >>>>
 >>>>          Routines: main- the main program for vrtoc
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vrtoc.h"


/****************************************************************
 *
 * Routine Name:  main program for vrtoc
 *
 *       Input:  
 *       -i1  input image 
 *       -o  resulting output image 
 *
 *
 *       [-i2] input image
 *       [-t] Choose the type of conversion from real to complex
 *		1 (Real to real (imaginary=0 or 2nd image)),
 *		2 (Real to imaginary (real=0 or 2nd image)),
 *		3 (Real to magnitude (phase=0 or 2nd image)),
 *		or 4 (Real to phase (magnitude=1 or 2nd image))
 *		   [default = 1] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        struct xvimage *image1,*image2,*readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);
        image2 = NULL;
        image1 = readimage(vrtoc->i1_file);
        if (image1 == NULL) exit(1);
        CHECKINPUT(program,image1);
        if (vrtoc->i2_flag)
          {
            image2 = readimage(vrtoc->i2_file);
            if (image2 == NULL) exit(1);
            MATCHINPUT(program,image1,image2);
          }
/* -main_before_lib_call_end */

/* -main_library_call */
        if(! lvrtoc(image1, image2, vrtoc->t_toggle))
          {
            (void) fprintf(stderr, "lvrtoc Failed\\n");
            exit(1);
          }
/* -main_library_call_end */

/* -main_after_lib_call */
        writeimage(vrtoc->o_file,image1);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vrtoc 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vrtoc :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tConvert REAL data to COMPLEX form\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
        fprintf(stderr,"Available options for the conversion type (-t) are:\n");
        fprintf(stderr,"  1      Real input to real part of complex output (imaginary part=0 or image 2)\n");
        fprintf(stderr,"  2      Real input to imaginary part of complex output (real part = 0 or image 2)\n");
        fprintf(stderr,"  3      Real input to magnitude part of complex output (phase=0or image 2)\n");
        fprintf(stderr,"  4      Real input to phase part of output (magnitude=1 or image 2)\n\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-i2]  input image (infile) [null]\n");
	fprintf(stderr, "\t[-t]  Choose the type of conversion from real to complex\n");
	fprintf(stderr, "\t\t1  (Real to real (imaginary=0 or 2nd image)),\n");
	fprintf(stderr, "\t\t2  (Real to imaginary (real=0 or 2nd image)),\n");
	fprintf(stderr, "\t\t3  (Real to magnitude (phase=0 or 2nd image)),\n");
	fprintf(stderr, "\t\tor 4  (Real to phase (magnitude=1 or 2nd image))\n");
	fprintf(stderr, "\t\t[default = 1]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vrtoc\n");
	fprintf(stderr, "\t[-U] Gives the usage for vrtoc\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vrtoc.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vrtoc.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vrtoc
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) input image \n        {infile}: "; 
char	*t_pstr = "\nEnter: (t) Choose the type of conversion from real to complex -- \n      \t\t1 (Real to real (imaginary=0 or 2nd image))\n\t\t2 (Real to imaginary (real=0 or 2nd image))\n\t\t3 (Real to magnitude (phase=0 or 2nd image))\n\t\tor 4 (Real to phase (magnitude=1 or 2nd image))\n  [1]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vrtoc", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vrtoc.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vrtoc: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vrtoc.ans");
		}

	     }

	}

	/*
	 * allocate the vrtoc structure
	 */
	vrtoc = (vrtoc_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vrtoc_struct));

	/*
	 * get required arguments for vrtoc
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vrtoc->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(vrtoc->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vrtoc->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    vrtoc->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(vrtoc->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vrtoc->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vrtoc->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vrtoc->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vrtoc->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vrtoc->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vrtoc
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vrtoc->i2_flag = vget_infile(fid, prompt_flag,
	"-i2", i2_pstr, &(vrtoc->i2_file))
;


	/*
	 * get optional toggles for vrtoc
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		vrtoc->t_flag = vget_int(fid, prompt_flag,
		"-t", t_pstr, &(vrtoc->t_toggle),
		1, 0, 0);

		if ((vrtoc->t_toggle == 1 ) || 
		    (vrtoc->t_toggle == 2 ) || 
		    (vrtoc->t_toggle == 3 ) || 
		    (vrtoc->t_toggle == 4 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		vrtoc->t_flag = vget_int(fid, prompt_flag,
		"-t", t_pstr, &(vrtoc->t_toggle),
		1, 0, 0);

		if ((vrtoc->t_toggle != 1 ) && 
		    (vrtoc->t_toggle != 2 ) && 
		    (vrtoc->t_toggle != 3 ) && 
		    (vrtoc->t_toggle != 4 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



