 /*
  * Khoros: $Id: varviff.c,v 1.1 1991/05/10 15:49:44 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: varviff.c,v 1.1 1991/05/10 15:49:44 khoros Exp $";
#endif

 /*
  * $Log: varviff.c,v $
 * Revision 1.1  1991/05/10  15:49:44  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: varviff.c
 >>>>
 >>>>      Program Name: varviff
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Extracts a single data value from a viff structure  for  the
 >>>>	cantata parser.
 >>>>	
 >>>>	
 >>>>            Author: John Rasure and Carla Williams
 >>>>
 >>>> Date Last Updated: Fri Mar 22 14:36:52 1991
 >>>>
 >>>>          Routines: main- the main program for varviff
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "varviff.h"


/****************************************************************
 *
 * Routine Name:  main program for varviff
 *
 *       Input:  
 *         -i1  input file 
 *         -x  x location  
 *         -y  y location  
 *         -b  band number  
 *         -v  variable 
 *
 *
 *         [-i2] input file that is passed to output unmodified (used to gate operation)
 *         [-o] connecting file
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *img1, *img2, *readimage();
double value;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */

        if (check_args()) exit(1);

        img1 = readimage(varviff->i1_file);
        if (img1 == NULL)
        {
           fprintf(stderr,"%s: readimage failed for input image 1.\n",program);
           exit(1);
        }
        CHECKINPUT(program, img1);

        if (varviff->i2_flag) {
            img2 = readimage(varviff->i2_file);
            if (img2 == NULL) {
               fprintf(stderr,"%s: readimage failed for input image 2.\n",
                      program);
               exit(1);
            }
        }

/* -main_before_lib_call_end */

/* -main_library_call */
        if ( !lvarviff(img1, varviff->x_int, 
                         varviff->y_int,varviff->b_int, &value)) {
                (void) fprintf(stderr, "%s: lvarviff Failed\n", program);
                exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        if (varviff->o_flag && varviff->i2_flag) 
            (void) writeimage(varviff->o_file, img2);
        printf("%s = %g\n", varviff->v_string, value);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for varviff 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "varviff :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tExtracts a single data value from a viff structure  for  the\n");
	fprintf(stderr, "\tcantata parser.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  input file  (infile)\n");
	fprintf(stderr,"\t-x  x location  (integer)\n");
	fprintf(stderr,"\t-y  y location  (integer)\n");
	fprintf(stderr,"\t-b  band number  (integer)\n");
	fprintf(stderr,"\t-v  variable  (string)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-i2]  input file that is passed to output unmodified (used to gate operation) (infile) [null]\n");
	fprintf(stderr,"\t[-o]  connecting file (outfile) [null]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for varviff\n");
	fprintf(stderr, "\t[-U] Gives the usage for varviff\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called varviff.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses varviff.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for varviff
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) input file \n        {infile}: "; 
char	*x_pstr = 
	"\nEnter: (x) x location \n        {integer}: "; 
char	*y_pstr = 
	"\nEnter: (y) y location \n        {integer}: "; 
char	*b_pstr = 
	"\nEnter: (b) band number \n        {integer}: "; 
char	*v_pstr = 
	"\nEnter: (v) variable \n        {string}: "; 
char	*v_def = NULL;
char	*i2_pstr = 
	"\nEnter: (i2) input file that is passed to output unmodified (used to gate operation) \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) connecting file \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "varviff", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "varviff.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "varviff: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "varviff.ans");
		}

	     }

	}

	/*
	 * allocate the varviff structure
	 */
	varviff = (varviff_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (varviff_struct));

	/*
	 * get required arguments for varviff
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(varviff->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(varviff->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(varviff->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    varviff->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(varviff->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(varviff->x_flag = vget_int(fid, prompt_flag,
			"-x", x_pstr, &(varviff->x_int),
			0, 0, 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(varviff->x_flag))
		{
		    fprintf(stderr, "\t\tx is required, please re-enter: \n");
		    varviff->x_flag = vget_int(fid, prompt_flag,
		    "-x", x_pstr, &(varviff->x_int),
		    0, 0, 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-x' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(varviff->y_flag = vget_int(fid, prompt_flag,
			"-y", y_pstr, &(varviff->y_int),
			0, 0, 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(varviff->y_flag))
		{
		    fprintf(stderr, "\t\ty is required, please re-enter: \n");
		    varviff->y_flag = vget_int(fid, prompt_flag,
		    "-y", y_pstr, &(varviff->y_int),
		    0, 0, 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-y' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(varviff->b_flag = vget_int(fid, prompt_flag,
			"-b", b_pstr, &(varviff->b_int),
			0, 0, 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(varviff->b_flag))
		{
		    fprintf(stderr, "\t\tb is required, please re-enter: \n");
		    varviff->b_flag = vget_int(fid, prompt_flag,
		    "-b", b_pstr, &(varviff->b_int),
		    0, 0, 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-b' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(varviff->v_flag = vget_string(fid, prompt_flag,
			"-v", v_pstr, &(varviff->v_string),
			v_def)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(varviff->v_flag))
		{
		    fprintf(stderr, "\t\tv is required, please re-enter: \n");
		    varviff->v_flag = vget_string(fid, prompt_flag,
		    "-v", v_pstr, &(varviff->v_string),
		    v_def);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-v' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for varviff
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	varviff->i2_flag = vget_infile(fid, prompt_flag,
	"-i2", i2_pstr, &(varviff->i2_file))
;

	varviff->o_flag = vget_outfile(fid, prompt_flag,
	"-o", o_pstr, &(varviff->o_file))
;


}



