 /*
  * Khoros: $Id: vpad.c,v 1.2 1991/12/18 09:35:48 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vpad.c,v 1.2 1991/12/18 09:35:48 dkhoros Exp $";
#endif

 /*
  * $Log: vpad.c,v $
 * Revision 1.2  1991/12/18  09:35:48  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vpad.c
 >>>>
 >>>>      Program Name: vpad
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	pads a data sequence with a constant.
 >>>>	
 >>>>	

 >>>>            Author: Jeremy Worley
 >>>>
 >>>> Date Last Updated: Sat Dec 14 18:20:32 1991
 >>>>
 >>>>          Routines: main- the main program for vpad
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vpad.h"


/****************************************************************
 *
 * Routine Name:  main program for vpad
 *
 *       Input:  
 *      -i  input data file (xviff file) 
 *      -o  resulting output file (xviff file) 
 *
 *
 *      [-r] number of rows in the image to be generated  (value > 0)
 *      [-c] number of columns in the image to be generated  (value > 0)
 *      [-d] row offset of image  (value >= 0)
 *      [-e] column offset of image  (value >= 0)
 *      [-j] real part of pad constant 
 *      [-k] imaginary part of pad constant 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image_in,*image_out, *readimage();
int type;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
  if (check_args()) exit(1);

  image_in = readimage(vpad->i_file);

  if(image_in==NULL){
     (void)fprintf(stderr,"vpad:  Can not read input image.\n");
     exit(1);
  }

  proper_num_images(program,image_in,1,TRUE);
  proper_map_enable(program,image_in,VFF_MAP_OPTIONAL,TRUE);

  if(vpad->r_int < 1 || vpad->c_int <1){
     fprintf(stderr,"vpad:  Image dimension must be positive.\n");
     exit(1);
  }else if(vpad->d_int < 0 || vpad->e_int < 0){
     fprintf(stderr,"vpad:  Image offset must be non-negative.\n");
     exit(1);
  }

  type=image_in->data_storage_type;
/* -main_before_lib_call_end */

/* -main_library_call */
  if(!lvgconst(&image_out,vpad->r_int,vpad->c_int,
               type,vpad->j_float,
               vpad->k_float,(int)(image_in->num_data_bands))){
     fprintf(stderr,"lvgconst:  Image creation failed.\n");
     exit(1);
  }

  if(!lvinsert(image_out,image_in,vpad->e_int,vpad->d_int,
               vpad->j_float,vpad->k_float)){
     fprintf(stderr,"lvinsert:  Image insertion failed.\n");
     exit(1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
  writeimage(vpad->o_file,image_out);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vpad 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vpad :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tpads a data sequence with a constant.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input data file (xviff file)  (infile)\n");
	fprintf(stderr,"\t-o  resulting output file (xviff file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-r]  number of rows in the image to be generated (integer, > 0) [512]\n");
	fprintf(stderr,"\t[-c]  number of columns in the image to be generated (integer, > 0) [512]\n");
	fprintf(stderr,"\t[-d]  row offset of image (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-e]  column offset of image (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-j]  real part of pad constant (float) [0]\n");
	fprintf(stderr,"\t[-k]  imaginary part of pad constant (float) [0]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vpad\n");
	fprintf(stderr, "\t[-U] Gives the usage for vpad\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vpad.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vpad.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vpad
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input data file (xviff file) \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output file (xviff file) \n        {outfile}: "; 
char	*r_pstr = 
	"\nEnter: (r) number of rows in the image to be generated \n        {integer, > 0 [512] }: "; 
char	*c_pstr = 
	"\nEnter: (c) number of columns in the image to be generated \n        {integer, > 0 [512] }: "; 
char	*d_pstr = 
	"\nEnter: (d) row offset of image \n        {integer, >= 0 [0] }: "; 
char	*e_pstr = 
	"\nEnter: (e) column offset of image \n        {integer, >= 0 [0] }: "; 
char	*j_pstr = 
	"\nEnter: (j) real part of pad constant \n        {float [0.000000] }: "; 
char	*k_pstr = 
	"\nEnter: (k) imaginary part of pad constant \n        {float [0.000000] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vpad", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vpad.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vpad: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vpad.ans");
		}

	     }

	}

	/*
	 * allocate the vpad structure
	 */
	vpad = (vpad_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vpad_struct));

	/*
	 * get required arguments for vpad
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vpad->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vpad->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vpad->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vpad->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vpad->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vpad->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vpad->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vpad->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vpad->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vpad->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vpad
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vpad->r_flag = vget_int(fid, prompt_flag,
	"-r", r_pstr, &(vpad->r_int),
	512, 2, 2);

	vpad->c_flag = vget_int(fid, prompt_flag,
	"-c", c_pstr, &(vpad->c_int),
	512, 2, 2);

	vpad->d_flag = vget_int(fid, prompt_flag,
	"-d", d_pstr, &(vpad->d_int),
	0, 1, 1);

	vpad->e_flag = vget_int(fid, prompt_flag,
	"-e", e_pstr, &(vpad->e_int),
	0, 1, 1);

	vpad->j_flag = vget_float(fid, prompt_flag,
	"-j", j_pstr, &(vpad->j_float),
	0.000000, 0.000000, 0.000000);

	vpad->k_flag = vget_float(fid, prompt_flag,
	"-k", k_pstr, &(vpad->k_float),
	0.000000, 0.000000, 0.000000);


}



