 /*
  * Khoros: $Id: error.c,v 1.2 1991/10/02 00:18:22 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: error.c,v 1.2 1991/10/02 00:18:22 khoros Exp $";
#endif

 /*
  * $Log: error.c,v $
 * Revision 1.2  1991/10/02  00:18:22  khoros
 * HellPatch2
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "xvdisplay.h"
#include <X11/Xproto.h>


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name:  error.c                               <<<<
   >>>>                                                       <<<<
   >>>>   description:                                        <<<<
   >>>>                                                       <<<<
   >>>>      routines:  xvd_error_handler()                   <<<<
   >>>>                 xvd_io_error_handler()                <<<<
   >>>>                 xvd_xt_error_handler()                <<<<
   >>>>                                                       <<<<
   >>>> modifications:					      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */



/************************************************************
*
* Routine Name:  xvd_error_handler
*
*      Purpose:  This routine is used to handle Xlib errors.
*		 When an Xlib error is encountered then one
*		 of two things happen.  If the error is recoverable
*		 then xvdisplay returns 0 and continues on.  Otherwise
*		 it prints out the Xlib error message and exits the
*		 program.
*
*        Input:  display - the display that the error occured on.
*		 xerror  - the error that was encountered.
*
*    CALLED BY: internal routine
*
*   Written By: Mark Young
*
*
*************************************************************/


int xvd_error_handler(display, xerror)

Display	     *display;
XErrorEvent  *xerror;
{
	unsigned char request, error;


	request = xerror->request_code;
	error   = xerror->error_code;
	switch (request)
	{
	   case X_QueryTree:
	   case X_GetGeometry:
	   case X_GetWindowAttributes:
		if (error == BadWindow || error == BadPixmap ||
		    error == BadDrawable)
		   return(0);
		break;

	   case X_CreatePixmap:
		if (error == BadAlloc)
		   return(0);
		break;

	   default:
		XmuPrintDefaultErrorMessage(display, xerror, stderr);
		break;
	}

	(void) fprintf(stderr,"Major X error encountered for display '%s'! \
Unable to recover.\n\n", XDisplayName(display->display_name));
	exit(1);

	return(0); /* make saber happy */
}



/************************************************************
*
* Routine Name:  xvd_io_error_handler
*
*      Purpose:  This routine is used to handle Xlib errors.
*		 When an Xlib error is encountered then one
*		 of two things happen.  If the error is recoverable
*		 then cantata returns 0 and continues on.  Otherwise
*		 it prints out the Xlib error message and calls
*		 xvl_exit_program() which will clean up before
*		 existing.
*
*        Input:  display - the display that the error occured on.
*
*    CALLED BY: internal routine
*
*   Written By: Mark Young
*
*
*************************************************************/


int xvd_io_error_handler(display)

Display	     *display;
{

	(void) fprintf(stderr,"Major X error encountered for display '%s'! \
Unable to recover.\n\n", XDisplayName(display->display_name));
	exit(1);
}



/************************************************************
*
* Routine Name:  xvd_xt_error_handler
*
*      Purpose:  This routine is used to handle X toolkit errors.
*		 When an X toolkit error is encountered then one
*		 of two things happen.  If the error is recoverable
*		 then cantata returns 0 and continues on.  Otherwise
*		 it prints out the X toolkit error message and calls
*		 xvl_exit_program() which will clean up before
*		 existing.
*
*        Input:  message - a string with the error encountered.
*
*    CALLED BY: internal routine
*
*   Written By: Mark Young
*
*
*************************************************************/


XtErrorHandler xvd_xt_error_handler(message)

String message;
{
	(void)fprintf(stderr, "X Toolkit Error: %s\n", message);
	exit(1);

	return(0); /* make saber happy */
}



/************************************************************
*
* Routine Name:  xvd_xt_warning_handler
*
*      Purpose:  This routine is used to handle X toolkit warnings.
*		 When an X toolkit warnng is encountered then the
*		 warning is printed out and we return.
*
*        Input:  message - a string with the error encountered.
*
*    CALLED BY: internal routine
*
*   Written By: Mark Young
*
*
*************************************************************/


XtErrorHandler xvd_xt_warning_handler(message)

String message;
{
	if (khoros_verbose)
	   (void) printf("X Toolkit Warning: %s\n", message);

	return(0);
}
